/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.jenkins;

import com.saucelabs.ci.sauceconnect.SauceConnectManager;
import com.saucelabs.jenkins.HudsonSauceConnectManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HudsonSauceManagerFactory {
    private static final HudsonSauceManagerFactory INSTANCE = new HudsonSauceManagerFactory();
    private Lock accessLock = new ReentrantLock();
    private SauceConnectManager sauceConnectManager;

    public static HudsonSauceManagerFactory getInstance() {
        return INSTANCE;
    }

    private HudsonSauceManagerFactory() {
    }

    public SauceConnectManager createSauceConnectManager() {
        this.accessLock.lock();
        try {
            if (this.sauceConnectManager == null) {
                this.sauceConnectManager = new HudsonSauceConnectManager();
            }
            SauceConnectManager sauceConnectManager = this.sauceConnectManager;
            return sauceConnectManager;
        }
        finally {
            this.accessLock.unlock();
        }
    }
}

