/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.jenkinsci.plugins.saml.SamlFileResource;
import org.pac4j.core.exception.TechnicalException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

class SamlFileResourceCache
implements WritableResource {
    private static final Logger LOG = Logger.getLogger(SamlFileResource.class.getName());
    private String fileName;
    private static final Map<String, String> cache = new HashMap<String, String>();

    public SamlFileResourceCache(@NonNull String fileName) {
        LOG.log(Level.FINER, "Creating Resource cache: %s", fileName);
        this.fileName = fileName;
    }

    public SamlFileResourceCache(@NonNull String fileName, @NonNull String data) {
        LOG.log(Level.FINER, "Creating Resource cache from data: %s", fileName);
        this.fileName = fileName;
        try {
            this.save(fileName, data);
        }
        catch (UnsupportedEncodingException e) {
            throw new TechnicalException("Could not get string bytes.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Could not save the " + fileName + " file.", (Throwable)e);
        }
    }

    public boolean exists() {
        return new File(this.fileName).exists();
    }

    public boolean isReadable() {
        return new File(this.fileName).canRead();
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws MalformedURLException {
        return this.getURI().toURL();
    }

    public URI getURI() {
        return this.getFile().toURI();
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getDescription() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        LOG.log(Level.FINER, "Get cache inputStream : %s", this.fileName);
        if (cache.containsKey(this.fileName)) {
            return IOUtils.toInputStream((String)cache.get(this.fileName), (String)"UTF-8");
        }
        return FileUtils.openInputStream((File)this.getFile());
    }

    public File getFile() {
        return new File(this.fileName);
    }

    public long contentLength() {
        return this.getFile().length();
    }

    public long lastModified() {
        return this.getFile().lastModified();
    }

    public Resource createRelative(String s) {
        throw new NotImplementedException();
    }

    public boolean isWritable() {
        return new File(this.fileName).canWrite();
    }

    public OutputStream getOutputStream() throws IOException {
        LOG.log(Level.FINER, "Creating cache outputStream: %s", this.fileName);
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                SamlFileResourceCache.this.save(SamlFileResourceCache.this.fileName, IOUtils.toString((byte[])this.buf, (String)"UTF-8").trim());
            }
        };
    }

    private boolean isNew(String fileName, String data) {
        String oldData = cache.containsKey(fileName) ? cache.get(fileName) : "";
        String md5SumNew = DigestUtils.md5Hex((String)data);
        String md5SumOld = DigestUtils.md5Hex((String)oldData);
        return !md5SumNew.equals(md5SumOld);
    }

    private void save(@NonNull String fileName, @NonNull String data) throws IOException {
        if (this.isNew(fileName, data)) {
            LOG.log(Level.FINER, "Save resource to disk : %s", fileName);
            Files.write(new File(fileName).toPath(), data.getBytes("UTF-8"), new OpenOption[0]);
            cache.put(fileName, data);
        }
    }
}

