/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.scm.ChangeLogSet;
import hudson.triggers.SCMTrigger;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.rocketchatnotifier.CommitInfoChoice;
import jenkins.plugins.rocketchatnotifier.FineGrainedNotifier;
import jenkins.plugins.rocketchatnotifier.MessageBuilder;
import jenkins.plugins.rocketchatnotifier.RocketChatNotifier;
import jenkins.plugins.rocketchatnotifier.RocketClient;
import jenkins.plugins.rocketchatnotifier.model.MessageAttachment;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;
import org.apache.commons.lang.StringUtils;

public class ActiveNotifier
implements FineGrainedNotifier {
    private static final Logger LOGGER = Logger.getLogger(RocketChatNotifier.class.getName());
    RocketChatNotifier notifier;
    BuildListener listener;

    public ActiveNotifier(RocketChatNotifier notifier, BuildListener listener) {
        this.notifier = notifier;
        this.listener = listener;
    }

    private RocketClient getRocket(AbstractBuild r) throws RocketClientException {
        return this.notifier.newRocketChatClient(r, this.listener);
    }

    @Override
    public void deleted(AbstractBuild r) {
    }

    @Override
    public void started(AbstractBuild build) {
        try {
            Cause scmCause;
            CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
            if (causeAction != null && (scmCause = causeAction.findCause(SCMTrigger.SCMTriggerCause.class)) == null) {
                MessageBuilder message = new MessageBuilder(this.notifier, build, false);
                message.append(causeAction.getShortDescription());
                this.notifyStart(build, message.appendOpenLink().toString());
                return;
            }
            String changes = this.getChanges(build, this.notifier.includeCustomMessage(), false);
            if (changes != null) {
                this.notifyStart(build, changes);
            } else {
                this.notifyStart(build, this.getBuildStatusMessage(build, false, this.notifier.includeCustomMessage(), false));
            }
        }
        catch (RocketClientException e) {
            LOGGER.warning("Could not send rocket message: " + e.getMessage());
        }
    }

    private void notifyStart(AbstractBuild build, String message) throws RocketClientException {
        this.getRocket(build).publish(message, MessageAttachment.convertMessageAttachmentsToMaps(this.notifier.getAttachments()));
    }

    @Override
    public void finalized(AbstractBuild r) {
    }

    @Override
    public void completed(AbstractBuild r) {
        try {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Build completed. Checking for rocket notifiers");
            }
            if (r != null) {
                AbstractBuild previousBuild;
                AbstractProject project = r.getProject();
                Result result = r.getResult();
                if (project != null && (previousBuild = project.getLastBuild()) != null) {
                    Result previousResult;
                    while ((previousBuild = (AbstractBuild)previousBuild.getPreviousCompletedBuild()) != null && previousBuild.getResult() == Result.ABORTED) {
                    }
                    Result result2 = previousResult = previousBuild != null ? previousBuild.getResult() : Result.SUCCESS;
                    if (result == Result.ABORTED && this.notifier.getNotifyAborted() || result == Result.FAILURE && previousResult != Result.FAILURE && this.notifier.getNotifyFailure() || result == Result.FAILURE && previousResult == Result.FAILURE && this.notifier.getNotifyRepeatedFailure() || result == Result.NOT_BUILT && this.notifier.getNotifyNotBuilt() || result == Result.SUCCESS && (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) && this.notifier.getNotifyBackToNormal() || result == Result.SUCCESS && this.notifier.getNotifySuccess() || result == Result.UNSTABLE && this.notifier.getNotifyUnstable()) {
                        this.getRocket(r).publish(this.getBuildStatusMessage(r, this.notifier.includeTestSummary(), this.notifier.includeCustomMessage(), true), MessageAttachment.convertMessageAttachmentsToMaps(this.notifier.getAttachments()));
                        if (this.notifier.getCommitInfoChoice() != null && this.notifier.getCommitInfoChoice().showAnything()) {
                            this.getRocket(r).publish(this.getCommitList(r), MessageAttachment.convertMessageAttachmentsToMaps(this.notifier.getAttachments()));
                        }
                        if (result == Result.FAILURE && this.notifier.includeTestLog()) {
                            this.getRocket(r).publish(this.getLog(r), MessageAttachment.convertMessageAttachmentsToMaps(this.notifier.getAttachments()));
                        }
                    }
                }
            }
        }
        catch (RocketClientException e) {
            LOGGER.warning("Could not send rocket message: " + e.getMessage());
        }
    }

    String getChanges(AbstractBuild r, boolean includeCustomMessage, boolean finished) {
        if (!r.hasChangeSetComputed()) {
            LOGGER.info("No change set computed...");
            return null;
        }
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        HashSet files = new HashSet();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            LOGGER.info("Entry " + String.valueOf(o));
            entries.add(entry);
            files.addAll(entry.getAffectedFiles());
        }
        if (entries.isEmpty()) {
            LOGGER.info("Empty change...");
            return null;
        }
        HashSet<String> authors = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            authors.add(entry.getAuthor().getDisplayName());
        }
        MessageBuilder message = new MessageBuilder(this.notifier, r, finished);
        message.append("Started by changes from ");
        message.append(StringUtils.join(authors, (String)", "));
        message.append(" (");
        message.append(files.size());
        message.append(" file(s) changed)");
        message.appendOpenLink();
        if (includeCustomMessage) {
            message.appendCustomMessage();
        }
        return message.toString();
    }

    String getLog(AbstractBuild r) {
        MessageBuilder message = new MessageBuilder(this.notifier, r, true);
        message.appendLog();
        return message.toString();
    }

    String getCommitList(AbstractBuild r) {
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            LOGGER.info("Entry " + String.valueOf(o));
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            LOGGER.info("Empty change...");
            Cause.UpstreamCause c = (Cause.UpstreamCause)r.getCause(Cause.UpstreamCause.class);
            if (c == null) {
                return "No Changes.";
            }
            String upProjectName = c.getUpstreamProject();
            int buildNumber = c.getUpstreamBuild();
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(upProjectName, AbstractProject.class);
            if (project != null) {
                AbstractBuild upBuild = project.getBuildByNumber(buildNumber);
                return this.getCommitList(upBuild);
            }
        }
        HashSet<String> commits = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            StringBuffer commit = new StringBuffer();
            CommitInfoChoice commitInfoChoice = this.notifier.getCommitInfoChoice();
            if (commitInfoChoice.showTitle()) {
                commit.append(entry.getMsg());
            }
            if (commitInfoChoice.showAuthor()) {
                commit.append(" [").append(entry.getAuthor().getDisplayName()).append("]");
            }
            commits.add(commit.toString());
        }
        MessageBuilder message = new MessageBuilder(this.notifier, r, true);
        message.append("Changes:\n- ");
        message.append(StringUtils.join(commits, (String)"\n- "));
        return message.toString();
    }

    String getBuildStatusMessage(AbstractBuild r, boolean includeTestSummary, boolean includeCustomMessage, boolean finished) {
        MessageBuilder message = new MessageBuilder(this.notifier, r, finished);
        message.appendStatusMessage();
        message.appendDuration();
        message.appendOpenLink();
        if (includeTestSummary) {
            message.appendTestSummary();
        }
        if (includeCustomMessage) {
            message.appendCustomMessage();
        }
        return message.toString();
    }
}

