/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.repo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ProjectState
implements Serializable {
    private final String path;
    private final String serverPath;
    private final String revision;
    private static Logger debug = Logger.getLogger("hudson.plugins.repo.ProjectState");
    private static Map<Integer, ProjectState> projectStateCache = new HashMap<Integer, ProjectState>();

    static synchronized ProjectState constructCachedInstance(String path, String serverPath, String revision) {
        ProjectState projectState = projectStateCache.get(ProjectState.calculateHashCode(path, serverPath, revision));
        if (projectState == null) {
            projectState = new ProjectState(path, serverPath, revision);
            projectStateCache.put(projectState.hashCode(), projectState);
        }
        return projectState;
    }

    private ProjectState(String path, String serverPath, String revision) {
        this.path = path;
        this.serverPath = serverPath;
        this.revision = revision;
        debug.log(Level.FINE, "path: " + path + " serverPath: " + serverPath + " revision: " + revision);
    }

    private synchronized Object readResolve() {
        ProjectState projectState = projectStateCache.get(ProjectState.calculateHashCode(this.path, this.serverPath, this.revision));
        if (projectState == null) {
            projectStateCache.put(this.hashCode(), this);
            projectState = this;
        }
        return projectState;
    }

    public String getPath() {
        return this.path;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectState)) {
            return false;
        }
        ProjectState other = (ProjectState)obj;
        return (this.path == null ? other.path == null : this.path.equals(other.path)) && (this.serverPath == null ? other.serverPath == null : this.serverPath.equals(other.serverPath)) && (this.revision == null ? other.revision == null : this.revision.equals(other.revision));
    }

    public int hashCode() {
        return ProjectState.calculateHashCode(this.path, this.serverPath, this.revision);
    }

    private static int calculateHashCode(String path, String serverPath, String revision) {
        return 23 + (path == null ? 37 : path.hashCode()) + (serverPath == null ? 97 : serverPath.hashCode()) + (revision == null ? 389 : revision.hashCode());
    }
}

