/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.repo;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.plugins.repo.ChangeLogEntry;
import hudson.plugins.repo.ProjectState;
import hudson.plugins.repo.RepoChangeLogSet;
import hudson.plugins.repo.RevisionState;
import hudson.scm.ChangeLogParser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.AtomicFileWriter;
import hudson.util.XStream2;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.SAXException;

class ChangeLog
extends ChangeLogParser {
    private static Logger debug = Logger.getLogger("hudson.plugins.repo.ChangeLog");

    ChangeLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepoChangeLogSet parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
        List r;
        XStream2 xs = new XStream2();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(changelogFile), "UTF-8"));){
            Object obj = xs.fromXML((Reader)reader);
            r = (List)obj;
        }
        return new RepoChangeLogSet(build, browser, r);
    }

    private static List<ChangeLogEntry> generateChangeLog(@Nonnull RevisionState currentState, @Nullable RevisionState previousState, Launcher launcher, FilePath workspace, boolean showAllChanges) throws IOException, InterruptedException {
        List<ProjectState> changes = currentState.whatChanged(previousState);
        debug.log(Level.FINEST, "generateChangeLog: changes " + String.valueOf(changes));
        if (changes == null || changes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> commands = new ArrayList<Object>(5);
        ArrayList<ChangeLogEntry> logs = new ArrayList<ChangeLogEntry>();
        for (ProjectState change : changes) {
            debug.log(Level.FINEST, "change: " + String.valueOf(change));
            String newRevision = currentState.getRevision(change.getPath());
            if (change.getRevision() == null) {
                logs.add(new ChangeLogEntry(change.getPath(), change.getServerPath(), newRevision, null, null, null, null, null, null, "This project was added to the manifest.", null));
                continue;
            }
            if (newRevision == null) {
                logs.add(new ChangeLogEntry(change.getPath(), change.getServerPath(), null, null, null, null, null, null, null, "This project was removed from the manifest.", null));
                continue;
            }
            FilePath gitdir = new FilePath(workspace, change.getPath());
            commands.clear();
            commands.add("git");
            commands.add("log");
            commands.add("--raw");
            if (!showAllChanges) {
                commands.add("--first-parent");
            }
            String format = "[[<as7d9m1R_MARK_A>]]%H[[<as7d9m1R_MARK_B>]%an[[<as7d9m1R_MARK_B>]%ae[[<as7d9m1R_MARK_B>]%aD[[<as7d9m1R_MARK_B>]%cn[[<as7d9m1R_MARK_B>]%ce[[<as7d9m1R_MARK_B>]%cD[[<as7d9m1R_MARK_B>]%s\n%b[[<as7d9m1R_MARK_B>]";
            commands.add("--format=\"[[<as7d9m1R_MARK_A>]]%H[[<as7d9m1R_MARK_B>]%an[[<as7d9m1R_MARK_B>]%ae[[<as7d9m1R_MARK_B>]%aD[[<as7d9m1R_MARK_B>]%cn[[<as7d9m1R_MARK_B>]%ce[[<as7d9m1R_MARK_B>]%cD[[<as7d9m1R_MARK_B>]%s\n%b[[<as7d9m1R_MARK_B>]\"");
            commands.add(change.getRevision() + ".." + newRevision);
            ByteArrayOutputStream gitOutput = new ByteArrayOutputStream();
            if (launcher.launch().stdout((OutputStream)gitOutput).pwd(gitdir).cmds(commands).join() != 0) {
                commands.remove(commands.size() - 1);
                commands.add("HEAD");
                launcher.launch().stdout((OutputStream)gitOutput).pwd(gitdir).cmds(commands).join();
            }
            String o = new String(gitOutput.toByteArray(), Charset.defaultCharset());
            String[] changelogs = o.split("\\[\\[<as7d9m1R_MARK_A>\\]\\]");
            debug.log(Level.INFO, o);
            for (String changelog : changelogs) {
                String[] parts = changelog.split("\\[\\[<as7d9m1R_MARK_B>\\]");
                if (parts.length < 9) continue;
                String revision = parts[0];
                String authorName = parts[1];
                String authorEmail = parts[2];
                String authorDate = parts[3];
                String committerName = parts[4];
                String committerEmail = parts[5];
                String committerDate = parts[6];
                String commitText = parts[7];
                String[] fileLines = parts[8].split("\n");
                ArrayList<ChangeLogEntry.ModifiedFile> modifiedFiles = new ArrayList<ChangeLogEntry.ModifiedFile>();
                block9: for (String fileLine : fileLines) {
                    int expectedLen;
                    String[] tabParts;
                    String[] spaceParts;
                    if (!fileLine.startsWith(":") || (spaceParts = fileLine.split(" ", 5)).length != 5 || (tabParts = spaceParts[4].split("\t"))[0].isEmpty()) continue;
                    char action = tabParts[0].charAt(0);
                    int n = expectedLen = action == 'C' || action == 'R' ? 3 : 2;
                    if (tabParts.length != expectedLen) continue;
                    switch (action) {
                        case 'M': {
                            modifiedFiles.add(new ChangeLogEntry.ModifiedFile(tabParts[1], EditType.EDIT));
                            continue block9;
                        }
                        case 'C': {
                            modifiedFiles.add(new ChangeLogEntry.ModifiedFile(tabParts[2], EditType.ADD));
                            continue block9;
                        }
                        case 'R': {
                            modifiedFiles.add(new ChangeLogEntry.ModifiedFile(tabParts[1], EditType.DELETE));
                            modifiedFiles.add(new ChangeLogEntry.ModifiedFile(tabParts[2], EditType.ADD));
                            continue block9;
                        }
                        case 'A': {
                            modifiedFiles.add(new ChangeLogEntry.ModifiedFile(tabParts[1], EditType.ADD));
                            continue block9;
                        }
                        case 'D': {
                            modifiedFiles.add(new ChangeLogEntry.ModifiedFile(tabParts[1], EditType.DELETE));
                            continue block9;
                        }
                        default: {
                            continue block9;
                        }
                    }
                }
                ChangeLogEntry nc = new ChangeLogEntry(change.getPath(), change.getServerPath(), revision, authorName, authorEmail, authorDate, committerName, committerEmail, committerDate, commitText, modifiedFiles);
                logs.add(nc);
                debug.log(Level.FINEST, nc.toString());
            }
        }
        return logs;
    }

    static void saveChangeLog(@Nonnull RevisionState currentState, @Nullable RevisionState previousState, File changelogFile, Launcher launcher, FilePath workspace, boolean showAllChanges) throws IOException, InterruptedException {
        List<ChangeLogEntry> logs = ChangeLog.generateChangeLog(currentState, previousState, launcher, workspace, showAllChanges);
        if (logs == null) {
            debug.info("No logs found");
            return;
        }
        XStream2 xs = new XStream2();
        try (AtomicFileWriter w = new AtomicFileWriter(changelogFile);){
            w.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            xs.toXML(logs, (Writer)w);
            w.commit();
        }
    }
}

