/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs.options;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.options.RetryOptions;
import jenkins.plugins.publish_over.view_defaults.Retry.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CifsOverrideRetryDefaults
implements RetryOptions,
Describable<CifsOverrideRetryDefaults> {
    private final int retries;
    private final long retryDelay;

    @DataBoundConstructor
    public CifsOverrideRetryDefaults(int retries, long retryDelay) {
        this.retries = retries;
        this.retryDelay = retryDelay;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public CifsOverrideRetryDefaultsDescriptor getDescriptor() {
        return (CifsOverrideRetryDefaultsDescriptor)Jenkins.get().getDescriptorByType(CifsOverrideRetryDefaultsDescriptor.class);
    }

    @Extension
    public static class CifsOverrideRetryDefaultsDescriptor
    extends Descriptor<CifsOverrideRetryDefaults> {
        @NonNull
        public String getDisplayName() {
            return "CifsOverrideRetryDefaultsDescriptor - not visible ...";
        }

        public FormValidation doCheckRetries(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckRetryDelay(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public Messages getCommonFieldNames() {
            return new Messages();
        }
    }
}

