/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs;

import java.io.Serializable;
import java.util.ArrayList;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.PublisherLabel;
import jenkins.plugins.publish_over.Retry;
import jenkins.plugins.publish_over_cifs.CifsCleanNodeProperties;
import jenkins.plugins.publish_over_cifs.CifsPublisherLabel;
import jenkins.plugins.publish_over_cifs.CifsRetry;
import jenkins.plugins.publish_over_cifs.CifsTransfer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;

public class CifsPublisher
extends BapPublisher<CifsTransfer> {
    private static final long serialVersionUID = 1L;
    public static final String CTX_KEY_NODE_PROPERTIES_DEFAULT = "cifs.np.default";
    public static final String CTX_KEY_NODE_PROPERTIES_CURRENT = "cifs.np.current";
    public static final String CTX_KEY_WINS_SERVER = "cifs.winsServer";

    @DataBoundConstructor
    public CifsPublisher(String configName, boolean verbose, ArrayList<CifsTransfer> transfers, boolean useWorkspaceInPromotion, boolean usePromotionTimestamp, CifsRetry retry, CifsPublisherLabel label) {
        super(configName, verbose, transfers, useWorkspaceInPromotion, usePromotionTimestamp, (Retry)retry, (PublisherLabel)label, null);
    }

    public void perform(BPHostConfiguration hostConfig, BPBuildInfo buildInfo) throws Exception {
        CifsCleanNodeProperties defaults = (CifsCleanNodeProperties)buildInfo.get(CTX_KEY_NODE_PROPERTIES_DEFAULT);
        if (buildInfo.onMaster()) {
            this.storeWinsServer(buildInfo, defaults);
        } else {
            CifsCleanNodeProperties current = (CifsCleanNodeProperties)buildInfo.get(CTX_KEY_NODE_PROPERTIES_CURRENT);
            if (!this.storeWinsServer(buildInfo, current)) {
                this.storeWinsServer(buildInfo, defaults);
            }
        }
        super.perform(hostConfig, buildInfo);
    }

    private boolean storeWinsServer(BPBuildInfo buildInfo, CifsCleanNodeProperties nodeProperties) {
        if (nodeProperties != null) {
            if (nodeProperties.getWinsServer() != null) {
                buildInfo.put(CTX_KEY_WINS_SERVER, (Serializable)((Object)nodeProperties.getWinsServer()));
            }
            return true;
        }
        return false;
    }

    public CifsRetry getRetry() {
        return (CifsRetry)super.getRetry();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (CifsPublisher)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

