/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.FormValidation;
import jenkins.plugins.publish_over.BPValidators;
import jenkins.plugins.publish_over_cifs.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CifsNodeProperties
extends NodeProperty<Node> {
    public static final String FORM_PREFIX = "poc-np.";
    private String winsServer;

    @DataBoundConstructor
    public CifsNodeProperties(String winsServer) {
        this.winsServer = winsServer;
    }

    public String getWinsServer() {
        return this.winsServer;
    }

    public void setWinsServer(String winsServer) {
        this.winsServer = winsServer;
    }

    @Extension
    public static class CifsWinsNodePropertyDescriptor
    extends NodePropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.winsNodeProperty_descriptor_displayName();
        }

        public FormValidation doCheckWinsServer(@QueryParameter String value) {
            return BPValidators.validateOptionalIp((String)value);
        }
    }
}

