/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs;

import hudson.Util;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over_cifs.CifsClient;
import jenkins.plugins.publish_over_cifs.Messages;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CifsHostConfiguration
extends BPHostConfiguration<CifsClient, Object> {
    private static final long serialVersionUID = 1L;
    public static final String SMB_URL_PREFIX = "smb://";
    private static final String FS = "/";
    private static final String PASSWORD_PLACEHOLDER = "****";
    public static final int DEFAULT_PORT = 445;
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final int SO_TIMEOUT_AFTER = 5000;
    private static final int URL_BUILDER_INITIAL_SIZE = 60;
    private static final int ESCAPED_BUILDER_SIZE_MULTIPLIER = 3;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String RESOLVE_WITH_WINS = "LMHOSTS,WINS,DNS,BCAST";
    private static final String RESOLVE_WITHOUT_WINS = "LMHOSTS,DNS,BCAST";
    public static final String CONFIG_PROPERTY_TIMEOUT = "jcifs.smb.client.responseTimeout";
    public static final String CONFIG_PROPERTY_SO_TIMEOUT = "jcifs.smb.client.soTimeout";
    public static final String CONFIG_PROPERTY_WINS = "jcifs.netbios.wins";
    public static final String CONFIG_PROPERTY_RESOLVE_ORDER = "jcifs.resolveOrder";
    public static final String CONFIG_PROPERTY_ENABLE_SMB2 = "jcifs.smb.client.enableSMB2";
    public static final String CONFIG_PROPERTY_DISABLE_SMB1 = "jcifs.smb.client.disableSMB1";
    private static final int LOW_NIBBLE_BIT_MASK = 15;
    private static final int HEX_LETTERS_START_AT = 10;
    private static final int HI_TO_LOW_NIBBLE_BIT_SHIFT = 4;
    private int timeout;
    private int bufferSize;
    private SmbVersions smbVersion = SmbVersions.SMB_V2;

    public static int getDefaultPort() {
        return 445;
    }

    public static int getDefaultTimeout() {
        return 30000;
    }

    public static int getDefaultBufferSize() {
        return 4096;
    }

    @DataBoundConstructor
    public CifsHostConfiguration(String name, String hostname, String username, String password, String remoteRootDir, int port, int timeout, int bufferSize) {
        super(name, hostname, username, password, remoteRootDir, port);
        this.timeout = timeout;
        this.bufferSize = bufferSize;
    }

    protected final String getPassword() {
        return super.getPassword();
    }

    public SmbVersions getSmbVersion() {
        return this.smbVersion;
    }

    @DataBoundSetter
    public void setSmbVersion(SmbVersions smbVersion) {
        this.smbVersion = smbVersion;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @DataBoundSetter
    public void setBufferSize(int bufferSize) {
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
    }

    public CifsClient createClient(BPBuildInfo buildInfo) {
        this.assertRequiredOptions();
        String url = this.buildUrl(false);
        CIFSContext context = null;
        try {
            context = this.configureJcifs(buildInfo);
        }
        catch (CIFSException e) {
            buildInfo.printIfVerbose(Messages.exception_jCifsException_testConfig(url, e.getMessage()));
        }
        if (context == null) {
            context = SingletonContext.getInstance();
        }
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(context, this.getDomain(), this.getUsername(false), this.getPassword());
        context = context.withCredentials((Credentials)auth);
        this.testConfig(context, url);
        return new CifsClient(context, buildInfo, url, this.bufferSize);
    }

    private CIFSContext configureJcifs(BPBuildInfo buildInfo) throws CIFSException {
        Properties props = new Properties();
        if (this.smbVersion == SmbVersions.SMB_V2 || this.smbVersion == SmbVersions.SMB_V3) {
            props.put(CONFIG_PROPERTY_ENABLE_SMB2, "true");
            props.put(CONFIG_PROPERTY_DISABLE_SMB1, "false");
        }
        String winsServer = (String)((Object)buildInfo.get("cifs.winsServer"));
        int soTimeout = this.timeout + 5000;
        if (winsServer == null) {
            buildInfo.printIfVerbose(Messages.console_config_noWins());
            props.remove(CONFIG_PROPERTY_WINS);
            props.put(CONFIG_PROPERTY_RESOLVE_ORDER, RESOLVE_WITHOUT_WINS);
        } else {
            buildInfo.printIfVerbose(Messages.console_config_wins(winsServer));
            props.put(CONFIG_PROPERTY_WINS, winsServer);
            props.put(CONFIG_PROPERTY_RESOLVE_ORDER, RESOLVE_WITH_WINS);
        }
        if (buildInfo.isVerbose()) {
            buildInfo.println(Messages.console_config_timout(this.timeout));
            buildInfo.println(Messages.console_config_soTimeout(soTimeout));
            buildInfo.println(Messages.console_config_bufferSize(this.bufferSize));
        }
        props.put(CONFIG_PROPERTY_TIMEOUT, Integer.toString(this.timeout));
        props.put(CONFIG_PROPERTY_SO_TIMEOUT, Integer.toString(soTimeout));
        return new BaseContext((Configuration)new PropertyConfiguration(props));
    }

    private String buildUrl(boolean hidePassword) {
        StringBuilder urlSB = new StringBuilder(60);
        urlSB.append(SMB_URL_PREFIX);
        this.addServer(urlSB);
        this.addSharename(urlSB);
        return urlSB.toString();
    }

    private void assertRequiredOptions() {
        if (this.getHostnameTrimmed() == null) {
            throw new BapPublisherException(Messages.exception_hostnameRequired());
        }
        if (Util.fixEmptyAndTrim((String)this.getRemoteRootDir()) == null) {
            throw new BapPublisherException(Messages.exception_shareRequired());
        }
    }

    private void addSharename(StringBuilder urlSB) {
        String share = this.getRemoteRootDir().replaceAll("\\\\", FS);
        if (!share.startsWith(FS)) {
            urlSB.append(FS);
        }
        urlSB.append(share);
        if (!share.endsWith(FS)) {
            urlSB.append(FS);
        }
    }

    private void addServer(StringBuilder urlSB) {
        urlSB.append(this.getHostnameTrimmed());
        if (this.getPort() != 445) {
            urlSB.append(":").append(this.getPort());
        }
    }

    private void addCredentials(StringBuilder urlSB, boolean hidePassword) {
        if (Util.fixEmptyAndTrim((String)this.getUsername()) != null) {
            String username = this.getUsername().trim();
            if (username.contains("\\")) {
                String[] parts = username.split("\\\\", 2);
                urlSB.append(CifsHostConfiguration.encode(parts[0])).append(";").append(CifsHostConfiguration.encode(parts[1].trim()));
            } else {
                urlSB.append(CifsHostConfiguration.encode(username));
            }
            if (Util.fixEmptyAndTrim((String)this.getPassword()) != null) {
                urlSB.append(":");
                urlSB.append(hidePassword ? PASSWORD_PLACEHOLDER : CifsHostConfiguration.encode(this.getPassword().trim()));
            }
            urlSB.append('@');
        }
    }

    private String getDomain() {
        String username;
        if (Util.fixEmptyAndTrim((String)this.getUsername()) != null && (username = this.getUsername().trim()).contains("\\")) {
            String[] parts = username.split("\\\\", 2);
            return parts[0];
        }
        return "";
    }

    private String getUsername(boolean withDomain) {
        if (withDomain) {
            return this.getUsername();
        }
        if (Util.fixEmptyAndTrim((String)this.getUsername()) != null) {
            String username = this.getUsername().trim();
            if (username.contains("\\")) {
                String[] parts = username.split("\\\\", 2);
                return parts[1];
            }
            return username;
        }
        return "";
    }

    private void testConfig(CIFSContext context, String url) {
        SmbFile file;
        try {
            file = this.createSmbFile(context, url);
        }
        catch (MalformedURLException mue) {
            throw new BapPublisherException(Messages.exception_malformedUrlException(this.buildUrl(true)));
        }
        try {
            if (!file.exists()) {
                throw new BapPublisherException(Messages.exception_shareNotExist(this.buildUrl(true)));
            }
            if (!file.canRead()) {
                throw new BapPublisherException(Messages.exception_cannotReadShare(this.buildUrl(true)));
            }
        }
        catch (SmbException smbe) {
            throw new BapPublisherException(Messages.exception_jCifsException_testConfig(this.buildUrl(true), smbe.getLocalizedMessage()), (Throwable)smbe);
        }
    }

    protected SmbFile createSmbFile(CIFSContext context, String url) throws MalformedURLException {
        return new SmbFile(url, context);
    }

    private static String encode(String raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder(raw.length() * 3);
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        CharBuffer buffer = CharBuffer.allocate(1);
        for (char c : raw.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                encoded.append(c);
                continue;
            }
            buffer.put(0, c);
            buffer.rewind();
            try {
                ByteBuffer bytes = encoder.encode(buffer);
                while (bytes.hasRemaining()) {
                    byte oneByte = bytes.get();
                    encoded.append('%');
                    encoded.append(CifsHostConfiguration.toDigit(oneByte >> 4 & 0xF));
                    encoded.append(CifsHostConfiguration.toDigit(oneByte & 0xF));
                }
            }
            catch (CharacterCodingException cce) {
                throw new BapPublisherException(Messages.exception_encode_cce(cce.getLocalizedMessage()), (Throwable)cce);
            }
        }
        return encoded.toString();
    }

    private static char toDigit(int nibble) {
        return (char)(nibble < 10 ? 48 + nibble : 65 + nibble - 10);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return super.addToHashCode(builder).append(this.timeout).append(this.bufferSize);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, CifsHostConfiguration that) {
        return super.addToEquals(builder, (BPHostConfiguration)that).append(this.timeout, that.timeout).append(this.bufferSize, that.bufferSize);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return super.addToToString(builder).append("timeout", this.timeout).append("bufferSize", this.bufferSize);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (CifsHostConfiguration)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public Object readResolve() {
        if (this.bufferSize <= 0) {
            this.bufferSize = 4096;
        }
        return super.readResolve();
    }

    public static enum SmbVersions {
        CIFS_SMB_V1("SMB v1/CIFS"),
        SMB_V2("SMB v2"),
        SMB_V3("SMB v3");

        private String description;

        private SmbVersions(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }
    }
}

