/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs;

import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.CIFSContext;
import jcifs.smb.SmbFile;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPDefaultClient;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over_cifs.CifsHelper;
import jenkins.plugins.publish_over_cifs.CifsTransfer;
import jenkins.plugins.publish_over_cifs.Messages;
import org.apache.commons.io.IOUtils;

public class CifsClient
extends BPDefaultClient<CifsTransfer> {
    private final CifsHelper helper = new CifsHelper();
    private final BPBuildInfo buildInfo;
    private final String baseUrl;
    private String context;
    private int bufferSize;
    private final CIFSContext cifsContext;

    public CifsClient(CIFSContext cifsContext, BPBuildInfo buildInfo, String baseUrl, int bufferSize) {
        this.buildInfo = buildInfo;
        this.baseUrl = baseUrl;
        this.bufferSize = bufferSize;
        this.context = baseUrl;
        this.cifsContext = cifsContext;
    }

    protected String getContext() {
        return this.context;
    }

    CIFSContext getCifsContext() {
        return this.cifsContext;
    }

    public boolean changeToInitialDirectory() {
        this.context = this.baseUrl;
        return true;
    }

    public boolean changeDirectory(String directory) {
        String newLocation = this.createUrlForSubDir(directory);
        SmbFile dir = this.createFile(newLocation);
        if (this.helper.exists(dir, newLocation) && this.helper.canRead(dir, newLocation)) {
            this.context = newLocation;
            return true;
        }
        return false;
    }

    private String createUrlForSubDir(String directory) {
        return directory.endsWith("/") ? this.context + directory : this.context + directory + "/";
    }

    public boolean makeDirectory(String directory) {
        String newDirectoryUrl = this.createUrlForSubDir(directory);
        SmbFile dir = this.createFile(newDirectoryUrl);
        if (this.helper.exists(dir, newDirectoryUrl)) {
            throw new BapPublisherException(Messages.exception_mkdir_directoryExists(this.helper.hideUserInfo(newDirectoryUrl)));
        }
        if (this.buildInfo.isVerbose()) {
            this.buildInfo.println(Messages.console_mkdir(this.helper.hideUserInfo(newDirectoryUrl)));
        }
        this.helper.mkdirs(dir, newDirectoryUrl);
        return true;
    }

    public void deleteTree() throws IOException {
        SmbFile[] files;
        if (this.buildInfo.isVerbose()) {
            this.buildInfo.println(Messages.console_clean(this.helper.hideUserInfo(this.context)));
        }
        if ((files = this.helper.listFiles(this.createFile(this.context), this.context)) == null) {
            throw new BapPublisherException(Messages.exception_listFilesReturnedNull(this.helper.hideUserInfo(this.context)));
        }
        for (SmbFile file : files) {
            if (this.buildInfo.isVerbose()) {
                this.buildInfo.println(Messages.console_delete(this.helper.hideUserInfo(file.getCanonicalPath())));
            }
            this.helper.delete(file);
        }
    }

    public void beginTransfers(CifsTransfer transfer) {
        if (!transfer.hasConfiguredSourceFiles()) {
            throw new BapPublisherException(Messages.exception_noSourceFiles());
        }
    }

    public void transferFile(CifsTransfer transfer, FilePath filePath, InputStream content) throws IOException {
        String newFileUrl = this.context + filePath.getName();
        if (this.buildInfo.isVerbose()) {
            this.buildInfo.println(Messages.console_copy(this.helper.hideUserInfo(newFileUrl)));
        }
        try (OutputStream out = this.createFile(newFileUrl).getOutputStream();){
            IOUtils.copy((InputStream)content, (OutputStream)out, (int)this.bufferSize);
        }
    }

    public void disconnect() {
    }

    public void disconnectQuietly() {
    }

    private SmbFile createFile(String url) {
        try {
            return this.createSmbFile(url);
        }
        catch (MalformedURLException mue) {
            throw new BapPublisherException(Messages.exception_malformedUrlException(this.helper.hideUserInfo(url)));
        }
    }

    protected SmbFile createSmbFile(String url) throws MalformedURLException {
        return new SmbFile(url, this.cifsContext);
    }
}

