/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.config.disabledmetrics;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.prometheus.config.PrometheusConfiguration;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.DisabledMetricConfig;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.Entry;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.JobRegexDisabledMetric;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.NamedDisabledMetric;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.RegexDisabledMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricStatusChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricStatusChecker.class);

    public static boolean isEnabled(String metricName) {
        List<Entry> entries = MetricStatusChecker.getEntries();
        for (Entry entry : entries) {
            Pattern pattern;
            Matcher matcher;
            if (entry instanceof RegexDisabledMetric && (matcher = (pattern = Pattern.compile(((RegexDisabledMetric)entry).getRegex())).matcher(metricName)).matches()) {
                LOGGER.debug("Metric named '{}' is disabled via Jenkins Prometheus Plugin configuration. Reason: Regex", (Object)metricName);
                return false;
            }
            if (!(entry instanceof NamedDisabledMetric) || !metricName.equalsIgnoreCase(((NamedDisabledMetric)entry).getMetricName())) continue;
            LOGGER.debug("Metric named '{}' is disabled via Jenkins Prometheus Plugin configuration. Reason: Named", (Object)metricName);
            return false;
        }
        return true;
    }

    public static boolean isJobEnabled(String jobName) {
        List<Entry> entries = MetricStatusChecker.getEntries();
        for (Entry entry : entries) {
            Pattern pattern;
            Matcher matcher;
            if (!(entry instanceof JobRegexDisabledMetric) || !(matcher = (pattern = Pattern.compile(((JobRegexDisabledMetric)entry).getRegex())).matcher(jobName)).matches()) continue;
            LOGGER.debug("Job named '{}' is disabled via Jenkins Prometheus Plugin configuration. Reason: JobRegexDisabledMetric", (Object)jobName);
            return false;
        }
        return true;
    }

    public static Set<String> filter(List<String> allMetricNames) {
        if (allMetricNames == null) {
            return new HashSet<String>();
        }
        return allMetricNames.stream().filter(MetricStatusChecker::isEnabled).collect(Collectors.toSet());
    }

    private static List<Entry> getEntries() {
        PrometheusConfiguration configuration = PrometheusConfiguration.get();
        if (configuration == null) {
            LOGGER.warn("Cannot check if job is enabled. No PrometheusConfiguration");
            return List.of();
        }
        DisabledMetricConfig disabledMetricConfig = configuration.getDisabledMetricConfig();
        if (disabledMetricConfig == null) {
            LOGGER.debug("Cannot check if metric is enabled. No DisabledMetricConfig.");
            return List.of();
        }
        List<Entry> entries = disabledMetricConfig.getEntries();
        if (entries == null || entries.isEmpty()) {
            LOGGER.debug("Cannot check if metric is enabled. No entries specified in DisabledMetricConfig.");
            return List.of();
        }
        return entries;
    }
}

