/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.builds;

import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import hudson.model.Job;
import hudson.model.Run;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.Summary;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildsMetricCollector;
import org.jenkinsci.plugins.prometheus.util.FlowNodes;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageSummary
extends BuildsMetricCollector<Run<?, ?>, Summary> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StageSummary.class);

    protected StageSummary(String[] labelNames, String namespace, String subsystem, String namePrefix) {
        super(labelNames, namespace, subsystem, namePrefix);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.STAGE_SUMMARY;
    }

    @Override
    protected String getHelpText() {
        return "Summary of Jenkins build times by Job and Stage in the last build";
    }

    @Override
    protected SimpleCollector.Builder<?, Summary> getCollectorBuilder() {
        return Summary.build();
    }

    @Override
    public void calculateMetric(Run<?, ?> jenkinsObject, String[] labelValues) {
        if (jenkinsObject.isBuilding()) {
            return;
        }
        if (!(jenkinsObject instanceof WorkflowRun)) {
            return;
        }
        WorkflowRun workflowRun = (WorkflowRun)jenkinsObject;
        WorkflowJob job = (WorkflowJob)workflowRun.getParent();
        if (workflowRun.getExecution() != null) {
            this.processPipelineRunStages((Job)job, workflowRun, labelValues);
        }
    }

    private void processPipelineRunStages(Job job, WorkflowRun workflowRun, String[] labelValues) {
        List<StageNodeExt> stages = FlowNodes.getSortedStageNodes(workflowRun);
        for (StageNodeExt stage : stages) {
            if (stage == null) continue;
            this.observeStage(job, (Run)workflowRun, stage, labelValues);
        }
    }

    private void observeStage(Job job, Run run, StageNodeExt stage, String[] labelValues) {
        LOGGER.debug("Observing stage[{}] in run [{}] from job [{}]", new Object[]{stage.getName(), run.getNumber(), job.getName()});
        String stageName = stage.getName();
        String[] values = (String[])ArrayUtils.add((Object[])labelValues, (Object)stageName);
        if (stage.getStatus() == StatusExt.SUCCESS || stage.getStatus() == StatusExt.UNSTABLE) {
            LOGGER.debug("getting duration for stage[{}] in run [{}] from job [{}]", new Object[]{stage.getName(), run.getNumber(), job.getName()});
            long duration = stage.getDurationMillis();
            LOGGER.debug("duration was [{}] for stage[{}] in run [{}] from job [{}]", new Object[]{duration, stage.getName(), run.getNumber(), job.getName()});
            ((Summary.Child)((Summary)this.collector).labels(values)).observe((double)duration);
        } else {
            LOGGER.debug("Stage[{}] in run [{}] from job [{}] was not successful and will be ignored", new Object[]{stage.getName(), run.getNumber(), job.getName()});
        }
    }
}

