/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors;

import com.cloudbees.simplediskusage.DiskItem;
import com.cloudbees.simplediskusage.JobDiskItem;
import hudson.model.Job;
import hudson.model.LoadStatistics;
import hudson.model.Run;
import io.prometheus.client.Collector;
import java.nio.file.FileStore;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.coverage.CoverageCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.disk.DiskCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.jenkins.JenkinsCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.jobs.JobCollectorFactory;

public class CollectorFactory {
    private final BuildCollectorFactory buildCollectorFactory = new BuildCollectorFactory();
    private final JobCollectorFactory jobCollectorFactory = new JobCollectorFactory();
    private final JenkinsCollectorFactory jenkinsCollectorFactory = new JenkinsCollectorFactory();
    private final ExecutorCollectorFactory executorCollectorFactory = new ExecutorCollectorFactory();
    private final DiskCollectorFactory diskCollectorFactory = new DiskCollectorFactory();
    private final CoverageCollectorFactory coverageCollectorFactory = new CoverageCollectorFactory();

    public MetricCollector<Run<?, ?>, ? extends Collector> createCoverageRunCollector(CollectorType type, String[] labelNames) {
        return this.coverageCollectorFactory.createCollector(type, labelNames);
    }

    public MetricCollector<Run<?, ?>, ? extends Collector> createRunCollector(CollectorType type, String[] labelNames, String prefix) {
        return this.buildCollectorFactory.createCollector(type, labelNames, prefix);
    }

    public MetricCollector<Job<?, ?>, ? extends Collector> createJobCollector(CollectorType type, String[] labelNames) {
        return this.jobCollectorFactory.createCollector(type, labelNames);
    }

    public MetricCollector<Jenkins, ? extends Collector> createJenkinsCollector(CollectorType type, String[] labelNames) {
        return this.jenkinsCollectorFactory.createCollector(type, labelNames);
    }

    public MetricCollector<LoadStatistics.LoadStatisticsSnapshot, ? extends Collector> createLoadStatisticsCollector(CollectorType type, String[] labelNames, String prefix) {
        return this.executorCollectorFactory.createCollector(type, labelNames, prefix);
    }

    public MetricCollector<DiskItem, ? extends Collector> createDiskItemCollector(CollectorType type, String[] labelNames) {
        return this.diskCollectorFactory.createDiskItemCollector(type, labelNames);
    }

    public MetricCollector<JobDiskItem, ? extends Collector> createJobDiskItemCollector(CollectorType type, String[] labelNames) {
        return this.diskCollectorFactory.createJobDiskItemCollector(type, labelNames);
    }

    public MetricCollector<FileStore, ? extends Collector> createFileStoreCollector(CollectorType type, String[] labelNames) {
        return this.diskCollectorFactory.createFileStoreCollector(type, labelNames);
    }
}

