/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus;

import hudson.model.Label;
import hudson.model.LoadStatistics;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.prometheus.collectors.CollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorCollector
extends Collector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorCollector.class);

    public List<Collector.MetricFamilySamples> collect() {
        Label[] labels;
        LOGGER.debug("Collecting executor metrics for prometheus");
        CollectorFactory factory = new CollectorFactory();
        String prefix = "executors";
        String[] labelNameArray = new String[]{"label"};
        ArrayList<MetricCollector<LoadStatistics.LoadStatisticsSnapshot, ? extends Collector>> collectors = new ArrayList<MetricCollector<LoadStatistics.LoadStatisticsSnapshot, ? extends Collector>>();
        collectors.add(factory.createLoadStatisticsCollector(CollectorType.EXECUTORS_AVAILABLE_GAUGE, labelNameArray, prefix));
        collectors.add(factory.createLoadStatisticsCollector(CollectorType.EXECUTORS_BUSY_GAUGE, labelNameArray, prefix));
        collectors.add(factory.createLoadStatisticsCollector(CollectorType.EXECUTORS_CONNECTING_GAUGE, labelNameArray, prefix));
        collectors.add(factory.createLoadStatisticsCollector(CollectorType.EXECUTORS_DEFINED_GAUGE, labelNameArray, prefix));
        collectors.add(factory.createLoadStatisticsCollector(CollectorType.EXECUTORS_IDLE_GAUGE, labelNameArray, prefix));
        collectors.add(factory.createLoadStatisticsCollector(CollectorType.EXECUTORS_ONLINE_GAUGE, labelNameArray, prefix));
        collectors.add(factory.createLoadStatisticsCollector(CollectorType.EXECUTORS_QUEUE_LENGTH_GAUGE, labelNameArray, prefix));
        LOGGER.debug("getting load statistics for Executors");
        for (Label l : labels = Jenkins.get().getLabels().toArray(new Label[0])) {
            collectors.forEach(c -> c.calculateMetric(l.loadStatistics.computeSnapshot(), new String[]{l.getDisplayName()}));
        }
        return collectors.stream().map(MetricCollector::collect).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

