/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage.analyzer;

import hudson.PluginWrapper;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Item;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pluginusage.analyzer.AbstractProjectAnalyzer;

class MatrixProjectAnalyzer
extends AbstractProjectAnalyzer {
    private final boolean hasPlugin = Jenkins.get().getPlugin("matrix-project") != null;

    @Override
    protected Set<PluginWrapper> getPluginsFromBuilders(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (!this.hasPlugin) {
            return plugins;
        }
        if (item instanceof MatrixProject) {
            plugins.add(this.getPluginFromClass(MatrixProject.DescriptorImpl.class));
            MatrixProject matrixProject = (MatrixProject)item;
            List builders = matrixProject.getBuilders();
            for (Builder builder : builders) {
                plugins.addAll(this.getPluginsFromBuilder(builder));
            }
            for (BuildWrapper buildWrapper : matrixProject.getBuildWrappersList()) {
                plugins.add(this.getPluginFromClass(buildWrapper.getDescriptor().clazz));
            }
        }
        return plugins;
    }

    @Override
    protected boolean ignoreJob(Item item) {
        if (this.hasPlugin) {
            return item instanceof MatrixConfiguration;
        }
        return super.ignoreJob(item);
    }
}

