/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.OpenIdSsoSecurityRealm;
import hudson.security.SecurityRealm;
import jenkins.model.Jenkins;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;

public abstract class OpenIdExtension
implements ExtensionPoint {
    public boolean isApplicable(SecurityRealm realm) {
        return !(realm instanceof OpenIdSsoSecurityRealm) || ((OpenIdSsoSecurityRealm)realm).isApplicable(this);
    }

    public abstract void extend(AuthRequest var1) throws MessageException;

    public abstract void process(AuthSuccess var1, Identity var2) throws MessageException;

    public void extendFetch(FetchRequest request) throws MessageException {
    }

    protected <T> T getMessageAs(Class<T> c, AuthSuccess authSuccess, String typeUri) throws MessageException {
        MessageExtension me = authSuccess.getExtension(typeUri);
        return c.cast(me);
    }

    public static ExtensionList<OpenIdExtension> all() {
        return Jenkins.get().getExtensionList(OpenIdExtension.class);
    }

    public static void extendRequest(AuthRequest authRequest) throws MessageException {
        FetchRequest request = FetchRequest.createFetchRequest();
        SecurityRealm sr = Jenkins.get().getSecurityRealm();
        for (OpenIdExtension e : OpenIdExtension.all()) {
            if (!e.isApplicable(sr)) continue;
            e.extend(authRequest);
            e.extendFetch(request);
        }
        authRequest.addExtension((MessageExtension)request);
    }

    public static void processResponse(AuthSuccess authSuccess, Identity id) throws MessageException {
        SecurityRealm sc = Jenkins.get().getSecurityRealm();
        for (OpenIdExtension e : OpenIdExtension.all()) {
            if (!e.isApplicable(sc)) continue;
            e.process(authSuccess, id);
        }
    }
}

