/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.InstallerPathResolver;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.plugins.nodejs.tools.NodeJSInstaller;
import jenkins.plugins.nodejs.tools.ToolsUtils;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class MirrorNodeJSInstaller
extends NodeJSInstaller {
    private static final String PUBLIC_NODEJS_URL = "https://nodejs.org/dist";
    private final String mirrorURL;
    private String credentialsId;

    @DataBoundConstructor
    public MirrorNodeJSInstaller(@NonNull String id, @NonNull String mirrorURL, String npmPackages, long npmPackagesRefreshHours) {
        super(id, npmPackages, npmPackagesRefreshHours);
        this.mirrorURL = Util.fixEmptyAndTrim((String)mirrorURL);
    }

    public String getMirrorURL() {
        return this.mirrorURL;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        if (this.mirrorURL == null) {
            throw new NullPointerException("mirroURL is null");
        }
        return super.performInstallation(tool, node, log);
    }

    @Override
    public DownloadFromUrlInstaller.Installable getInstallable() throws IOException {
        DownloadFromUrlInstaller.Installable installable = super.getInstallable();
        return installable != null ? new MirrorNodeJSInstallable(installable) : installable;
    }

    private static URL toURL(String url) {
        URL result = null;
        String fixedURL = Util.fixEmptyAndTrim((String)url);
        if (fixedURL != null) {
            try {
                return new URL(fixedURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }

    protected final class MirrorNodeJSInstallable
    extends DownloadFromUrlInstaller.NodeSpecificInstallable {
        public MirrorNodeJSInstallable(DownloadFromUrlInstaller.Installable inst) {
            super((DownloadFromUrlInstaller)MirrorNodeJSInstaller.this, inst);
        }

        public DownloadFromUrlInstaller.NodeSpecificInstallable forNode(Node node, TaskListener log) throws IOException {
            InstallerPathResolver installerPathResolver = InstallerPathResolver.Factory.findResolverFor(this.id);
            String relativeDownloadPath = installerPathResolver.resolvePathFor(this.id, ToolsUtils.getPlatform(node), ToolsUtils.getCPU(node));
            String baseURL = MirrorNodeJSInstaller.this.mirrorURL.endsWith("/") ? this.url.replace(MirrorNodeJSInstaller.PUBLIC_NODEJS_URL, MirrorNodeJSInstaller.this.mirrorURL.substring(0, MirrorNodeJSInstaller.this.mirrorURL.length() - 1)) : this.url.replace(MirrorNodeJSInstaller.PUBLIC_NODEJS_URL, MirrorNodeJSInstaller.this.mirrorURL);
            if (MirrorNodeJSInstaller.this.credentialsId != null) {
                URL mirror = MirrorNodeJSInstaller.toURL(MirrorNodeJSInstaller.this.mirrorURL);
                List domainRequirements = URIRequirementBuilder.fromUri((String)MirrorNodeJSInstaller.this.mirrorURL).build();
                StandardUsernamePasswordCredentials credential = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)null, null, (List)domainRequirements).stream().filter(c -> MirrorNodeJSInstaller.this.credentialsId.equals(c.getId())).findFirst().orElse(null);
                if (credential != null) {
                    try {
                        baseURL = new URI(mirror.getProtocol(), this.bindCredentials(credential), mirror.getHost(), mirror.getPort(), mirror.getPath(), mirror.getQuery(), mirror.getRef()).toURL().toExternalForm();
                    }
                    catch (URISyntaxException e) {
                        throw new IOException("Error composing URL with credentials", e);
                    }
                } else {
                    throw new IOException(Messages.MirrorNodeJSInstaller_invalidCredentialsId(MirrorNodeJSInstaller.this.credentialsId));
                }
            }
            this.url = baseURL + relativeDownloadPath;
            return this;
        }

        private String bindCredentials(StandardUsernamePasswordCredentials credential) {
            String password = Secret.toString((Secret)credential.getPassword());
            String username = credential.getUsername();
            return StringUtils.isNotBlank((CharSequence)password) ? username + ":" + password : username;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DownloadFromUrlInstaller.DescriptorImpl<MirrorNodeJSInstaller> {
        private Pattern variableRegExp = Pattern.compile("\\$\\{.*\\}");

        public String getDisplayName() {
            return Messages.MirrorNodeJSInstaller_DescriptorImpl_displayName();
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item item, @QueryParameter String credentialsId, @QueryParameter String mirrorURL) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((CharSequence)credentialsId)) {
                return FormValidation.ok();
            }
            List domainRequirement = URIRequirementBuilder.fromUri((String)mirrorURL).build();
            if (CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)item, (Authentication)this.getAuthentication(item), (List)domainRequirement, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)).isEmpty() && CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)this.getAuthentication(item), (List)domainRequirement, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)).isEmpty()) {
                return FormValidation.error((String)Messages.NPMRegistry_DescriptorImpl_invalidCredentialsId());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String mirrorURL) {
            StandardListBoxModel result = new StandardListBoxModel();
            credentialsId = StringUtils.trimToEmpty((String)credentialsId);
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            Authentication authentication = this.getAuthentication(item);
            List build = URIRequirementBuilder.fromUri((String)mirrorURL).build();
            CredentialsMatcher either = CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class);
            Class<StandardUsernamePasswordCredentials> type = StandardUsernamePasswordCredentials.class;
            result.includeEmptyValue();
            if (item != null) {
                result.includeMatchingAs(authentication, item, type, build, either);
            } else {
                result.includeMatchingAs(authentication, (ItemGroup)Jenkins.get(), type, build, either);
            }
            return result;
        }

        @NonNull
        protected Authentication getAuthentication(Item item) {
            return item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM;
        }

        public FormValidation doCheckMirrorURL(@QueryParameter @CheckForNull String mirrorURL) throws IOException {
            if (StringUtils.isBlank((CharSequence)mirrorURL)) {
                return FormValidation.error((String)Messages.MirrorNodeJSInstaller_DescriptorImpl_emptyMirrorURL());
            }
            if (!this.variableRegExp.matcher(mirrorURL).find() && MirrorNodeJSInstaller.toURL(mirrorURL) == null) {
                return FormValidation.error((String)Messages.MirrorNodeJSInstaller_DescriptorImpl_invalidURL());
            }
            return FormValidation.ok();
        }

        @NonNull
        public List<? extends DownloadFromUrlInstaller.Installable> getInstallables() throws IOException {
            return ToolsUtils.getInstallable();
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == NodeJSInstallation.class;
        }
    }
}

