/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.pipeline;

import com.github.jenkins.lastchanges.LastChangesPublisher;
import com.github.jenkins.lastchanges.LastChangesUtil;
import com.github.jenkins.lastchanges.model.LastChanges;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

public class LastChangesPublisherScript
implements Serializable {
    private CpsScript cpsScript;
    private LastChangesPublisher publisher;

    public LastChangesPublisherScript(LastChangesPublisher publisher) {
        this.publisher = publisher;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public void doPublish(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.publisher.perform(build, workspace, launcher, listener);
    }

    @Whitelisted
    public LastChangesPublisherScript publishLastChanges() throws Exception {
        LinkedHashMap<String, LastChangesPublisherScript> stepVariables = new LinkedHashMap<String, LastChangesPublisherScript>();
        stepVariables.put("publisher", this);
        LastChangesPublisherScript buildInfo = (LastChangesPublisherScript)this.cpsScript.invokeMethod("publishLastChanges", stepVariables);
        buildInfo.setCpsScript(this.cpsScript);
        return buildInfo;
    }

    @Whitelisted
    public LastChanges getLastChanges() throws Exception {
        return this.publisher.getLastChanges();
    }

    @Whitelisted
    public String getHtmlDiff() throws IOException {
        LastChanges lastChanges = this.publisher.getLastChanges();
        return LastChangesUtil.toHtmlDiff(lastChanges, this.cpsScript.$build().getFullDisplayName().replace(" ", ""));
    }

    @Whitelisted
    public String getHtmlDiff(String title) throws IOException {
        LastChanges lastChanges = this.publisher.getLastChanges();
        return LastChangesUtil.toHtmlDiff(lastChanges, title);
    }

    @Whitelisted
    public String getDiff() throws IOException {
        LastChanges lastChanges = this.publisher.getLastChanges();
        return lastChanges.getDiff();
    }
}

