/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.model;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class CommitInfo
implements Serializable {
    public static final String newLine = System.getProperty("line.separator");
    private String commitId;
    private String commitMessage;
    private String committerName;
    private String committerEmail;
    private String commitDate;

    @Whitelisted
    public String getCommitterName() {
        return this.committerName;
    }

    @Deprecated
    public String getCommiterName() {
        return this.getCommitterName();
    }

    @Whitelisted
    public String getCommitDate() {
        return this.commitDate;
    }

    @Whitelisted
    public String getCommitId() {
        return this.commitId;
    }

    @Whitelisted
    public String getCommitterEmail() {
        return this.committerEmail;
    }

    @Deprecated
    public String getCommiterEmail() {
        return this.getCommitterEmail();
    }

    @Whitelisted
    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String format(Date date, TimeZone tz) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        dateFormat.setTimeZone(tz);
        return dateFormat.format(date);
    }

    public CommitInfo setCommitDate(String commitDate) {
        this.commitDate = commitDate;
        return this;
    }

    public CommitInfo setCommitId(String commitId) {
        this.commitId = commitId;
        return this;
    }

    public CommitInfo setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    public CommitInfo setCommitterName(String committerName) {
        this.committerName = committerName;
        return this;
    }

    @Deprecated
    public CommitInfo setCommiterName(String committerName) {
        return this.setCommitterName(committerName);
    }

    public CommitInfo setCommitterEmail(String committerEmail) {
        this.committerEmail = committerEmail;
        return this;
    }

    @Deprecated
    public CommitInfo setCommiterEmail(String committerEmail) {
        return this.setCommitterEmail(committerEmail);
    }

    public String getFormatedCommitId() {
        try {
            Long.parseLong(this.commitId);
            return this.commitId;
        }
        catch (NumberFormatException nfe) {
            return this.truncate(this.commitId, 8);
        }
    }

    private String truncate(String value, int length) {
        if (value == null || value.length() <= length) {
            return value;
        }
        return value.substring(0, length - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("Commit: ").append(this.commitId).append(newLine).append("Author: ").append(this.committerName).append(newLine).append("E-mail: ").append(this.committerEmail).append(newLine).append("Date: ").append(this.commitDate).append(newLine).append("Message: ").append(this.commitMessage).append(newLine).append(newLine);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitInfo that = (CommitInfo)o;
        return this.commitId != null ? this.commitId.equals(that.commitId) : that.commitId == null;
    }

    public int hashCode() {
        return this.committerName != null ? this.committerName.hashCode() : 0;
    }
}

