/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.model;

import com.github.jenkins.lastchanges.LastChangesUtil;
import com.github.jenkins.lastchanges.model.CommitInfo;
import java.io.Serializable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class CommitChanges
implements Serializable {
    private CommitInfo commitInfo;
    private String changes;
    private byte[] compressedChanges;

    public CommitChanges(CommitInfo commitInfo, String changes) {
        this.commitInfo = commitInfo;
        if (LastChangesUtil.shouldCompressDiff(changes)) {
            this.changes = null;
            this.compressedChanges = LastChangesUtil.compress(changes);
        } else {
            this.changes = changes;
            this.compressedChanges = null;
        }
    }

    @Whitelisted
    public CommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    @Whitelisted
    public String getChanges() {
        if (this.changes == null) {
            return LastChangesUtil.decompress(this.compressedChanges);
        }
        return this.changes;
    }

    public String getEscapedDiff() {
        String changes = this.getChanges();
        if (changes != null) {
            return StringEscapeUtils.escapeEcmaScript((String)changes);
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommitChanges)) {
            return false;
        }
        CommitChanges other = (CommitChanges)obj;
        if (this.commitInfo == null || other.commitInfo == null) {
            return false;
        }
        return this.commitInfo.equals(other.commitInfo);
    }
}

