/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges.impl;

import com.github.jenkins.lastchanges.api.VCSChanges;
import com.github.jenkins.lastchanges.exception.GitDiffException;
import com.github.jenkins.lastchanges.exception.GitTreeNotFoundException;
import com.github.jenkins.lastchanges.exception.GitTreeParseException;
import com.github.jenkins.lastchanges.exception.RepositoryNotFoundException;
import com.github.jenkins.lastchanges.model.CommitInfo;
import com.github.jenkins.lastchanges.model.LastChanges;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class GitLastChanges
implements VCSChanges<Repository, ObjectId> {
    private static GitLastChanges instance;

    private GitLastChanges() {
    }

    public static GitLastChanges getInstance() {
        if (instance == null) {
            instance = new GitLastChanges();
        }
        return instance;
    }

    public static Repository repository(String path) {
        if (path == null || path.isEmpty()) {
            throw new RepositoryNotFoundException("Git repository path cannot be empty.");
        }
        File repositoryPath = new File(path);
        if (!repositoryPath.exists()) {
            throw new RepositoryNotFoundException(String.format("Git repository path not found at location %s.", repositoryPath));
        }
        FileRepository repository = null;
        try {
            repository = new FileRepository(path);
        }
        catch (IOException e) {
            throw new RepositoryNotFoundException("Could not find git repository at " + path);
        }
        if (repository.isBare()) {
            throw new RepositoryNotFoundException(String.format("No git repository found at %s.", path));
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LastChanges changesOf(Repository repository) {
        Git git = new Git(repository);
        try {
            String repositoryLocation = repository.getDirectory().getAbsolutePath();
            ObjectId head = this.resolveCurrentRevision(repository);
            ObjectId previousHead = null;
            try {
                previousHead = repository.resolve("HEAD~^{tree}");
                if (previousHead == null) {
                    throw new GitTreeNotFoundException(String.format("Could not find previous head of repository located at %s. Its your first commit?", repositoryLocation));
                }
            }
            catch (IOException e) {
                throw new GitTreeNotFoundException("Could not resolve previous head of repository located at " + repositoryLocation, e);
            }
            LastChanges lastChanges = this.changesOf(repository, head, previousHead);
            return lastChanges;
        }
        finally {
            if (git != null) {
                git.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
    }

    @Override
    public ObjectId resolveCurrentRevision(Repository repository) {
        String repositoryLocation = repository.getDirectory().getAbsolutePath();
        try {
            return repository.resolve("HEAD^{tree}");
        }
        catch (IOException e) {
            throw new GitTreeNotFoundException("Could not resolve head of repository located at " + repositoryLocation, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LastChanges changesOf(Repository repository, ObjectId currentRevision, ObjectId previousRevision) {
        Git git = new Git(repository);
        try {
            ByteArrayOutputStream diffStream = new ByteArrayOutputStream();
            String repositoryLocation = repository.getDirectory().getAbsolutePath();
            DiffFormatter formatter = new DiffFormatter((OutputStream)diffStream);
            formatter.setRepository(repository);
            ObjectReader reader = repository.newObjectReader();
            CommitInfo lastCommitInfo = this.commitInfo(repository, currentRevision);
            CommitInfo oldCommitInfo = this.commitInfo(repository, previousRevision);
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            try {
                RevWalk revWalk = new RevWalk(repository);
                if (revWalk.parseAny((AnyObjectId)previousRevision) instanceof RevCommit) {
                    RevCommit revCommit = revWalk.parseCommit((AnyObjectId)previousRevision);
                    oldTreeIter.reset(reader, (AnyObjectId)revCommit.getTree().getId());
                } else {
                    oldTreeIter.reset(reader, (AnyObjectId)previousRevision);
                }
            }
            catch (Exception e) {
                throw new GitTreeParseException("Could not parse previous commit tree.", e);
            }
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            try {
                RevWalk revWalk = new RevWalk(repository);
                if (revWalk.parseAny((AnyObjectId)currentRevision) instanceof RevCommit) {
                    RevCommit revCommit = revWalk.parseCommit((AnyObjectId)currentRevision);
                    newTreeIter.reset(reader, (AnyObjectId)revCommit.getTree().getId());
                } else {
                    newTreeIter.reset(reader, (AnyObjectId)currentRevision);
                }
            }
            catch (IOException e) {
                throw new GitTreeParseException("Could not parse current commit tree.", e);
            }
            try {
                for (DiffEntry change : git.diff().setOldTree((AbstractTreeIterator)oldTreeIter).setNewTree((AbstractTreeIterator)newTreeIter).call()) {
                    formatter.format(change);
                }
            }
            catch (Exception e) {
                throw new GitDiffException("Could not get last changes from repository located at " + repositoryLocation, e);
            }
            LastChanges lastChanges = new LastChanges(lastCommitInfo, oldCommitInfo, new String(diffStream.toByteArray(), Charset.forName("UTF-8")));
            return lastChanges;
        }
        finally {
            if (git != null) {
                git.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
    }

    @Override
    public ObjectId getLastTagRevision(Repository repository) {
        Git git = new Git(repository);
        List tags = null;
        try {
            tags = git.tagList().call();
            final RevWalk walk = new RevWalk(repository);
            Collections.sort(tags, new Comparator<Ref>(){

                @Override
                public int compare(Ref o1, Ref o2) {
                    Date d1 = null;
                    Date d2 = null;
                    try {
                        d1 = walk.parseCommit((AnyObjectId)o1.getObjectId()).getCommitterIdent().getWhen();
                        d2 = walk.parseCommit((AnyObjectId)o2.getObjectId()).getCommitterIdent().getWhen();
                        return d2.compareTo(d1);
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        return 0;
                    }
                }
            });
            if (tags != null && !tags.isEmpty()) {
                Ref tag = (Ref)tags.get(0);
                Ref peeledRef = repository.getRefDatabase().peel(tag);
                LogCommand log = git.log();
                if (peeledRef.getPeeledObjectId() != null) {
                    log.add((AnyObjectId)peeledRef.getPeeledObjectId());
                } else {
                    log.add((AnyObjectId)tag.getObjectId());
                }
                Iterable logs = log.call();
                if (logs != null) {
                    return ((RevCommit)logs.iterator().next()).getId();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new GitDiffException("Could not get last tag from repository located at " + repository.getDirectory().getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitInfo commitInfo(Repository repository, ObjectId commitId) {
        RevWalk revWalk = new RevWalk(repository);
        CommitInfo commitInfo = new CommitInfo();
        PersonIdent committerIdent = null;
        RevCommit commit = null;
        try {
            if (revWalk.parseAny((AnyObjectId)commitId) instanceof RevCommit) {
                commit = revWalk.parseCommit((AnyObjectId)commitId);
                committerIdent = commit.getCommitterIdent();
            } else if (revWalk.parseAny((AnyObjectId)commitId) instanceof RevTree) {
                RevCommit rootCommit = revWalk.parseCommit((AnyObjectId)repository.resolve("HEAD"));
                revWalk.sort(RevSort.COMMIT_TIME_DESC);
                revWalk.markStart(rootCommit);
                RevTree tree = revWalk.parseTree((AnyObjectId)commitId);
                for (RevCommit revCommit : revWalk) {
                    if (!revCommit.getTree().getId().equals((AnyObjectId)tree.getId())) continue;
                    commit = revCommit;
                    committerIdent = commit.getCommitterIdent();
                    break;
                }
            }
            Date commitDate = committerIdent.getWhen();
            commitInfo.setCommitId(commit.getName()).setCommitMessage(commit.getFullMessage()).setCommitterName(committerIdent.getName()).setCommitterEmail(committerIdent.getEmailAddress());
            TimeZone tz = committerIdent.getTimeZone() != null ? committerIdent.getTimeZone() : TimeZone.getDefault();
            commitInfo.setCommitDate(commitInfo.format(commitDate, tz) + " " + tz.getDisplayName());
        }
        catch (Exception e) {
            Logger.getLogger(GitLastChanges.class.getName()).warning(String.format("Could not get commit info from revision %s due to following error " + e.getMessage() + (e.getCause() != null ? " - " + e.getCause() : ""), commitId));
        }
        finally {
            revWalk.dispose();
        }
        return commitInfo;
    }

    @Override
    public List<CommitInfo> getCommitsBetweenRevisions(Repository gitRepository, ObjectId currentRevision, ObjectId previousRevision) {
        ArrayList<CommitInfo> commits = new ArrayList<CommitInfo>();
        try {
            Iterable revCommits = new Git(gitRepository).log().addRange((AnyObjectId)previousRevision, (AnyObjectId)currentRevision).call();
            for (RevCommit commit : revCommits) {
                if (commit == null) continue;
                PersonIdent committerIdent = commit.getCommitterIdent();
                CommitInfo commitInfo = new CommitInfo();
                Date commitDate = committerIdent.getWhen();
                commitInfo.setCommitId(commit.getName()).setCommitMessage(commit.getFullMessage()).setCommitterName(committerIdent.getName()).setCommitterEmail(committerIdent.getEmailAddress());
                TimeZone tz = committerIdent.getTimeZone() != null ? committerIdent.getTimeZone() : TimeZone.getDefault();
                commitInfo.setCommitDate(commitInfo.format(commitDate, tz) + " " + tz.getDisplayName());
                commits.add(commitInfo);
            }
        }
        catch (Exception e) {
            Logger.getLogger(GitLastChanges.class.getName()).log(Level.WARNING, String.format("Could not get commits between current revision %s and previous revision %s.", currentRevision, previousRevision), e);
        }
        return commits;
    }
}

