/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges;

import com.github.jenkins.lastchanges.LastChangesBuildAction;
import com.github.jenkins.lastchanges.exception.CommitInfoException;
import com.github.jenkins.lastchanges.exception.LastChangesException;
import com.github.jenkins.lastchanges.exception.RepositoryNotFoundException;
import com.github.jenkins.lastchanges.impl.GitLastChanges;
import com.github.jenkins.lastchanges.impl.SvnLastChanges;
import com.github.jenkins.lastchanges.model.CommitChanges;
import com.github.jenkins.lastchanges.model.CommitInfo;
import com.github.jenkins.lastchanges.model.FormatType;
import com.github.jenkins.lastchanges.model.LastChanges;
import com.github.jenkins.lastchanges.model.LastChangesConfig;
import com.github.jenkins.lastchanges.model.MatchingType;
import com.github.jenkins.lastchanges.model.SinceType;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.SubversionSCM;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.RunList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.tasks.SimpleBuildStep;
import jenkins.triggers.SCMTriggerItem;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class LastChangesPublisher
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static Logger LOG = Logger.getLogger(LastChangesPublisher.class.getName());
    private static final String GIT_DIR = ".git";
    private static final String SVN_DIR = ".svn";
    private static final short RECURSION_DEPTH = 50;
    private String specificRevision;
    private String specificBuild;
    private SinceType since;
    private FormatType format;
    private MatchingType matching;
    private String vcsDir;
    private Boolean showFiles;
    private Boolean synchronisedScroll;
    private String matchWordsThreshold;
    private String matchingMaxComparisons;
    private boolean isGit = false;
    private boolean isSvn = false;
    private transient LastChanges lastChanges = null;
    private transient FilePath vcsDirFound = null;

    @DataBoundConstructor
    public LastChangesPublisher(SinceType since, FormatType format, MatchingType matching, Boolean showFiles, Boolean synchronisedScroll, String matchWordsThreshold, String matchingMaxComparisons, String specificRevision, String vcsDir, String specificBuild) {
        this.specificRevision = specificRevision;
        this.format = format;
        this.since = since;
        this.matching = matching;
        this.showFiles = showFiles;
        this.synchronisedScroll = synchronisedScroll;
        this.matchWordsThreshold = matchWordsThreshold;
        this.matchingMaxComparisons = matchingMaxComparisons;
        this.vcsDir = vcsDir;
        this.specificBuild = specificBuild;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean hasSpecificRevision;
        ISVNAuthenticationProvider svnAuthProvider = null;
        FilePath vcsDirParam = null;
        vcsDirParam = this.vcsDir != null && !"".equals(this.vcsDir.trim()) ? new FilePath(workspace, this.vcsDir) : workspace;
        if (this.findVCSDir(vcsDirParam, GIT_DIR)) {
            this.isGit = true;
        } else if (this.findVCSDir(vcsDirParam, SVN_DIR)) {
            this.isSvn = true;
            SubversionSCM scm = null;
            try {
                Collection scMs = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)build.getParent()).getSCMs();
                scm = (SubversionSCM)scMs.iterator().next();
                svnAuthProvider = scm.createAuthenticationProvider(build.getParent(), scm.getLocations()[0]);
            }
            catch (NoSuchMethodError e) {
                if (scm != null) {
                    svnAuthProvider = scm.getDescriptor().createAuthenticationProvider();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Problem creating svn auth provider", ex);
            }
        }
        if (!this.isGit && !this.isSvn) {
            throw new RuntimeException(String.format("Git or Svn directories not found in workspace %s.", vcsDirParam.toURI().toString()));
        }
        boolean hasTargetRevision = false;
        String targetRevision = null;
        String targetBuild = null;
        EnvVars env = build.getEnvironment(listener);
        if (this.specificRevision != null && !"".equals(this.specificRevision)) {
            targetRevision = env.expand(this.specificRevision);
        }
        boolean bl = hasSpecificRevision = targetRevision != null && !"".equals(targetRevision.trim());
        if (!hasSpecificRevision && this.specificBuild != null && !"".equals(this.specificBuild)) {
            targetBuild = env.expand(this.specificBuild);
            targetRevision = LastChangesPublisher.findBuildRevision(targetBuild, build.getParent().getBuilds());
            hasSpecificRevision = targetRevision != null && !"".equals(targetRevision.trim());
        }
        listener.getLogger().println("Publishing build last changes...");
        if (this.since != null && !hasSpecificRevision) {
            switch (this.since) {
                case LAST_SUCCESSFUL_BUILD: {
                    boolean hasSuccessfulBuild;
                    boolean bl2 = hasSuccessfulBuild = build.getParent().getLastSuccessfulBuild() != null;
                    if (hasSuccessfulBuild) {
                        LastChangesBuildAction action = (LastChangesBuildAction)build.getParent().getLastSuccessfulBuild().getAction(LastChangesBuildAction.class);
                        if (action == null || action.getBuildChanges().getCurrentRevision() == null) break;
                        targetRevision = action.getBuildChanges().getCurrentRevision().getCommitId();
                        break;
                    }
                    listener.error("No successful build found, last changes will use previous revision.");
                    break;
                }
                case LAST_TAG: {
                    try {
                        String lastTagRevision;
                        if (this.isGit) {
                            lastTagRevision = (String)this.vcsDirFound.act((FilePath.FileCallable)new GetGitLastTagRevisionCallable(listener));
                            if (lastTagRevision == null) break;
                            targetRevision = lastTagRevision;
                            break;
                        }
                        if (!this.isSvn || (lastTagRevision = (String)vcsDirParam.act((FilePath.FileCallable)new GetSvnLastTagRevisionCallable(listener, svnAuthProvider))) == null) break;
                        targetRevision = lastTagRevision;
                        break;
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Could not resolve last tag revision, last changes will use previous revision.", e);
                        listener.error("Could not resolve last tag revision, last changes will use previous revision.");
                    }
                }
            }
        }
        hasTargetRevision = targetRevision != null && !"".equals(targetRevision);
        try {
            if (this.isGit) {
                this.lastChanges = (LastChanges)this.vcsDirFound.act((FilePath.FileCallable)new GetGITLastChangesCallable(hasTargetRevision, targetRevision, listener));
            } else if (this.isSvn) {
                this.lastChanges = (LastChanges)vcsDirParam.act((FilePath.FileCallable)new GetSVNLastChangesCallable(hasTargetRevision, targetRevision, listener, svnAuthProvider));
            }
            String resultMessage = String.format("Last changes from revision %s (current) to %s (previous) published successfully!", this.truncate(this.lastChanges.getCurrentRevision().getCommitId(), 8), this.truncate(this.lastChanges.getPreviousRevision().getCommitId(), 8));
            listener.hyperlink("../" + build.getNumber() + "/" + "last-changes", resultMessage);
            listener.getLogger().println("");
            build.addAction((Action)new LastChangesBuildAction(build, this.lastChanges, new LastChangesConfig(this.since, this.specificRevision, this.format, this.matching, this.showFiles, this.synchronisedScroll, this.matchWordsThreshold, this.matchingMaxComparisons)));
        }
        catch (Exception e) {
            listener.error("Last Changes NOT published due to the following error: " + (e.getMessage() == null ? e.toString() : e.getMessage()) + (e.getCause() != null ? " - " + e.getCause() : ""));
            LOG.log(Level.SEVERE, "Could not publish LastChanges.", e);
        }
        build.setResult(Result.SUCCESS);
    }

    public LastChanges getLastChanges() {
        return this.lastChanges;
    }

    private static List<CommitChanges> obtainCommitChangesFromGit(Repository gitRepository, List<CommitInfo> commitInfoList) {
        if (commitInfoList == null || commitInfoList.isEmpty()) {
            return null;
        }
        ArrayList<CommitChanges> commitChanges = new ArrayList<CommitChanges>();
        try {
            Collections.sort(commitInfoList, new CommitsByDateComparator());
            for (int i = commitInfoList.size() - 1; i >= 0; --i) {
                ObjectId previousRevision = gitRepository.resolve(commitInfoList.get(i).getCommitId() + "^1");
                ObjectId currentRevision = gitRepository.resolve(commitInfoList.get(i).getCommitId());
                LastChanges lastChanges = GitLastChanges.getInstance().changesOf(gitRepository, currentRevision, previousRevision);
                String diff = lastChanges != null ? lastChanges.getDiff() : "";
                commitChanges.add(new CommitChanges(commitInfoList.get(i), diff));
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not get commit changes from Git.", e);
        }
        return commitChanges;
    }

    private static List<CommitChanges> obtainCommitChangesFromSvn(File svnRepository, List<CommitInfo> commitInfoList, String oldestCommit, ISVNAuthenticationProvider svnAuthProvider) {
        if (commitInfoList == null || commitInfoList.isEmpty()) {
            return null;
        }
        ArrayList<CommitChanges> commitChanges = new ArrayList<CommitChanges>();
        try {
            Collections.sort(commitInfoList, new CommitsByDateComparator());
            for (int i = commitInfoList.size() - 1; i >= 0; --i) {
                SVNRevision previousRevision = i == 0 ? SVNRevision.parse((String)oldestCommit) : SVNRevision.parse((String)commitInfoList.get(i - 1).getCommitId());
                SVNRevision currentRevision = SVNRevision.parse((String)commitInfoList.get(i).getCommitId());
                LastChanges lastChanges = SvnLastChanges.getInstance(svnAuthProvider).changesOf(svnRepository, currentRevision, previousRevision);
                String diff = lastChanges != null ? lastChanges.getDiff() : "";
                commitChanges.add(new CommitChanges(commitInfoList.get(i), diff));
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not get commit changes from SVN.", e);
        }
        return commitChanges;
    }

    private static String findBuildRevision(String targetBuild, RunList<?> builds) {
        if (builds == null || builds.isEmpty()) {
            return null;
        }
        Integer buildParam = null;
        try {
            buildParam = Integer.parseInt(targetBuild);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (buildParam == null) {
            throw new RuntimeException(String.format("%s is an invalid build number for 'specificBuild' param. It must resolve to an integer.", targetBuild));
        }
        LastChangesBuildAction actionFound = null;
        for (Run build : builds) {
            if (build.getNumber() != buildParam.intValue()) continue;
            actionFound = (LastChangesBuildAction)build.getAction(LastChangesBuildAction.class);
            break;
        }
        if (actionFound == null) {
            throw new RuntimeException(String.format("No build found with number %s. Maybe the build was discarded or not has published LastChanges.", buildParam));
        }
        return actionFound.getBuildChanges().getCurrentRevision().getCommitId();
    }

    private boolean isSlave() {
        return Computer.currentComputer() instanceof SlaveComputer;
    }

    private static SvnLastChanges getSvnLastChanges(ISVNAuthenticationProvider svnAuthProvider) {
        return svnAuthProvider != null ? SvnLastChanges.getInstance(svnAuthProvider) : SvnLastChanges.getInstance();
    }

    private String truncate(String value, int length) {
        if (value == null || value.length() <= length) {
            return value;
        }
        return value.substring(0, length - 1);
    }

    private boolean findVCSDir(FilePath workspace, String dir) throws IOException, InterruptedException {
        FilePath vcsDir = null;
        if (workspace.child(dir).exists()) {
            this.vcsDirFound = workspace.child(dir);
            return true;
        }
        for (int recursionDepth = 50; (vcsDir = this.findVCSDirInSubDirectories(workspace, dir)) == null && recursionDepth > 0; --recursionDepth) {
        }
        if (vcsDir == null) {
            return false;
        }
        this.vcsDirFound = vcsDir;
        return true;
    }

    private FilePath findVCSDirInSubDirectories(FilePath sourceDir, String dir) throws IOException, InterruptedException {
        List filePaths = sourceDir.listDirectories();
        if (filePaths == null || filePaths.isEmpty()) {
            return null;
        }
        Iterator iterator = sourceDir.listDirectories().iterator();
        if (iterator.hasNext()) {
            FilePath filePath = (FilePath)iterator.next();
            if (filePath.getName().equalsIgnoreCase(dir)) {
                return filePath;
            }
            return this.findVCSDirInSubDirectories(filePath, dir);
        }
        return null;
    }

    private FilePath getMasterWorkspaceDir(Run<?, ?> build) {
        if (build != null && build.getRootDir() != null) {
            return new FilePath(build.getRootDir());
        }
        return new FilePath(Paths.get("", new String[0]).toFile());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SinceType getSince() {
        return this.since;
    }

    public String getSpecificRevision() {
        return this.specificRevision;
    }

    public FormatType getFormat() {
        return this.format;
    }

    public MatchingType getMatching() {
        return this.matching;
    }

    public String getMatchWordsThreshold() {
        return this.matchWordsThreshold;
    }

    public String getMatchingMaxComparisons() {
        return this.matchingMaxComparisons;
    }

    public Boolean getShowFiles() {
        return this.showFiles;
    }

    public Boolean getSynchronisedScroll() {
        return this.synchronisedScroll;
    }

    public String getVcsDir() {
        return this.vcsDir;
    }

    public String getSpecificBuild() {
        return this.specificBuild;
    }

    @DataBoundSetter
    public void setSince(SinceType since) {
        this.since = since;
    }

    @DataBoundSetter
    public void setSpecificRevision(String specificRevision) {
        this.specificRevision = specificRevision;
    }

    @DataBoundSetter
    public void setFormat(FormatType format) {
        this.format = format;
    }

    @DataBoundSetter
    public void setMatching(MatchingType matching) {
        this.matching = matching;
    }

    @DataBoundSetter
    public void setMatchingMaxComparisons(String matchingMaxComparisons) {
        this.matchingMaxComparisons = matchingMaxComparisons;
    }

    @DataBoundSetter
    public void setMatchWordsThreshold(String matchWordsThreshold) {
        this.matchWordsThreshold = matchWordsThreshold;
    }

    @DataBoundSetter
    public void setShowFiles(Boolean showFiles) {
        this.showFiles = showFiles;
    }

    @DataBoundSetter
    public void setSynchronisedScroll(Boolean synchronisedScroll) {
        this.synchronisedScroll = synchronisedScroll;
    }

    @DataBoundSetter
    public void setVcsDir(String vcsDir) {
        this.vcsDir = vcsDir;
    }

    @DataBoundSetter
    public void setSpecificBuild(String buildNumber) {
        this.specificBuild = buildNumber;
    }

    private static final class CommitsByDateComparator
    implements Comparator<CommitInfo> {
        private CommitsByDateComparator() {
        }

        @Override
        public int compare(CommitInfo c1, CommitInfo c2) {
            try {
                DateFormat format = DateFormat.getDateTimeInstance(2, 2);
                return format.parse(c1.getCommitDate()).compareTo(format.parse(c2.getCommitDate()));
            }
            catch (ParseException e) {
                String couldNotParseCommitDatesErrorMsg = String.format("Could not parse commit dates %s and %s ", c1.getCommitDate(), c2.getCommitDate());
                LOG.severe(couldNotParseCommitDatesErrorMsg);
                throw new CommitInfoException(couldNotParseCommitDatesErrorMsg, e);
            }
        }
    }

    private static final class GetSVNLastChangesCallable
    extends MasterToSlaveFileCallable<LastChanges> {
        private final boolean hasTargetRevision;
        private final String targetRevision;
        private final TaskListener listener;
        private final ISVNAuthenticationProvider svnAuthProvider;

        public GetSVNLastChangesCallable(boolean hasTargetRevision, String targetRevision, TaskListener listener, ISVNAuthenticationProvider svnAuthProvider) {
            this.hasTargetRevision = hasTargetRevision;
            this.targetRevision = targetRevision;
            this.listener = listener;
            this.svnAuthProvider = svnAuthProvider;
        }

        public LastChanges invoke(File workspace, VirtualChannel channel) {
            if (workspace.exists() && workspace.isDirectory()) {
                return this.getSVNLastChanges(workspace);
            }
            String lastChangesWorkDirErrorMsg = "Last Changes Plugin: Could not find the SVN workspace directory in order to obtain the last changes of the revisions: " + workspace.getAbsolutePath();
            this.listener.error(lastChangesWorkDirErrorMsg);
            throw new RepositoryNotFoundException(lastChangesWorkDirErrorMsg);
        }

        private LastChanges getSVNLastChanges(File workspace) {
            try {
                LastChanges lastChanges;
                SvnLastChanges svnLastChanges = LastChangesPublisher.getSvnLastChanges(this.svnAuthProvider);
                File svnRepository = new File(workspace.getAbsolutePath());
                if (this.hasTargetRevision) {
                    Long svnRevision = Long.parseLong(this.targetRevision);
                    SVNRevision previousRevision = SVNRevision.create((long)svnRevision);
                    SVNRevision currentRevision = SVNRevision.HEAD;
                    lastChanges = svnLastChanges.changesOf(svnRepository, currentRevision, previousRevision);
                    currentRevision = SVNRevision.create((long)Long.parseLong(lastChanges.getCurrentRevision().getCommitId()));
                    List<CommitInfo> commitInfoList = SvnLastChanges.getInstance(this.svnAuthProvider).getCommitsBetweenRevisions(svnRepository, currentRevision, previousRevision);
                    String oldestCommit = lastChanges.getPreviousRevision().getCommitId();
                    lastChanges.addCommits(LastChangesPublisher.obtainCommitChangesFromSvn(svnRepository, commitInfoList, oldestCommit, this.svnAuthProvider));
                } else {
                    lastChanges = svnLastChanges.changesOf(svnRepository);
                    lastChanges.addCommit(new CommitChanges(lastChanges.getCurrentRevision(), lastChanges.getDiff()));
                }
                return lastChanges;
            }
            catch (LastChangesException e) {
                String lastChangesErrorMsg = "Last Changes Plugin: Last changes between revisions from SVN workspace were not obtained";
                this.listener.error(lastChangesErrorMsg);
                throw new LastChangesException(lastChangesErrorMsg, e);
            }
        }
    }

    private static final class GetGITLastChangesCallable
    extends MasterToSlaveFileCallable<LastChanges> {
        private final boolean hasTargetRevision;
        private final String targetRevision;
        private final TaskListener listener;

        public GetGITLastChangesCallable(boolean hasTargetRevision, String targetRevision, TaskListener listener) {
            this.hasTargetRevision = hasTargetRevision;
            this.targetRevision = targetRevision;
            this.listener = listener;
        }

        public LastChanges invoke(File workspace, VirtualChannel channel) {
            if (workspace.exists() && workspace.isDirectory()) {
                return this.getGITLastChanges(workspace);
            }
            String lastChangesWorkDirErrorMsg = "Last Changes Plugin: Could not find the workspace directory in order to obtain the last changes of the revisions: " + workspace.getAbsolutePath();
            this.listener.error(lastChangesWorkDirErrorMsg);
            throw new RepositoryNotFoundException(lastChangesWorkDirErrorMsg);
        }

        private LastChanges getGITLastChanges(File workspace) {
            try {
                LastChanges lastChanges;
                Repository gitRepository = GitLastChanges.repository(workspace.getAbsolutePath());
                if (this.hasTargetRevision) {
                    ObjectId previousRevision = gitRepository.resolve(this.targetRevision);
                    ObjectId currentRevision = GitLastChanges.getInstance().resolveCurrentRevision(gitRepository);
                    lastChanges = GitLastChanges.getInstance().changesOf(gitRepository, currentRevision, previousRevision);
                    currentRevision = gitRepository.resolve(lastChanges.getCurrentRevision().getCommitId());
                    List<CommitInfo> commitInfoList = GitLastChanges.getInstance().getCommitsBetweenRevisions(gitRepository, currentRevision, previousRevision);
                    lastChanges.addCommits(LastChangesPublisher.obtainCommitChangesFromGit(gitRepository, commitInfoList));
                } else {
                    lastChanges = GitLastChanges.getInstance().changesOf(gitRepository);
                    lastChanges.addCommit(new CommitChanges(lastChanges.getCurrentRevision(), lastChanges.getDiff()));
                }
                return lastChanges;
            }
            catch (IOException e) {
                String lastChangesErrorMsg = "Last Changes Plugin: Last changes between revisions from GIT workspace were not obtained";
                this.listener.error(lastChangesErrorMsg);
                throw new LastChangesException(lastChangesErrorMsg, e);
            }
        }
    }

    private static final class GetSvnLastTagRevisionCallable
    extends MasterToSlaveFileCallable<String> {
        private final TaskListener listener;
        private final ISVNAuthenticationProvider svnAuthProvider;

        public GetSvnLastTagRevisionCallable(TaskListener listener, ISVNAuthenticationProvider svnAuthProvider) {
            this.listener = listener;
            this.svnAuthProvider = svnAuthProvider;
        }

        public String invoke(File workspace, VirtualChannel virtualChannel) throws RepositoryNotFoundException {
            if (workspace.exists() && workspace.isDirectory()) {
                File svnRepository = new File(workspace.getAbsolutePath());
                SVNRevision lastTagRevision = LastChangesPublisher.getSvnLastChanges(this.svnAuthProvider).getLastTagRevision(svnRepository);
                if (lastTagRevision != null) {
                    return lastTagRevision.toString();
                }
                return null;
            }
            String lasTagRevisionErrorMsg = "Last Changes Plugin: Could not find the workspace directory for SVN in order to obtain the last changes of the revisions: " + workspace.getAbsolutePath();
            this.listener.error(lasTagRevisionErrorMsg);
            throw new RepositoryNotFoundException(lasTagRevisionErrorMsg);
        }
    }

    private static final class GetGitLastTagRevisionCallable
    extends MasterToSlaveFileCallable<String> {
        private final TaskListener listener;

        public GetGitLastTagRevisionCallable(TaskListener listener) {
            this.listener = listener;
        }

        public String invoke(File workspace, VirtualChannel virtualChannel) throws RepositoryNotFoundException {
            if (workspace.exists() && workspace.isDirectory()) {
                Repository gitRepository = GitLastChanges.repository(workspace.getAbsolutePath());
                ObjectId lastTagRevision = GitLastChanges.getInstance().getLastTagRevision(gitRepository);
                if (lastTagRevision != null) {
                    return lastTagRevision.name();
                }
                return null;
            }
            String lastTagRevisionErrorMsg = "Last Changes Plugin: Could not find the workspace directory for GIT in order to obtain the last changes of the revisions: " + workspace.getAbsolutePath();
            this.listener.error(lastTagRevisionErrorMsg);
            throw new RepositoryNotFoundException(lastTagRevisionErrorMsg);
        }
    }

    @Extension
    @Symbol(value={"lastChanges"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<Run<?, ?>> builds;

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Publish Last Changes";
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillFormatItems() {
            ListBoxModel items = new ListBoxModel();
            for (FormatType formatType : FormatType.values()) {
                items.add(formatType.getFormat(), formatType.name());
            }
            return items;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillMatchingItems() {
            ListBoxModel items = new ListBoxModel();
            for (MatchingType matchingType : MatchingType.values()) {
                items.add(matchingType.getMatching(), matchingType.name());
            }
            return items;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillSinceItems() {
            ListBoxModel items = new ListBoxModel();
            for (SinceType sinceType : SinceType.values()) {
                items.add(sinceType.getName(), sinceType.name());
            }
            return items;
        }

        public FormValidation doCheckSpecificBuild(@QueryParameter String specificBuild, @AncestorInPath AbstractProject project) {
            if (specificBuild == null || "".equals(specificBuild.trim())) {
                return FormValidation.ok();
            }
            boolean isOk = false;
            try {
                if (project.isParameterized() && specificBuild.contains("$")) {
                    return FormValidation.ok();
                }
                Integer.parseInt(specificBuild);
                LastChangesPublisher.findBuildRevision(specificBuild, project.getBuilds());
                isOk = true;
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Build number is invalid, it must resolve to an Integer.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isOk) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)String.format("Build #%s is invalid or does not exists anymore or not has published LastChanges.", specificBuild));
        }
    }
}

