/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenkins.lastchanges;

import com.github.jenkins.lastchanges.CommitRenderer;
import com.github.jenkins.lastchanges.DownloadRenderer;
import com.github.jenkins.lastchanges.LastChangesBaseAction;
import com.github.jenkins.lastchanges.model.CommitChanges;
import com.github.jenkins.lastchanges.model.LastChanges;
import com.github.jenkins.lastchanges.model.LastChangesConfig;
import hudson.model.Action;
import hudson.model.Run;
import jenkins.model.RunAction2;

public class LastChangesBuildAction
extends LastChangesBaseAction
implements RunAction2 {
    private transient Run<?, ?> build;
    private final LastChanges buildChanges;
    private final LastChangesConfig config;

    public LastChangesBuildAction(Run<?, ?> build, LastChanges lastChanges, LastChangesConfig config) {
        this.build = build;
        this.buildChanges = lastChanges;
        if (config == null) {
            config = new LastChangesConfig();
        }
        this.config = config;
    }

    @Override
    protected String getTitle() {
        return "Last Changes of Build #" + this.build.getNumber();
    }

    public LastChanges getBuildChanges() {
        return this.buildChanges;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public LastChangesConfig getConfig() {
        return this.config;
    }

    public CommitRenderer getCommit(String commitId) {
        CommitChanges commit = null;
        for (CommitChanges commitChanges : this.buildChanges.getCommits()) {
            if (!commitId.equals(commitChanges.getCommitInfo().getCommitId())) continue;
            commit = commitChanges;
            break;
        }
        return new CommitRenderer((Action)this, commit);
    }

    public DownloadRenderer getDownload() {
        return new DownloadRenderer(this.buildChanges, this.build.getFullDisplayName().replace(" ", ""), false);
    }

    public DownloadRenderer getDownloadHtml() {
        return new DownloadRenderer(this.buildChanges, this.build.getFullDisplayName().replace(" ", ""), true);
    }

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.onAttached(run);
    }
}

