package hudson.plugins.jira;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

/**
 * Created by Reda on 18/12/2014.
 */
public class JiraReleaseVersionUpdaterBuilder extends Builder implements SimpleBuildStep {

    private String jiraProjectKey;
    private String jiraRelease;
    private String jiraDescription;

    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Deprecated
    public JiraReleaseVersionUpdaterBuilder(String jiraProjectKey, String jiraRelease) {
        this.jiraRelease = jiraRelease;
        this.jiraProjectKey = jiraProjectKey;
    }

    @DataBoundConstructor
    public JiraReleaseVersionUpdaterBuilder(String jiraProjectKey, String jiraRelease, String jiraDescription) {
        this.jiraRelease = jiraRelease;
        this.jiraProjectKey = jiraProjectKey;
        this.jiraDescription = jiraDescription;
    }

    public String getJiraRelease() {
        return jiraRelease;
    }

    public void setJiraRelease(String jiraRelease) {
        this.jiraRelease = jiraRelease;
    }

    public String getJiraProjectKey() {
        return jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public String getJiraDescription() {
        return jiraDescription;
    }

    public void setJiraDescription(String jiraDescription) {
        this.jiraDescription = jiraDescription;
    }

    @Override
    public void perform(Run<?, ?> run, EnvVars env, TaskListener listener) {
        new VersionReleaser().perform(run.getParent(), jiraProjectKey, jiraRelease, jiraDescription, run, listener);
    }

    @Override
    public boolean requiresWorkspace() {
        return false;
    }

    @Override
    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    @Symbol("jiraMarkVersionReleased")
    public static final class DescriptorImpl extends BuildStepDescriptor<Builder> {

        private DescriptorImpl() {
            super(JiraReleaseVersionUpdaterBuilder.class);
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Override
        public String getDisplayName() {
            // Placed in the build settings section
            return Messages.JiraReleaseVersionBuilder_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/plugin/jira/help.html";
        }

        @Override
        public JiraReleaseVersionUpdaterBuilder newInstance(StaplerRequest2 req, JSONObject formData)
                throws FormException {
            return req.bindJSON(JiraReleaseVersionUpdaterBuilder.class, formData);
        }
    }
}
