// CHECKSTYLE:OFF

package hudson.plugins.jira;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JiraReleaseVersionMigrator.DisplayName}: {@code Jira: Move
     * issues matching JQL to the specified version}.
     * 
     * @return
     *     {@code Jira: Move issues matching JQL to the specified version}
     */
    public static String JiraReleaseVersionMigrator_DisplayName() {
        return holder.format("JiraReleaseVersionMigrator.DisplayName");
    }

    /**
     * Key {@code JiraReleaseVersionMigrator.DisplayName}: {@code Jira: Move
     * issues matching JQL to the specified version}.
     * 
     * @return
     *     {@code Jira: Move issues matching JQL to the specified version}
     */
    public static Localizable _JiraReleaseVersionMigrator_DisplayName() {
        return new Localizable(holder, "JiraReleaseVersionMigrator.DisplayName");
    }

    /**
     * Key {@code JiraVersionCreator.DisplayName}: {@code Jira: Create new
     * version}.
     * 
     * @return
     *     {@code Jira: Create new version}
     */
    public static String JiraVersionCreator_DisplayName() {
        return holder.format("JiraVersionCreator.DisplayName");
    }

    /**
     * Key {@code JiraVersionCreator.DisplayName}: {@code Jira: Create new
     * version}.
     * 
     * @return
     *     {@code Jira: Create new version}
     */
    public static Localizable _JiraVersionCreator_DisplayName() {
        return new Localizable(holder, "JiraVersionCreator.DisplayName");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.Failed}: {@code [Jira] An error
     * occurred while progressing issues:}.
     * 
     * @return
     *     {@code [Jira] An error occurred while progressing issues:}
     */
    public static String JiraIssueUpdateBuilder_Failed() {
        return holder.format("JiraIssueUpdateBuilder.Failed");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.Failed}: {@code [Jira] An error
     * occurred while progressing issues:}.
     * 
     * @return
     *     {@code [Jira] An error occurred while progressing issues:}
     */
    public static Localizable _JiraIssueUpdateBuilder_Failed() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.Failed");
    }

    /**
     * Key {@code JiraIssueFieldUpdater.NoIssueFieldID}: {@code Issue field
     * ID required}.
     * 
     * @return
     *     {@code Issue field ID required}
     */
    public static String JiraIssueFieldUpdater_NoIssueFieldID() {
        return holder.format("JiraIssueFieldUpdater.NoIssueFieldID");
    }

    /**
     * Key {@code JiraIssueFieldUpdater.NoIssueFieldID}: {@code Issue field
     * ID required}.
     * 
     * @return
     *     {@code Issue field ID required}
     */
    public static Localizable _JiraIssueFieldUpdater_NoIssueFieldID() {
        return new Localizable(holder, "JiraIssueFieldUpdater.NoIssueFieldID");
    }

    /**
     * Key {@code JiraReleaseVersionBuilder.DisplayName}: {@code Jira: Mark a
     * version as Released}.
     * 
     * @return
     *     {@code Jira: Mark a version as Released}
     */
    public static String JiraReleaseVersionBuilder_DisplayName() {
        return holder.format("JiraReleaseVersionBuilder.DisplayName");
    }

    /**
     * Key {@code JiraReleaseVersionBuilder.DisplayName}: {@code Jira: Mark a
     * version as Released}.
     * 
     * @return
     *     {@code Jira: Mark a version as Released}
     */
    public static Localizable _JiraReleaseVersionBuilder_DisplayName() {
        return new Localizable(holder, "JiraReleaseVersionBuilder.DisplayName");
    }

    /**
     * Key {@code JiraEnvironmentVariableBuilder.DisplayName}: {@code Jira:
     * Add related environment variables to build}.
     * 
     * @return
     *     {@code Jira: Add related environment variables to build}
     */
    public static String JiraEnvironmentVariableBuilder_DisplayName() {
        return holder.format("JiraEnvironmentVariableBuilder.DisplayName");
    }

    /**
     * Key {@code JiraEnvironmentVariableBuilder.DisplayName}: {@code Jira:
     * Add related environment variables to build}.
     * 
     * @return
     *     {@code Jira: Add related environment variables to build}
     */
    public static Localizable _JiraEnvironmentVariableBuilder_DisplayName() {
        return new Localizable(holder, "JiraEnvironmentVariableBuilder.DisplayName");
    }

    /**
     * Key {@code JiraCreateIssueNotifier.DisplayName}: {@code Jira: Create
     * issue}.
     * 
     * @return
     *     {@code Jira: Create issue}
     */
    public static String JiraCreateIssueNotifier_DisplayName() {
        return holder.format("JiraCreateIssueNotifier.DisplayName");
    }

    /**
     * Key {@code JiraCreateIssueNotifier.DisplayName}: {@code Jira: Create
     * issue}.
     * 
     * @return
     *     {@code Jira: Create issue}
     */
    public static Localizable _JiraCreateIssueNotifier_DisplayName() {
        return new Localizable(holder, "JiraCreateIssueNotifier.DisplayName");
    }

    /**
     * Key {@code IssueSelector.JqlIssueSelector.DisplayName}: {@code JQL
     * selector}.
     * 
     * @return
     *     {@code JQL selector}
     */
    public static String IssueSelector_JqlIssueSelector_DisplayName() {
        return holder.format("IssueSelector.JqlIssueSelector.DisplayName");
    }

    /**
     * Key {@code IssueSelector.JqlIssueSelector.DisplayName}: {@code JQL
     * selector}.
     * 
     * @return
     *     {@code JQL selector}
     */
    public static Localizable _IssueSelector_JqlIssueSelector_DisplayName() {
        return new Localizable(holder, "IssueSelector.JqlIssueSelector.DisplayName");
    }

    /**
     * Key {@code ErrorCommentingIssues}: {@code [Jira] Could not comment on
     * some issues: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Could not comment on some issues: {0}}
     */
    public static String ErrorCommentingIssues(Object arg0) {
        return holder.format("ErrorCommentingIssues", arg0);
    }

    /**
     * Key {@code ErrorCommentingIssues}: {@code [Jira] Could not comment on
     * some issues: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Could not comment on some issues: {0}}
     */
    public static Localizable _ErrorCommentingIssues(Object arg0) {
        return new Localizable(holder, "ErrorCommentingIssues", arg0);
    }

    /**
     * Key {@code NoJiraSite}: {@code [Jira] No Jira site is configured for
     * this project. This must be a project configuration error}.
     * 
     * @return
     *     {@code [Jira] No Jira site is configured for this project. This must
     *     be a project configuration error}
     */
    public static String NoJiraSite() {
        return holder.format("NoJiraSite");
    }

    /**
     * Key {@code NoJiraSite}: {@code [Jira] No Jira site is configured for
     * this project. This must be a project configuration error}.
     * 
     * @return
     *     {@code [Jira] No Jira site is configured for this project. This must
     *     be a project configuration error}
     */
    public static Localizable _NoJiraSite() {
        return new Localizable(holder, "NoJiraSite");
    }

    /**
     * Key {@code JiraEnvironmentVariableBuilder.Updating}: {@code [Jira]
     * Setting {0} to {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Setting {0} to {1}.}
     */
    public static String JiraEnvironmentVariableBuilder_Updating(Object arg0, Object arg1) {
        return holder.format("JiraEnvironmentVariableBuilder.Updating", arg0, arg1);
    }

    /**
     * Key {@code JiraEnvironmentVariableBuilder.Updating}: {@code [Jira]
     * Setting {0} to {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Setting {0} to {1}.}
     */
    public static Localizable _JiraEnvironmentVariableBuilder_Updating(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraEnvironmentVariableBuilder.Updating", arg0, arg1);
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.UnknownWorkflowAction}: {@code
     * [Jira] Unable to update issue {0}: invalid workflow action "{1}".
     * Perhaps the Jenkins user does not have permission to perform the
     * action on the Jira issue?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Unable to update issue {0}: invalid workflow action
     *     "{1}". Perhaps the Jenkins user does not have permission to perform
     *     the action on the Jira issue?}
     */
    public static String JiraIssueUpdateBuilder_UnknownWorkflowAction(Object arg0, Object arg1) {
        return holder.format("JiraIssueUpdateBuilder.UnknownWorkflowAction", arg0, arg1);
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.UnknownWorkflowAction}: {@code
     * [Jira] Unable to update issue {0}: invalid workflow action "{1}".
     * Perhaps the Jenkins user does not have permission to perform the
     * action on the Jira issue?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Unable to update issue {0}: invalid workflow action
     *     "{1}". Perhaps the Jenkins user does not have permission to perform
     *     the action on the Jira issue?}
     */
    public static Localizable _JiraIssueUpdateBuilder_UnknownWorkflowAction(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraIssueUpdateBuilder.UnknownWorkflowAction", arg0, arg1);
    }

    /**
     * Key {@code JiraSite.timeoutMinimunValue}: {@code Connection timeout
     * must be at least {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection timeout must be at least {0}}
     */
    public static String JiraSite_timeoutMinimunValue(Object arg0) {
        return holder.format("JiraSite.timeoutMinimunValue", arg0);
    }

    /**
     * Key {@code JiraSite.timeoutMinimunValue}: {@code Connection timeout
     * must be at least {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection timeout must be at least {0}}
     */
    public static Localizable _JiraSite_timeoutMinimunValue(Object arg0) {
        return new Localizable(holder, "JiraSite.timeoutMinimunValue", arg0);
    }

    /**
     * Key {@code JiraSite.threadExecutorMinimunSize}: {@code Thread Executor
     * Size must be at least {0} (higher values are recommended)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Thread Executor Size must be at least {0} (higher values are
     *     recommended)}
     */
    public static String JiraSite_threadExecutorMinimunSize(Object arg0) {
        return holder.format("JiraSite.threadExecutorMinimunSize", arg0);
    }

    /**
     * Key {@code JiraSite.threadExecutorMinimunSize}: {@code Thread Executor
     * Size must be at least {0} (higher values are recommended)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Thread Executor Size must be at least {0} (higher values are
     *     recommended)}
     */
    public static Localizable _JiraSite_threadExecutorMinimunSize(Object arg0) {
        return new Localizable(holder, "JiraSite.threadExecutorMinimunSize", arg0);
    }

    /**
     * Key {@code JiraBuildAction.DisplayName}: {@code Jira issues}.
     * 
     * @return
     *     {@code Jira issues}
     */
    public static String JiraBuildAction_DisplayName() {
        return holder.format("JiraBuildAction.DisplayName");
    }

    /**
     * Key {@code JiraBuildAction.DisplayName}: {@code Jira issues}.
     * 
     * @return
     *     {@code Jira issues}
     */
    public static Localizable _JiraBuildAction_DisplayName() {
        return new Localizable(holder, "JiraBuildAction.DisplayName");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.UpdatingWithAction}: {@code [Jira]
     * Updating issues using workflow action {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Updating issues using workflow action {0}.}
     */
    public static String JiraIssueUpdateBuilder_UpdatingWithAction(Object arg0) {
        return holder.format("JiraIssueUpdateBuilder.UpdatingWithAction", arg0);
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.UpdatingWithAction}: {@code [Jira]
     * Updating issues using workflow action {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Updating issues using workflow action {0}.}
     */
    public static Localizable _JiraIssueUpdateBuilder_UpdatingWithAction(Object arg0) {
        return new Localizable(holder, "JiraIssueUpdateBuilder.UpdatingWithAction", arg0);
    }

    /**
     * Key {@code JiraProjectProperty.NoWsdlAvailable}: {@code This looks
     * like a Jira instance but no WSDL is available. Perhaps SOAP support is
     * not enabled yet?}.
     * 
     * @return
     *     {@code This looks like a Jira instance but no WSDL is available.
     *     Perhaps SOAP support is not enabled yet?}
     */
    public static String JiraProjectProperty_NoWsdlAvailable() {
        return holder.format("JiraProjectProperty.NoWsdlAvailable");
    }

    /**
     * Key {@code JiraProjectProperty.NoWsdlAvailable}: {@code This looks
     * like a Jira instance but no WSDL is available. Perhaps SOAP support is
     * not enabled yet?}.
     * 
     * @return
     *     {@code This looks like a Jira instance but no WSDL is available.
     *     Perhaps SOAP support is not enabled yet?}
     */
    public static Localizable _JiraProjectProperty_NoWsdlAvailable() {
        return new Localizable(holder, "JiraProjectProperty.NoWsdlAvailable");
    }

    /**
     * Key {@code NoRemoteAccess}: {@code [Jira] The system configuration
     * does not allow remote Jira access}.
     * 
     * @return
     *     {@code [Jira] The system configuration does not allow remote Jira
     *     access}
     */
    public static String NoRemoteAccess() {
        return holder.format("NoRemoteAccess");
    }

    /**
     * Key {@code NoRemoteAccess}: {@code [Jira] The system configuration
     * does not allow remote Jira access}.
     * 
     * @return
     *     {@code [Jira] The system configuration does not allow remote Jira
     *     access}
     */
    public static Localizable _NoRemoteAccess() {
        return new Localizable(holder, "NoRemoteAccess");
    }

    /**
     * Key {@code IssueSelectorStep.Descriptor.DisplayName}: {@code Jira:
     * Issue selector}.
     * 
     * @return
     *     {@code Jira: Issue selector}
     */
    public static String IssueSelectorStep_Descriptor_DisplayName() {
        return holder.format("IssueSelectorStep.Descriptor.DisplayName");
    }

    /**
     * Key {@code IssueSelectorStep.Descriptor.DisplayName}: {@code Jira:
     * Issue selector}.
     * 
     * @return
     *     {@code Jira: Issue selector}
     */
    public static Localizable _IssueSelectorStep_Descriptor_DisplayName() {
        return new Localizable(holder, "IssueSelectorStep.Descriptor.DisplayName");
    }

    /**
     * Key {@code JiraProjectProperty.NotAJiraUrl}: {@code This is a valid
     * URL but it doesn''t look like Jira}.
     * 
     * @return
     *     {@code This is a valid URL but it doesn''t look like Jira}
     */
    public static String JiraProjectProperty_NotAJiraUrl() {
        return holder.format("JiraProjectProperty.NotAJiraUrl");
    }

    /**
     * Key {@code JiraProjectProperty.NotAJiraUrl}: {@code This is a valid
     * URL but it doesn''t look like Jira}.
     * 
     * @return
     *     {@code This is a valid URL but it doesn''t look like Jira}
     */
    public static Localizable _JiraProjectProperty_NotAJiraUrl() {
        return new Localizable(holder, "JiraProjectProperty.NotAJiraUrl");
    }

    /**
     * Key {@code JiraVersionCreator.VersionExists}: {@code [Jira] A version
     * with name {0} already exists in project {1}, so nothing to do.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] A version with name {0} already exists in project {1},
     *     so nothing to do.}
     */
    public static String JiraVersionCreator_VersionExists(Object arg0, Object arg1) {
        return holder.format("JiraVersionCreator.VersionExists", arg0, arg1);
    }

    /**
     * Key {@code JiraVersionCreator.VersionExists}: {@code [Jira] A version
     * with name {0} already exists in project {1}, so nothing to do.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] A version with name {0} already exists in project {1},
     *     so nothing to do.}
     */
    public static Localizable _JiraVersionCreator_VersionExists(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraVersionCreator.VersionExists", arg0, arg1);
    }

    /**
     * Key {@code FailedToConnect}: {@code [Jira] Failed to connect to Jira}.
     * 
     * @return
     *     {@code [Jira] Failed to connect to Jira}
     */
    public static String FailedToConnect() {
        return holder.format("FailedToConnect");
    }

    /**
     * Key {@code FailedToConnect}: {@code [Jira] Failed to connect to Jira}.
     * 
     * @return
     *     {@code [Jira] Failed to connect to Jira}
     */
    public static Localizable _FailedToConnect() {
        return new Localizable(holder, "FailedToConnect");
    }

    /**
     * Key {@code JiraVersionCreator.CreatingVersion}: {@code [Jira] Creating
     * version {0} in project {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Creating version {0} in project {1}.}
     */
    public static String JiraVersionCreator_CreatingVersion(Object arg0, Object arg1) {
        return holder.format("JiraVersionCreator.CreatingVersion", arg0, arg1);
    }

    /**
     * Key {@code JiraVersionCreator.CreatingVersion}: {@code [Jira] Creating
     * version {0} in project {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Creating version {0} in project {1}.}
     */
    public static Localizable _JiraVersionCreator_CreatingVersion(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraVersionCreator.CreatingVersion", arg0, arg1);
    }

    /**
     * Key {@code P4JobIssueSelector.DisplayName}: {@code Perforce Software
     * (P4) job selector}.
     * 
     * @return
     *     {@code Perforce Software (P4) job selector}
     */
    public static String P4JobIssueSelector_DisplayName() {
        return holder.format("P4JobIssueSelector.DisplayName");
    }

    /**
     * Key {@code P4JobIssueSelector.DisplayName}: {@code Perforce Software
     * (P4) job selector}.
     * 
     * @return
     *     {@code Perforce Software (P4) job selector}
     */
    public static Localizable _P4JobIssueSelector_DisplayName() {
        return new Localizable(holder, "P4JobIssueSelector.DisplayName");
    }

    /**
     * Key {@code JiraProjectProperty.JiraUrlMandatory}: {@code Jira URL is a
     * mandatory field}.
     * 
     * @return
     *     {@code Jira URL is a mandatory field}
     */
    public static String JiraProjectProperty_JiraUrlMandatory() {
        return holder.format("JiraProjectProperty.JiraUrlMandatory");
    }

    /**
     * Key {@code JiraProjectProperty.JiraUrlMandatory}: {@code Jira URL is a
     * mandatory field}.
     * 
     * @return
     *     {@code Jira URL is a mandatory field}
     */
    public static Localizable _JiraProjectProperty_JiraUrlMandatory() {
        return new Localizable(holder, "JiraProjectProperty.JiraUrlMandatory");
    }

    /**
     * Key {@code JiraEnvironmentVariableBuilder.NoJiraSite}: {@code [Jira]
     * No Jira site is configured for this project. This must be a project
     * configuration error}.
     * 
     * @return
     *     {@code [Jira] No Jira site is configured for this project. This must
     *     be a project configuration error}
     */
    public static String JiraEnvironmentVariableBuilder_NoJiraSite() {
        return holder.format("JiraEnvironmentVariableBuilder.NoJiraSite");
    }

    /**
     * Key {@code JiraEnvironmentVariableBuilder.NoJiraSite}: {@code [Jira]
     * No Jira site is configured for this project. This must be a project
     * configuration error}.
     * 
     * @return
     *     {@code [Jira] No Jira site is configured for this project. This must
     *     be a project configuration error}
     */
    public static Localizable _JiraEnvironmentVariableBuilder_NoJiraSite() {
        return new Localizable(holder, "JiraEnvironmentVariableBuilder.NoJiraSite");
    }

    /**
     * Key {@code UpdatingIssue}: {@code [Jira] Updating issue {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Updating issue {0}}
     */
    public static String UpdatingIssue(Object arg0) {
        return holder.format("UpdatingIssue", arg0);
    }

    /**
     * Key {@code UpdatingIssue}: {@code [Jira] Updating issue {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Updating issue {0}}
     */
    public static Localizable _UpdatingIssue(Object arg0) {
        return new Localizable(holder, "UpdatingIssue", arg0);
    }

    /**
     * Key {@code VersionReleaser.MarkingReleased}: {@code [Jira] Marking
     * version {0} in project {1} as released.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Marking version {0} in project {1} as released.}
     */
    public static String VersionReleaser_MarkingReleased(Object arg0, Object arg1) {
        return holder.format("VersionReleaser.MarkingReleased", arg0, arg1);
    }

    /**
     * Key {@code VersionReleaser.MarkingReleased}: {@code [Jira] Marking
     * version {0} in project {1} as released.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Marking version {0} in project {1} as released.}
     */
    public static Localizable _VersionReleaser_MarkingReleased(Object arg0, Object arg1) {
        return new Localizable(holder, "VersionReleaser.MarkingReleased", arg0, arg1);
    }

    /**
     * Key {@code JiraFolderProperty.DisplayName}: {@code Associated Jira}.
     * 
     * @return
     *     {@code Associated Jira}
     */
    public static String JiraFolderProperty_DisplayName() {
        return holder.format("JiraFolderProperty.DisplayName");
    }

    /**
     * Key {@code JiraFolderProperty.DisplayName}: {@code Associated Jira}.
     * 
     * @return
     *     {@code Associated Jira}
     */
    public static Localizable _JiraFolderProperty_DisplayName() {
        return new Localizable(holder, "JiraFolderProperty.DisplayName");
    }

    /**
     * Key {@code VersionReleaser.AlreadyReleased}: {@code [Jira] The version
     * {0} is already released in project {1}, so nothing to do.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] The version {0} is already released in project {1}, so
     *     nothing to do.}
     */
    public static String VersionReleaser_AlreadyReleased(Object arg0, Object arg1) {
        return holder.format("VersionReleaser.AlreadyReleased", arg0, arg1);
    }

    /**
     * Key {@code VersionReleaser.AlreadyReleased}: {@code [Jira] The version
     * {0} is already released in project {1}, so nothing to do.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] The version {0} is already released in project {1}, so
     *     nothing to do.}
     */
    public static Localizable _VersionReleaser_AlreadyReleased(Object arg0, Object arg1) {
        return new Localizable(holder, "VersionReleaser.AlreadyReleased", arg0, arg1);
    }

    /**
     * Key {@code JiraIssueFieldUpdater.DisplayName}: {@code Jira: Issue
     * custom field updater}.
     * 
     * @return
     *     {@code Jira: Issue custom field updater}
     */
    public static String JiraIssueFieldUpdater_DisplayName() {
        return holder.format("JiraIssueFieldUpdater.DisplayName");
    }

    /**
     * Key {@code JiraIssueFieldUpdater.DisplayName}: {@code Jira: Issue
     * custom field updater}.
     * 
     * @return
     *     {@code Jira: Issue custom field updater}
     */
    public static Localizable _JiraIssueFieldUpdater_DisplayName() {
        return new Localizable(holder, "JiraIssueFieldUpdater.DisplayName");
    }

    /**
     * Key {@code IssueSelector.ExplicitIssueSelector.DisplayName}: {@code
     * Explicit selector}.
     * 
     * @return
     *     {@code Explicit selector}
     */
    public static String IssueSelector_ExplicitIssueSelector_DisplayName() {
        return holder.format("IssueSelector.ExplicitIssueSelector.DisplayName");
    }

    /**
     * Key {@code IssueSelector.ExplicitIssueSelector.DisplayName}: {@code
     * Explicit selector}.
     * 
     * @return
     *     {@code Explicit selector}
     */
    public static Localizable _IssueSelector_ExplicitIssueSelector_DisplayName() {
        return new Localizable(holder, "IssueSelector.ExplicitIssueSelector.DisplayName");
    }

    /**
     * Key {@code DefaultIssueSelector.DisplayName}: {@code Default
     * selector}.
     * 
     * @return
     *     {@code Default selector}
     */
    public static String DefaultIssueSelector_DisplayName() {
        return holder.format("DefaultIssueSelector.DisplayName");
    }

    /**
     * Key {@code DefaultIssueSelector.DisplayName}: {@code Default
     * selector}.
     * 
     * @return
     *     {@code Default selector}
     */
    public static Localizable _DefaultIssueSelector_DisplayName() {
        return new Localizable(holder, "DefaultIssueSelector.DisplayName");
    }

    /**
     * Key {@code IssueFieldUpdaterStep.UpdatingIssue}: {@code
     * [Jira][IssueFieldUpdaterStep] Updating issue {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira][IssueFieldUpdaterStep] Updating issue {0}}
     */
    public static String IssueFieldUpdaterStep_UpdatingIssue(Object arg0) {
        return holder.format("IssueFieldUpdaterStep.UpdatingIssue", arg0);
    }

    /**
     * Key {@code IssueFieldUpdaterStep.UpdatingIssue}: {@code
     * [Jira][IssueFieldUpdaterStep] Updating issue {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira][IssueFieldUpdaterStep] Updating issue {0}}
     */
    public static Localizable _IssueFieldUpdaterStep_UpdatingIssue(Object arg0) {
        return new Localizable(holder, "IssueFieldUpdaterStep.UpdatingIssue", arg0);
    }

    /**
     * Key {@code JiraVersionCreatorBuilder.DisplayName}: {@code Jira: Create
     * new version}.
     * 
     * @return
     *     {@code Jira: Create new version}
     */
    public static String JiraVersionCreatorBuilder_DisplayName() {
        return holder.format("JiraVersionCreatorBuilder.DisplayName");
    }

    /**
     * Key {@code JiraVersionCreatorBuilder.DisplayName}: {@code Jira: Create
     * new version}.
     * 
     * @return
     *     {@code Jira: Create new version}
     */
    public static Localizable _JiraVersionCreatorBuilder_DisplayName() {
        return new Localizable(holder, "JiraVersionCreatorBuilder.DisplayName");
    }

    /**
     * Key {@code JiraProjectProperty.DisplayName}: {@code Associated Jira}.
     * 
     * @return
     *     {@code Associated Jira}
     */
    public static String JiraProjectProperty_DisplayName() {
        return holder.format("JiraProjectProperty.DisplayName");
    }

    /**
     * Key {@code JiraProjectProperty.DisplayName}: {@code Associated Jira}.
     * 
     * @return
     *     {@code Associated Jira}
     */
    public static Localizable _JiraProjectProperty_DisplayName() {
        return new Localizable(holder, "JiraProjectProperty.DisplayName");
    }

    /**
     * Key {@code CommentStep.Descriptor.DisplayName}: {@code Jira: Add a
     * comment to issue(s)}.
     * 
     * @return
     *     {@code Jira: Add a comment to issue(s)}
     */
    public static String CommentStep_Descriptor_DisplayName() {
        return holder.format("CommentStep.Descriptor.DisplayName");
    }

    /**
     * Key {@code CommentStep.Descriptor.DisplayName}: {@code Jira: Add a
     * comment to issue(s)}.
     * 
     * @return
     *     {@code Jira: Add a comment to issue(s)}
     */
    public static Localizable _CommentStep_Descriptor_DisplayName() {
        return new Localizable(holder, "CommentStep.Descriptor.DisplayName");
    }

    /**
     * Key {@code FailedToUpdateIssueWithCarryOver}: {@code [Jira] Failed to
     * update issue {0}. Carrying over to next build.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Failed to update issue {0}. Carrying over to next
     *     build.}
     */
    public static String FailedToUpdateIssueWithCarryOver(Object arg0) {
        return holder.format("FailedToUpdateIssueWithCarryOver", arg0);
    }

    /**
     * Key {@code FailedToUpdateIssueWithCarryOver}: {@code [Jira] Failed to
     * update issue {0}. Carrying over to next build.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Failed to update issue {0}. Carrying over to next
     *     build.}
     */
    public static Localizable _FailedToUpdateIssueWithCarryOver(Object arg0) {
        return new Localizable(holder, "FailedToUpdateIssueWithCarryOver", arg0);
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.NoWorkflowAction}: {@code A workflow
     * action is required.}.
     * 
     * @return
     *     {@code A workflow action is required.}
     */
    public static String JiraIssueUpdateBuilder_NoWorkflowAction() {
        return holder.format("JiraIssueUpdateBuilder.NoWorkflowAction");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.NoWorkflowAction}: {@code A workflow
     * action is required.}.
     * 
     * @return
     *     {@code A workflow action is required.}
     */
    public static Localizable _JiraIssueUpdateBuilder_NoWorkflowAction() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.NoWorkflowAction");
    }

    /**
     * Key {@code JiraIssueFieldUpdater.NotAtIssueFieldID}: {@code Not an
     * issue field ID}.
     * 
     * @return
     *     {@code Not an issue field ID}
     */
    public static String JiraIssueFieldUpdater_NotAtIssueFieldID() {
        return holder.format("JiraIssueFieldUpdater.NotAtIssueFieldID");
    }

    /**
     * Key {@code JiraIssueFieldUpdater.NotAtIssueFieldID}: {@code Not an
     * issue field ID}.
     * 
     * @return
     *     {@code Not an issue field ID}
     */
    public static Localizable _JiraIssueFieldUpdater_NotAtIssueFieldID() {
        return new Localizable(holder, "JiraIssueFieldUpdater.NotAtIssueFieldID");
    }

    /**
     * Key {@code JiraIssueUpdater.DisplayName}: {@code Jira: Update relevant
     * issues}.
     * 
     * @return
     *     {@code Jira: Update relevant issues}
     */
    public static String JiraIssueUpdater_DisplayName() {
        return holder.format("JiraIssueUpdater.DisplayName");
    }

    /**
     * Key {@code JiraIssueUpdater.DisplayName}: {@code Jira: Update relevant
     * issues}.
     * 
     * @return
     *     {@code Jira: Update relevant issues}
     */
    public static Localizable _JiraIssueUpdater_DisplayName() {
        return new Localizable(holder, "JiraIssueUpdater.DisplayName");
    }

    /**
     * Key {@code FailedToUpdateIssue}: {@code [Jira] Failed to update issue
     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Failed to update issue {0}.}
     */
    public static String FailedToUpdateIssue(Object arg0) {
        return holder.format("FailedToUpdateIssue", arg0);
    }

    /**
     * Key {@code FailedToUpdateIssue}: {@code [Jira] Failed to update issue
     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Jira] Failed to update issue {0}.}
     */
    public static Localizable _FailedToUpdateIssue(Object arg0) {
        return new Localizable(holder, "FailedToUpdateIssue", arg0);
    }

    /**
     * Key {@code NoJenkinsUrl}: {@code [Jira] Jenkins URL is not configured
     * yet. Go to system configuration to set this value}.
     * 
     * @return
     *     {@code [Jira] Jenkins URL is not configured yet. Go to system
     *     configuration to set this value}
     */
    public static String NoJenkinsUrl() {
        return holder.format("NoJenkinsUrl");
    }

    /**
     * Key {@code NoJenkinsUrl}: {@code [Jira] Jenkins URL is not configured
     * yet. Go to system configuration to set this value}.
     * 
     * @return
     *     {@code [Jira] Jenkins URL is not configured yet. Go to system
     *     configuration to set this value}
     */
    public static Localizable _NoJenkinsUrl() {
        return new Localizable(holder, "NoJenkinsUrl");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.NoJqlSearch}: {@code Please set the
     * JQL used to select the issues to update.}.
     * 
     * @return
     *     {@code Please set the JQL used to select the issues to update.}
     */
    public static String JiraIssueUpdateBuilder_NoJqlSearch() {
        return holder.format("JiraIssueUpdateBuilder.NoJqlSearch");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.NoJqlSearch}: {@code Please set the
     * JQL used to select the issues to update.}.
     * 
     * @return
     *     {@code Please set the JQL used to select the issues to update.}
     */
    public static Localizable _JiraIssueUpdateBuilder_NoJqlSearch() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.NoJqlSearch");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.SomeIssuesFailed}: {@code [Jira] At
     * least one issue failed to update.  See log above for more details.}.
     * 
     * @return
     *     {@code [Jira] At least one issue failed to update.  See log above for
     *     more details.}
     */
    public static String JiraIssueUpdateBuilder_SomeIssuesFailed() {
        return holder.format("JiraIssueUpdateBuilder.SomeIssuesFailed");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.SomeIssuesFailed}: {@code [Jira] At
     * least one issue failed to update.  See log above for more details.}.
     * 
     * @return
     *     {@code [Jira] At least one issue failed to update.  See log above for
     *     more details.}
     */
    public static Localizable _JiraIssueUpdateBuilder_SomeIssuesFailed() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.SomeIssuesFailed");
    }

    /**
     * Key {@code SearchIssuesStep.Descriptor.DisplayName}: {@code Jira:
     * Search issues}.
     * 
     * @return
     *     {@code Jira: Search issues}
     */
    public static String SearchIssuesStep_Descriptor_DisplayName() {
        return holder.format("SearchIssuesStep.Descriptor.DisplayName");
    }

    /**
     * Key {@code SearchIssuesStep.Descriptor.DisplayName}: {@code Jira:
     * Search issues}.
     * 
     * @return
     *     {@code Jira: Search issues}
     */
    public static Localizable _SearchIssuesStep_Descriptor_DisplayName() {
        return new Localizable(holder, "SearchIssuesStep.Descriptor.DisplayName");
    }

    /**
     * Key {@code JiraSite.readTimeoutMinimunValue}: {@code Read timeout must
     * be at least {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Read timeout must be at least {0}}
     */
    public static String JiraSite_readTimeoutMinimunValue(Object arg0) {
        return holder.format("JiraSite.readTimeoutMinimunValue", arg0);
    }

    /**
     * Key {@code JiraSite.readTimeoutMinimunValue}: {@code Read timeout must
     * be at least {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Read timeout must be at least {0}}
     */
    public static Localizable _JiraSite_readTimeoutMinimunValue(Object arg0) {
        return new Localizable(holder, "JiraSite.readTimeoutMinimunValue", arg0);
    }

    /**
     * Key {@code PerforceJobIssueSelector.DisplayName}: {@code Perforce job
     * selector}.
     * 
     * @return
     *     {@code Perforce job selector}
     */
    public static String PerforceJobIssueSelector_DisplayName() {
        return holder.format("PerforceJobIssueSelector.DisplayName");
    }

    /**
     * Key {@code PerforceJobIssueSelector.DisplayName}: {@code Perforce job
     * selector}.
     * 
     * @return
     *     {@code Perforce job selector}
     */
    public static Localizable _PerforceJobIssueSelector_DisplayName() {
        return new Localizable(holder, "PerforceJobIssueSelector.DisplayName");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.DisplayName}: {@code Jira: Progress
     * issues by workflow action}.
     * 
     * @return
     *     {@code Jira: Progress issues by workflow action}
     */
    public static String JiraIssueUpdateBuilder_DisplayName() {
        return holder.format("JiraIssueUpdateBuilder.DisplayName");
    }

    /**
     * Key {@code JiraIssueUpdateBuilder.DisplayName}: {@code Jira: Progress
     * issues by workflow action}.
     * 
     * @return
     *     {@code Jira: Progress issues by workflow action}
     */
    public static Localizable _JiraIssueUpdateBuilder_DisplayName() {
        return new Localizable(holder, "JiraIssueUpdateBuilder.DisplayName");
    }

}
