// CHECKSTYLE:OFF

package jenkins.plugins.jclouds.compute;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JClouds.NoSuchNodeExists}: {@code No such node "{0}"
     * exists.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such node "{0}" exists.}
     */
    public static String JClouds_NoSuchNodeExists(Object arg0) {
        return holder.format("JClouds.NoSuchNodeExists", arg0);
    }

    /**
     * Key {@code JClouds.NoSuchNodeExists}: {@code No such node "{0}"
     * exists.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such node "{0}" exists.}
     */
    public static Localizable _JClouds_NoSuchNodeExists(Object arg0) {
        return new Localizable(holder, "JClouds.NoSuchNodeExists", arg0);
    }

    /**
     * Key {@code JClouds.NoSuchProfileExists}: {@code No such profile "{0}"
     * exists. Did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such profile "{0}" exists. Did you mean "{1}"?}
     */
    public static String JClouds_NoSuchProfileExists(Object arg0, Object arg1) {
        return holder.format("JClouds.NoSuchProfileExists", arg0, arg1);
    }

    /**
     * Key {@code JClouds.NoSuchProfileExists}: {@code No such profile "{0}"
     * exists. Did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such profile "{0}" exists. Did you mean "{1}"?}
     */
    public static Localizable _JClouds_NoSuchProfileExists(Object arg0, Object arg1) {
        return new Localizable(holder, "JClouds.NoSuchProfileExists", arg0, arg1);
    }

    /**
     * Key {@code ProvisionCommand_shortDescription}: {@code Provision a new
     * node using a JClouds template.}.
     * 
     * @return
     *     {@code Provision a new node using a JClouds template.}
     */
    public static String ProvisionCommand_shortDescription() {
        return holder.format("ProvisionCommand_shortDescription");
    }

    /**
     * Key {@code ProvisionCommand_shortDescription}: {@code Provision a new
     * node using a JClouds template.}.
     * 
     * @return
     *     {@code Provision a new node using a JClouds template.}
     */
    public static Localizable _ProvisionCommand_shortDescription() {
        return new Localizable(holder, "ProvisionCommand_shortDescription");
    }

    /**
     * Key {@code JClouds.NotFromJClouds}: {@code Node "{0}" was not created
     * by JClouds.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Node "{0}" was not created by JClouds.}
     */
    public static String JClouds_NotFromJClouds(Object arg0) {
        return holder.format("JClouds.NotFromJClouds", arg0);
    }

    /**
     * Key {@code JClouds.NotFromJClouds}: {@code Node "{0}" was not created
     * by JClouds.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Node "{0}" was not created by JClouds.}
     */
    public static Localizable _JClouds_NotFromJClouds(Object arg0) {
        return new Localizable(holder, "JClouds.NotFromJClouds", arg0);
    }

    /**
     * Key {@code deletedCause}: {@code Agent is pending removal.}.
     * 
     * @return
     *     {@code Agent is pending removal.}
     */
    public static String deletedCause() {
        return holder.format("deletedCause");
    }

    /**
     * Key {@code deletedCause}: {@code Agent is pending removal.}.
     * 
     * @return
     *     {@code Agent is pending removal.}
     */
    public static Localizable _deletedCause() {
        return new Localizable(holder, "deletedCause");
    }

    /**
     * Key {@code ExpireCommand_shortDescription}: {@code Expires a node.}.
     * 
     * @return
     *     {@code Expires a node.}
     */
    public static String ExpireCommand_shortDescription() {
        return holder.format("ExpireCommand_shortDescription");
    }

    /**
     * Key {@code ExpireCommand_shortDescription}: {@code Expires a node.}.
     * 
     * @return
     *     {@code Expires a node.}
     */
    public static Localizable _ExpireCommand_shortDescription() {
        return new Localizable(holder, "ExpireCommand_shortDescription");
    }

    /**
     * Key {@code JClouds.NoSuchTemplateExists}: {@code No such template
     * "{0}" exists. Did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such template "{0}" exists. Did you mean "{1}"?}
     */
    public static String JClouds_NoSuchTemplateExists(Object arg0, Object arg1) {
        return holder.format("JClouds.NoSuchTemplateExists", arg0, arg1);
    }

    /**
     * Key {@code JClouds.NoSuchTemplateExists}: {@code No such template
     * "{0}" exists. Did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such template "{0}" exists. Did you mean "{1}"?}
     */
    public static Localizable _JClouds_NoSuchTemplateExists(Object arg0, Object arg1) {
        return new Localizable(holder, "JClouds.NoSuchTemplateExists", arg0, arg1);
    }

    /**
     * Key {@code oneOffCause}: {@code Single-use agent has already been used
     * and is pending removal.}.
     * 
     * @return
     *     {@code Single-use agent has already been used and is pending removal.}
     */
    public static String oneOffCause() {
        return holder.format("oneOffCause");
    }

    /**
     * Key {@code oneOffCause}: {@code Single-use agent has already been used
     * and is pending removal.}.
     * 
     * @return
     *     {@code Single-use agent has already been used and is pending removal.}
     */
    public static Localizable _oneOffCause() {
        return new Localizable(holder, "oneOffCause");
    }

    /**
     * Key {@code TemplatesCommand_shortDescription}: {@code List all JClouds
     * templates.}.
     * 
     * @return
     *     {@code List all JClouds templates.}
     */
    public static String TemplatesCommand_shortDescription() {
        return holder.format("TemplatesCommand_shortDescription");
    }

    /**
     * Key {@code TemplatesCommand_shortDescription}: {@code List all JClouds
     * templates.}.
     * 
     * @return
     *     {@code List all JClouds templates.}
     */
    public static Localizable _TemplatesCommand_shortDescription() {
        return new Localizable(holder, "TemplatesCommand_shortDescription");
    }

}
