/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ivytrigger.util;

import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Node;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ivytrigger.util.FilePathFactory;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;

public class PropertiesFileContentExtractor {
    private final FilePathFactory filePathFactory;

    public PropertiesFileContentExtractor(FilePathFactory filePathFactory) {
        this.filePathFactory = filePathFactory;
    }

    public String extractPropertiesFileContents(String propertiesFilePath, AbstractProject job, Node pollingNode, XTriggerLog log, Map<String, String> envVars) throws XTriggerException {
        log.info("Given job properties file path: " + propertiesFilePath);
        if (StringUtils.isEmpty((String)propertiesFilePath)) {
            return "";
        }
        StringBuilder fileContent = new StringBuilder();
        List<String> filePaths = this.splitFilePaths(propertiesFilePath);
        try {
            for (String path : filePaths) {
                FilePath fp = this.filePathFactory.getDescriptorFilePath(path, job, pollingNode, log, envVars);
                log.info("Resolved properties file value: " + fp.getRemote());
                fileContent.append(IOUtils.toString((InputStream)fp.read(), (Charset)StandardCharsets.ISO_8859_1));
                fileContent.append("\n");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new XTriggerException((Throwable)e);
        }
        return fileContent.toString();
    }

    public List<String> splitFilePaths(String propertiesFilePath) {
        String[] paths;
        ArrayList<String> filePathList = new ArrayList<String>();
        for (String path : paths = StringUtils.split((String)propertiesFilePath, (String)";")) {
            String trimmedPath = StringUtils.trim((String)path);
            filePathList.add(trimmedPath);
        }
        return filePathList;
    }
}

