/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ivytrigger.util;

import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Node;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;

public class FilePathFactory {
    public FilePath getDescriptorFilePath(String filePath, AbstractProject job, Node pollingNode, XTriggerLog log, Map<String, String> envVars) throws XTriggerException {
        try {
            FilePath ivyDescPath;
            if (filePath == null) {
                return null;
            }
            String resolvedFilePath = Util.replaceMacro((String)filePath, envVars);
            FilePath workspace = job.getSomeWorkspace();
            if (workspace != null && (ivyDescPath = workspace.child(resolvedFilePath)).exists()) {
                return ivyDescPath;
            }
            if (pollingNode == null) {
                File file = new File(resolvedFilePath);
                if (file.exists()) {
                    return new FilePath(file);
                }
            } else {
                FilePath filePathObject;
                FilePath path = pollingNode.getRootPath();
                if (path != null && (filePathObject = new FilePath(path, resolvedFilePath)).exists()) {
                    return filePathObject;
                }
            }
            log.error(String.format("Can't find the file '%s'.", resolvedFilePath));
            return null;
        }
        catch (IOException | InterruptedException e) {
            throw new XTriggerException((Throwable)e);
        }
    }
}

