/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.renderer;

import hudson.model.Run;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkinsci.plugins.influxdb.renderer.MeasurementRenderer;
import org.apache.commons.lang3.StringUtils;

public class ProjectNameRenderer
implements MeasurementRenderer<Run<?, ?>> {
    private final String customPrefix;
    private final String customProjectName;

    public ProjectNameRenderer(String customPrefix, String customProjectName) {
        this.customPrefix = StringUtils.trimToNull((String)customPrefix);
        this.customProjectName = StringUtils.trimToNull((String)customProjectName);
    }

    @Override
    public String render(Run<?, ?> input) {
        return this.projectName(this.customPrefix, this.customProjectName, input);
    }

    private String projectName(String prefix, String projectName, Run<?, ?> build) {
        if (projectName == null) {
            projectName = StringUtils.trimToNull((String)build.getParent().getName());
        }
        return Stream.of(prefix, projectName).filter(Objects::nonNull).collect(Collectors.joining("_"));
    }
}

