/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.SecretBytes;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.Strings;
import com.google.jenkins.plugins.credentials.oauth.JsonKey;
import com.google.jenkins.plugins.credentials.oauth.Messages;
import com.google.jenkins.plugins.credentials.oauth.ServiceAccountConfig;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JsonServiceAccountConfig
extends ServiceAccountConfig {
    private static final long serialVersionUID = 6818111194672325387L;
    private static final Logger LOGGER = Logger.getLogger(JsonServiceAccountConfig.class.getSimpleName());
    @CheckForNull
    private String filename;
    @CheckForNull
    private SecretBytes secretJsonKey;
    @Deprecated
    @CheckForNull
    private transient String jsonKeyFile;
    private transient JsonKey jsonKey;

    @DataBoundConstructor
    public JsonServiceAccountConfig() {
    }

    @Deprecated
    public JsonServiceAccountConfig(FileItem jsonKeyFile, String prevJsonKeyFile) {
        this.setJsonKeyFileUpload(jsonKeyFile);
        if (this.filename == null && prevJsonKeyFile != null) {
            this.filename = JsonServiceAccountConfig.extractFilename(prevJsonKeyFile);
            this.secretJsonKey = this.getSecretBytesFromFile(prevJsonKeyFile);
        }
    }

    @DataBoundSetter
    public void setJsonKeyFileUpload(FileItem jsonKeyFileUpload) {
        if (jsonKeyFileUpload != null && jsonKeyFileUpload.getSize() > 0L) {
            try {
                JsonKey jsonKey = JsonKey.load((JsonFactory)new JacksonFactory(), jsonKeyFileUpload.getInputStream());
                if (jsonKey.getClientEmail() != null && jsonKey.getPrivateKey() != null) {
                    this.filename = JsonServiceAccountConfig.extractFilename(jsonKeyFileUpload.getName());
                    this.secretJsonKey = SecretBytes.fromBytes((byte[])jsonKeyFileUpload.get());
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to read JSON key from file", e);
            }
        }
    }

    @DataBoundSetter
    public void setFilename(String filename) {
        String newFilename = JsonServiceAccountConfig.extractFilename(filename);
        if (!Strings.isNullOrEmpty((String)newFilename)) {
            this.filename = newFilename;
        }
    }

    @DataBoundSetter
    public void setSecretJsonKey(SecretBytes secretJsonKey) {
        if (secretJsonKey != null && secretJsonKey.getPlainData().length > 0) {
            this.secretJsonKey = secretJsonKey;
        }
    }

    @CheckForNull
    private static String extractFilename(@CheckForNull String path) {
        if (path == null) {
            return null;
        }
        return path.replaceFirst("^.+[/\\\\]", "");
    }

    private Object readResolve() {
        if (this.secretJsonKey == null) {
            return new JsonServiceAccountConfig(null, this.getJsonKeyFile());
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(JsonServiceAccountConfig.class);
    }

    @CheckForNull
    public String getFilename() {
        return this.filename;
    }

    @Restricted(value={DoNotUse.class})
    @CheckForNull
    public SecretBytes getSecretJsonKey() {
        return this.secretJsonKey;
    }

    @Deprecated
    public String getJsonKeyFile() {
        return this.jsonKeyFile;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public FileItem getJsonKeyFileUpload() {
        return null;
    }

    @Override
    public String getAccountId() {
        JsonKey jsonKey = this.getJsonKey();
        if (jsonKey != null) {
            return jsonKey.getClientEmail();
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey() {
        String privateKey;
        JsonKey jsonKey = this.getJsonKey();
        if (jsonKey != null && (privateKey = jsonKey.getPrivateKey()) != null && !privateKey.isEmpty()) {
            PemReader pemReader = new PemReader((Reader)new StringReader(privateKey));
            try {
                PemReader.Section section = pemReader.readNextSection();
                if (section != null) {
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(section.getBase64DecodedBytes());
                    return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
                }
                LOGGER.severe("The provided private key is malformed.");
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                LOGGER.log(Level.SEVERE, "Failed to read private key", e);
            }
        }
        return null;
    }

    private JsonKey getJsonKey() {
        if (this.jsonKey == null && this.secretJsonKey != null && this.secretJsonKey.getPlainData().length > 0) {
            try {
                this.jsonKey = JsonKey.load((JsonFactory)new JacksonFactory(), new ByteArrayInputStream(this.secretJsonKey.getPlainData()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.jsonKey;
    }

    @Extension
    public static final class DescriptorImpl
    extends ServiceAccountConfig.Descriptor {
        public String getDisplayName() {
            return Messages.JsonServiceAccountConfig_DisplayName();
        }
    }
}

