/*
 * The MIT License
 *
 * Copyright (c) 2011, Frederic Gurr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package jenkins.plugins.extracolumns;

import org.kohsuke.stapler.DataBoundConstructor;

import hudson.Extension;
import hudson.model.Items;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;

public class DisableProjectColumn extends ListViewColumn {

    private boolean useIcon;

    @DataBoundConstructor
    public DisableProjectColumn(boolean useIcon) {
        super();
        this.useIcon = useIcon;
    }

    public DisableProjectColumn() {
        this(false);
    }

    public boolean useIcon(){
        return useIcon;
    }

    @Extension
    public static class DescriptorImpl extends ListViewColumnDescriptor {
        
        public DescriptorImpl() {
            Items.XSTREAM2.addCompatibilityAlias("hudson.views.DisableJobColumn", jenkins.plugins.extracolumns.DisableProjectColumn.class);
        }
        
        @Override
        public String getDisplayName() {
            return Messages.DisableProjectColumn_DisplayName();
        }
        
        public boolean shownByDefault() {
            return false;
        }
    }

}
