/*
 * This file is part of Dependency-Check Jenkins plugin.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenkinsci.plugins.DependencyCheck.model;

import org.apache.commons.digester3.AbstractObjectCreationFactory;
import org.xml.sax.Attributes;

/**
 * Creates a Vulnerability object.
 *
 * @author Steve Springett (steve.springett@owasp.org)
 * @since 5.0.0
 */
public class VulnerabilityCreationFactory extends AbstractObjectCreationFactory<Vulnerability> {

    @Override
    public Vulnerability createObject(Attributes attributes) {
        final Vulnerability vulnerability = new Vulnerability();
        switch (attributes.getValue("source")) {
        case "NPM":
        case "NSP":
            vulnerability.setSource(Vulnerability.Source.NPM);
            break;
        case "RETIREJS":
            vulnerability.setSource(Vulnerability.Source.RETIREJS);
            break;
        case "OSSINDEX":
            vulnerability.setSource(Vulnerability.Source.OSSINDEX);
            break;
        case "BUNDLEAUDIT":
            vulnerability.setSource(Vulnerability.Source.BUNDLEAUDIT);
            break;
        case "NVD":
        default:
            vulnerability.setSource(Vulnerability.Source.NVD);
            break;
        }
        return vulnerability;
    }
}