/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.sqlite;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.TopLevelItem;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.database.BasicDataSource2;
import org.jenkinsci.plugins.database.PerItemDatabase;
import org.jenkinsci.plugins.database.PerItemDatabaseConfiguration;
import org.jenkinsci.plugins.database.PerItemDatabaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.sqlite.JDBC;

public class PerItemSQLiteDatabase
extends PerItemDatabase {
    private transient Map<TopLevelItem, DataSource> sources;
    private static final String DB_FILENAME = "db.db";

    @DataBoundConstructor
    public PerItemSQLiteDatabase() {
    }

    public DataSource getDataSource(TopLevelItem item) throws SQLException {
        DataSource source;
        if (this.sources == null) {
            this.sources = new WeakHashMap<TopLevelItem, DataSource>();
        }
        if ((source = this.sources.get(item)) == null) {
            BasicDataSource2 fac = new BasicDataSource2();
            fac.setDriverClass(JDBC.class);
            fac.setUrl("jdbc:sqlite:" + String.valueOf(item.getRootDir().toURI()) + DB_FILENAME);
            source = fac.createDataSource();
            this.sources.put(item, source);
        }
        return source;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void setDefaultPerItemDatabase() {
        Jenkins j = Jenkins.get();
        PerItemDatabaseConfiguration pidbc = (PerItemDatabaseConfiguration)j.getExtensionList(GlobalConfiguration.class).get(PerItemDatabaseConfiguration.class);
        if (pidbc != null && pidbc.getDatabase() == null) {
            pidbc.setDatabase((PerItemDatabase)new PerItemSQLiteDatabase());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerItemDatabaseDescriptor {
        @NonNull
        public String getDisplayName() {
            return "SQLite per-item database";
        }
    }
}

