/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import com.robestone.hudson.compactcolumns.AbstractStatusesColumn;
import com.robestone.hudson.compactcolumns.Messages;
import hudson.model.Run;
import java.util.Locale;
import java.util.Objects;

public class BuildInfo
implements Comparable<BuildInfo> {
    private static final String STABLE_COLOR = "var(--success-color, green) !important";
    private static final String UNSTABLE_COLOR = "var(--warning-color, orange) !important";
    private static final String FAILED_COLOR = "var(--error-color, red) !important";
    private static final String OTHER_COLOR = "var(--text-color-secondary, grey) !important";
    private final Run<?, ?> run;
    private String color;
    private String underlineStyle;
    private String timeAgoString;
    private long buildTime;
    private String status;
    private String urlPart;
    private boolean isFirst;
    private boolean isLatestBuild;
    private boolean multipleBuilds;

    public BuildInfo(Run<?, ?> run, String color, String underlineStyle, long buildTime, String status, String urlPart, boolean isLatestBuild) {
        this.run = Objects.requireNonNull(run, "BuildInfo needs a run");
        this.color = color;
        this.underlineStyle = underlineStyle;
        this.buildTime = buildTime;
        this.status = status;
        this.urlPart = urlPart;
        this.isLatestBuild = isLatestBuild;
    }

    public static String getStableColor() {
        return STABLE_COLOR;
    }

    public static String getUnstableColor() {
        return UNSTABLE_COLOR;
    }

    public static String getFailedColor() {
        return FAILED_COLOR;
    }

    public static String getOtherColor() {
        return OTHER_COLOR;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getColor() {
        return this.color;
    }

    public String getTimeAgoString() {
        return this.timeAgoString;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isLatestBuild() {
        return this.isLatestBuild;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public boolean isMultipleBuilds() {
        return this.multipleBuilds;
    }

    public String getLatestBuildString(Locale locale) {
        if (this.isLatestBuild) {
            return " (" + Messages.latestBuild() + ")";
        }
        return "";
    }

    public String getStartedAgo(Locale locale) {
        return Messages._startedAgo(this.timeAgoString).toString(locale);
    }

    public String getBuiltAt(Locale locale) {
        String time = AbstractStatusesColumn.getBuildTimeString(this.buildTime, locale);
        return Messages._builtAt(time).toString(locale);
    }

    public String getLastedDuration(Locale locale) {
        return Messages._lastedDuration(this.run.getDurationString()).toString(locale);
    }

    public String getFontWeight() {
        if (this.isLatestBuild && this.multipleBuilds) {
            return "bold";
        }
        return "normal";
    }

    public String getUnderlineStyle() {
        if (this.underlineStyle == null) {
            return "0px";
        }
        return this.underlineStyle;
    }

    public void setFirst(boolean first) {
        this.isFirst = first;
    }

    public void setMultipleBuilds(boolean multipleBuilds) {
        this.multipleBuilds = multipleBuilds;
    }

    public void setTimeAgoString(String timeAgoString) {
        this.timeAgoString = timeAgoString;
    }

    @Override
    public int compareTo(BuildInfo that) {
        return Integer.compare(that.run.number, this.run.number);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)o;
        return this.run.number == buildInfo.run.number;
    }

    public int hashCode() {
        return Integer.hashCode(this.run.number);
    }

    public String getTextDecoration() {
        if (this.underlineStyle == null) {
            return "underline";
        }
        return "none";
    }
}

