/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.FormValidationUtil;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=110.0)
public class MainConfiguration
extends GlobalConfiguration {
    private String libs;

    public MainConfiguration() {
        this.load();
    }

    public String getDisplayName() {
        return "Continuous Integration with Toad Edge";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.libs = formData.getString("libs");
        this.save();
        return super.configure(req, formData);
    }

    public String getLibs() {
        return this.libs;
    }

    public FormValidation doCheckLibs(@QueryParameter String value) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "LibrariesFolder", new Object[0]).toString());
        if (emptyValidation != FormValidation.ok()) {
            return emptyValidation;
        }
        File file = new File(value);
        if (!file.exists()) {
            return FormValidation.error((String)new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "FileNonExistent", new Object[0]).toString());
        }
        if (!value.endsWith(".zip")) {
            return FormValidation.error((String)new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "ExpectingZippedLibs", new Object[0]).toString());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckLicense(@QueryParameter String value) {
        FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "LicenseKey", new Object[0]).toString());
        if (emptyValidation != FormValidation.ok()) {
            return emptyValidation;
        }
        return FormValidation.ok();
    }
}

