/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.DatabaseSystem;
import ci.with.toad.edge.FileUtils;
import ci.with.toad.edge.FormValidationUtil;
import ci.with.toad.edge.MainConfiguration;
import ci.with.toad.edge.ProcessLauncher;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GenerateChangeScriptBuilder
extends Builder {
    private String in;
    private String out;
    private static final String INPUT = "INPUT";
    private static final String OUTPUT = "OUTPUT";

    @DataBoundConstructor
    public GenerateChangeScriptBuilder(String in, String out) {
        this.in = in;
        this.out = out;
    }

    public String getOut() {
        return this.out;
    }

    public String getIn() {
        return this.in;
    }

    private FilePath getTmpIn(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), INPUT + build.number);
    }

    private FilePath getTmpOut(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), OUTPUT + build.number + ".sql");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        System.setOut(listener.getLogger());
        System.setErr(listener.getLogger());
        FormValidation checkValidation = FormValidationUtil.restrictLocation(this.in, build);
        if (checkValidation != FormValidation.ok()) {
            throw new Error(checkValidation.getMessage());
        }
        this.copyBuildFiles(build, listener);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("-in", this.getTmpIn(build).toURI().getPath());
        arguments.put("-out", this.getTmpOut(build).toURI().getPath());
        arguments.put("-sql_change", "");
        boolean result = ProcessLauncher.exec(arguments, build, launcher, listener) == 0;
        this.copyScriptToTargetLocation(build, listener);
        this.deleteBuildFiles(build, listener);
        return result;
    }

    private void copyBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath input = FileUtils.getFilePath(build, this.in);
        FilePath workspaceInput = this.getTmpIn(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{input, workspaceInput}).toString());
        input.copyRecursiveTo(workspaceInput);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
    }

    private void copyScriptToTargetLocation(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspaceOutput = this.getTmpOut(build);
        FilePath targetOutput = FileUtils.getFilePath(build, this.out);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{workspaceOutput, targetOutput}).toString());
        workspaceOutput.copyTo(targetOutput);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
    }

    private void deleteBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath jobInput = this.getTmpIn(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{jobInput}).toString());
        jobInput.deleteRecursive();
    }

    public ToadBuilderDescriptor getDescriptor() {
        return (ToadBuilderDescriptor)super.getDescriptor();
    }

    @Extension
    public static class ToadBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public ToadBuilderDescriptor() {
            this.load();
        }

        public ListBoxModel doFillDatabaseSystemItems() {
            ListBoxModel items = new ListBoxModel();
            for (DatabaseSystem s : DatabaseSystem.values()) {
                items.add(s.getDisplayName(), s.name());
            }
            return items;
        }

        public FormValidation doCheckOut(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "OutputFile", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIn(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "InputFolderLocation", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "GenerateChangeScript", new Object[0]).toString();
        }
    }
}

