/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.FileUtils;
import ci.with.toad.edge.MainConfiguration;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

public class FormValidationUtil {
    public static FormValidation doCheckEmptyValue(String value, String fieldName) {
        if (value.length() == 0) {
            return FormValidation.error((String)String.format(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "XMustNotBeEmpty", new Object[0]).toString(), fieldName));
        }
        return FormValidation.ok();
    }

    @Nonnull
    public static FormValidation restrictLocation(String folderPath, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath workspaceDir = build.getWorkspace();
        FilePath inputDir = FileUtils.getFilePath(build, folderPath);
        if (workspaceDir == null) {
            return FormValidation.ok();
        }
        String inputDirLocation = inputDir.toURI().getPath();
        String workspaceDirLocation = workspaceDir.toURI().getPath();
        if (workspaceDir.isRemote() != inputDir.isRemote()) {
            return FormValidation.error((String)String.format("Input folder: %s  needs to be in the job's agent node", inputDirLocation));
        }
        if (inputDirLocation.toLowerCase().contains(workspaceDirLocation.toLowerCase())) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)String.format("Specified folder or file (%s) should be inside project workspace directory", inputDirLocation));
    }
}

