/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.remoting.VirtualChannel;
import java.nio.file.Paths;

public class FileUtils {
    public static final String WORKSPACE_VAR = "${WORKSPACE}";
    public static final String JOB_ROOT_DIR_VAR = "${JOB_ROOT_DIR}";

    public static FilePath getFilePath(AbstractBuild<?, ?> build, String path) {
        if (path.startsWith(WORKSPACE_VAR)) {
            return new FilePath(build.getWorkspace(), FileUtils.getRelativePath(path.substring(WORKSPACE_VAR.length())));
        }
        if (path.startsWith(JOB_ROOT_DIR_VAR)) {
            return new FilePath(new FilePath(build.getRootDir()), FileUtils.getRelativePath(path.substring(JOB_ROOT_DIR_VAR.length())));
        }
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return new FilePath((VirtualChannel)null, path);
        }
        return new FilePath(build.getWorkspace(), path);
    }

    private static String getRelativePath(String path) {
        if (path.startsWith("./")) {
            return path.substring(2);
        }
        if (path.startsWith(".\\")) {
            return path.substring(2);
        }
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        if (path.startsWith("\\")) {
            return path.substring(1);
        }
        return path;
    }
}

