/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.DatabaseSystem;
import ci.with.toad.edge.FileUtils;
import ci.with.toad.edge.FormValidationUtil;
import ci.with.toad.edge.MainConfiguration;
import ci.with.toad.edge.ProcessLauncher;
import com.google.common.io.Files;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CompareBuilder
extends Builder {
    private String outputFolder;
    private String srcInputFileOrFolder;
    private String tgtInputFileOrFolder;
    private String configFile;
    private static final String SOURCE = "IN_SOURCE";
    private static final String TARGET = "IN_TARGET";
    private static final String CONFIG = "CONFIG";
    private static final String TMP_OUTPUT = "TMP_OUTPUT";

    @DataBoundConstructor
    public CompareBuilder(String outputFolder, String srcInputType, String tgtInputType, String srcInputFileOrFolder, String tgtInputFileOrFolder, String configFile) {
        this.outputFolder = outputFolder;
        this.srcInputFileOrFolder = srcInputFileOrFolder;
        this.tgtInputFileOrFolder = tgtInputFileOrFolder;
        this.configFile = configFile;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getSrcInputFileOrFolder() {
        return this.srcInputFileOrFolder;
    }

    public String getTgtInputFileOrFolder() {
        return this.tgtInputFileOrFolder;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    private FilePath getTmpInSource(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath sourceInput = FileUtils.getFilePath(build, this.srcInputFileOrFolder);
        if (sourceInput.isDirectory()) {
            return new FilePath(build.getWorkspace(), SOURCE + build.number);
        }
        return new FilePath(build.getWorkspace(), SOURCE + build.number + "." + Files.getFileExtension((String)sourceInput.getName()));
    }

    private FilePath getTmpInTarget(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath targetInput = FileUtils.getFilePath(build, this.tgtInputFileOrFolder);
        if (targetInput.isDirectory()) {
            return new FilePath(build.getWorkspace(), TARGET + build.number);
        }
        return new FilePath(build.getWorkspace(), TARGET + build.number + "." + Files.getFileExtension((String)targetInput.getName()));
    }

    private FilePath getTmpOutput(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), TMP_OUTPUT + build.number);
    }

    private FilePath getTmpConfig(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), CONFIG + build.number);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        System.setOut(listener.getLogger());
        System.setErr(listener.getLogger());
        FormValidation checkValidation = FormValidationUtil.restrictLocation(this.srcInputFileOrFolder, build);
        if (checkValidation != FormValidation.ok()) {
            throw new Error(checkValidation.getMessage());
        }
        FormValidation checkValidationTarget = FormValidationUtil.restrictLocation(this.tgtInputFileOrFolder, build);
        if (checkValidationTarget != FormValidation.ok()) {
            throw new Error(checkValidationTarget.getMessage());
        }
        FormValidation checkValidationConfig = FormValidationUtil.restrictLocation(this.configFile, build);
        if (checkValidationConfig != FormValidation.ok()) {
            throw new Error(checkValidationConfig.getMessage());
        }
        this.copyBuildFiles(build, listener);
        this.ensureTmpOutputFolder(build, listener);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("-in_source", this.getTmpInSource(build).toURI().getPath());
        arguments.put("-in_target", this.getTmpInTarget(build).toURI().getPath());
        arguments.put("-out", this.getTmpOutput(build).toURI().getPath());
        if (this.configFile != null && !this.configFile.isEmpty()) {
            arguments.put("-settings", this.getTmpConfig(build).toURI().getPath());
        }
        arguments.put("-compare", "");
        boolean result = ProcessLauncher.exec(arguments, build, launcher, listener) == 0;
        this.copyOutputFromTmp(build, listener);
        this.deleteBuildFiles(build, listener);
        return result;
    }

    private void copyOutputFromTmp(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath tmpOutput = this.getTmpOutput(build);
        FilePath output = FileUtils.getFilePath(build, this.outputFolder);
        if (!output.exists()) {
            output.mkdirs();
        }
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{tmpOutput, output}).toString());
        tmpOutput.copyRecursiveTo(output);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
    }

    private void ensureTmpOutputFolder(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath tmpOutput = this.getTmpOutput(build);
        if (!tmpOutput.exists()) {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CreatingTmpFolder", new Object[]{tmpOutput}).toString());
            tmpOutput.mkdirs();
        }
    }

    private void copyBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspaceTarget;
        FilePath workspaceSource;
        FilePath sourceInput = FileUtils.getFilePath(build, this.srcInputFileOrFolder);
        FilePath targetInput = FileUtils.getFilePath(build, this.tgtInputFileOrFolder);
        FilePath config = FileUtils.getFilePath(build, this.configFile);
        if (sourceInput.isDirectory()) {
            workspaceSource = this.getTmpInSource(build);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{sourceInput, workspaceSource}).toString());
            sourceInput.copyRecursiveTo(workspaceSource);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        } else {
            workspaceSource = this.getTmpInSource(build);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{sourceInput, workspaceSource}).toString());
            sourceInput.copyTo(workspaceSource);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        }
        if (targetInput.isDirectory()) {
            workspaceTarget = this.getTmpInTarget(build);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{targetInput, workspaceTarget}).toString());
            targetInput.copyRecursiveTo(workspaceTarget);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        } else {
            workspaceTarget = this.getTmpInTarget(build);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{targetInput, workspaceTarget}).toString());
            targetInput.copyTo(workspaceTarget);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        }
        if (this.configFile != null && !this.configFile.isEmpty()) {
            FilePath workspaceConfig = this.getTmpConfig(build);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{config, workspaceConfig}).toString());
            config.copyTo(workspaceConfig);
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        }
    }

    private void deleteBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath sourceInput = this.getTmpInSource(build);
        FilePath targetInput = this.getTmpInTarget(build);
        FilePath config = this.getTmpConfig(build);
        if (sourceInput.isDirectory()) {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{sourceInput}).toString());
            sourceInput.deleteRecursive();
        } else {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{sourceInput}).toString());
            sourceInput.delete();
        }
        if (targetInput.isDirectory()) {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{targetInput}).toString());
            targetInput.deleteRecursive();
        } else {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{targetInput}).toString());
            targetInput.delete();
        }
        if (this.configFile != null && !this.configFile.isEmpty()) {
            listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{config}).toString());
            config.delete();
        }
        FilePath output = this.getTmpOutput(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{output}).toString());
        output.deleteRecursive();
    }

    public CompareBuilderDescriptor getDescriptor() {
        return (CompareBuilderDescriptor)super.getDescriptor();
    }

    @Extension
    public static class CompareBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public CompareBuilderDescriptor() {
            this.load();
        }

        public ListBoxModel doFillDatabaseSystemItems() {
            ListBoxModel items = new ListBoxModel();
            for (DatabaseSystem s : DatabaseSystem.values()) {
                items.add(s.getDisplayName(), s.name());
            }
            return items;
        }

        public FormValidation doCheckOutputFolder(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "OutputFolderName", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        private FormValidation doCheckInputFileOrFolder(String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "InputFileOrFolderLocation", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSrcInputFileOrFolder(@QueryParameter String value) {
            return this.doCheckInputFileOrFolder(value);
        }

        public FormValidation doCheckTgtInputFileOrFolder(@QueryParameter String value) {
            return this.doCheckInputFileOrFolder(value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "RunCompare", new Object[0]).toString();
        }
    }
}

