/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.global;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.build_timeout.global.TimeOut;
import hudson.plugins.build_timeout.global.TimeOutProvider;
import hudson.plugins.build_timeout.global.TimeOutStore;
import hudson.plugins.build_timeout.global.TimeOutTask;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Extension
@Singleton
public class GlobalTimeOutRunListener
extends RunListener<Run<?, ?>> {
    private final ScheduledExecutorService scheduler;
    private final TimeOutProvider timeOutProvider;
    private final TimeOutStore store;

    public GlobalTimeOutRunListener() {
        this(null, null, null);
    }

    @Inject
    public GlobalTimeOutRunListener(@TimeOut ScheduledExecutorService scheduler, TimeOutProvider timeOutProvider, TimeOutStore store) {
        this.scheduler = scheduler;
        this.timeOutProvider = timeOutProvider;
        this.store = store;
    }

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        this.timeOutProvider.timeOutFor(build, listener).map(duration -> this.scheduler.schedule(TimeOutTask.create(this.timeOutProvider, build, listener, duration), duration.toMillis(), TimeUnit.MILLISECONDS)).ifPresent(future -> this.store.scheduled(build.getExternalizableId(), (ScheduledFuture<?>)future));
        return super.setUpEnvironment(build, launcher, listener);
    }

    public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
        this.store.cancel(run.getExternalizableId());
    }
}

