/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildPipelineForm;
import au.com.centrumsystems.hudson.plugin.buildpipeline.DownstreamProjectGridBuilder;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectForm;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectGrid;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectGridBuilder;
import au.com.centrumsystems.hudson.plugin.buildpipeline.Strings;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.BuildCardExtension;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.BuildVariablesHeader;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.NullColumnHeader;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.PipelineHeaderExtension;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.PipelineHeaderExtensionDescriptor;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.SimpleColumnHeader;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.SimpleRowHeader;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.StandardBuildCard;
import au.com.centrumsystems.hudson.plugin.util.ProjectUtil;
import com.google.common.collect.Iterables;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class BuildPipelineView
extends View {
    @Deprecated
    private volatile String selectedJob;
    private ProjectGridBuilder gridBuilder;
    private String noOfDisplayedBuilds;
    private String buildViewTitle = "";
    private String consoleOutputLinkStyle = "Lightbox";
    private String cssUrl = "";
    private boolean triggerOnlyLatestJob;
    private boolean alwaysAllowManualTrigger = true;
    @Deprecated
    private boolean showPipelineParameters = true;
    private PipelineHeaderExtension rowHeaders;
    @Deprecated
    private boolean showPipelineParametersInHeaders;
    private PipelineHeaderExtension columnHeaders;
    private BuildCardExtension buildCard;
    @Deprecated
    private boolean startsWithParameters;
    private int refreshFrequency = 3;
    private boolean showPipelineDefinitionHeader;
    private static final Logger LOGGER = Logger.getLogger(BuildPipelineView.class.getName());

    public BuildPipelineView(String name, String buildViewTitle, ProjectGridBuilder gridBuilder, String noOfDisplayedBuilds, boolean triggerOnlyLatestJob, String cssUrl) {
        super(name, (ViewGroup)Hudson.getInstance());
        this.buildViewTitle = buildViewTitle;
        this.gridBuilder = gridBuilder;
        this.noOfDisplayedBuilds = noOfDisplayedBuilds;
        this.triggerOnlyLatestJob = triggerOnlyLatestJob;
        this.cssUrl = cssUrl;
        this.rowHeaders = new SimpleRowHeader();
        this.columnHeaders = new NullColumnHeader();
    }

    @DataBoundConstructor
    public BuildPipelineView(String name, String buildViewTitle, ProjectGridBuilder gridBuilder, String noOfDisplayedBuilds, boolean triggerOnlyLatestJob, boolean alwaysAllowManualTrigger, boolean showPipelineParameters, boolean showPipelineParametersInHeaders, boolean showPipelineDefinitionHeader, int refreshFrequency, String cssUrl, String selectedJob, PipelineHeaderExtension columnHeaders, PipelineHeaderExtension rowHeaders, BuildCardExtension buildCard) {
        this(name, buildViewTitle, gridBuilder, noOfDisplayedBuilds, triggerOnlyLatestJob, cssUrl);
        this.alwaysAllowManualTrigger = alwaysAllowManualTrigger;
        this.showPipelineParameters = showPipelineParameters;
        this.showPipelineParametersInHeaders = showPipelineParametersInHeaders;
        this.showPipelineDefinitionHeader = showPipelineDefinitionHeader;
        this.selectedJob = selectedJob;
        this.columnHeaders = columnHeaders;
        this.rowHeaders = rowHeaders;
        this.buildCard = buildCard;
        this.refreshFrequency = refreshFrequency < 1 ? 3 : refreshFrequency;
        if (this.gridBuilder == null && this.selectedJob != null) {
            this.gridBuilder = new DownstreamProjectGridBuilder(this.selectedJob);
        }
        if (this.selectedJob == null && this.gridBuilder != null && this.gridBuilder instanceof DownstreamProjectGridBuilder) {
            this.selectedJob = ((DownstreamProjectGridBuilder)this.gridBuilder).getFirstJob();
        }
    }

    protected Object readResolve() {
        if (this.gridBuilder == null && this.selectedJob != null) {
            this.gridBuilder = new DownstreamProjectGridBuilder(this.selectedJob);
        }
        if (this.columnHeaders == null) {
            this.columnHeaders = !this.showPipelineDefinitionHeader ? new NullColumnHeader() : (this.showPipelineParametersInHeaders ? new BuildVariablesHeader() : new SimpleColumnHeader());
        }
        if (this.rowHeaders == null) {
            this.rowHeaders = this.showPipelineParameters ? new BuildVariablesHeader() : new SimpleRowHeader();
        }
        if (this.buildCard == null) {
            this.buildCard = new StandardBuildCard();
        }
        return this;
    }

    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        req.bindJSON((Object)this, req.getSubmittedForm());
    }

    public boolean hasBuildPermission() {
        return this.getGridBuilder().hasBuildPermission(this);
    }

    public boolean isProjectParameterized() {
        return this.getGridBuilder().startsWithParameters(this);
    }

    public PipelineHeaderExtension getColumnHeaders() {
        return this.columnHeaders;
    }

    public void setColumnHeaders(PipelineHeaderExtension columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    public PipelineHeaderExtension getRowHeaders() {
        return this.rowHeaders;
    }

    public void setRowHeaders(PipelineHeaderExtension rowHeaders) {
        this.rowHeaders = rowHeaders;
    }

    public BuildCardExtension getBuildCard() {
        return this.buildCard;
    }

    public void setBuildCard(BuildCardExtension buildCard) {
        this.buildCard = buildCard;
    }

    public boolean hasConfigurePermission() {
        return this.hasPermission(CONFIGURE);
    }

    public ProjectGridBuilder getGridBuilder() {
        return this.gridBuilder;
    }

    public void setGridBuilder(ProjectGridBuilder gridBuilder) {
        this.gridBuilder = gridBuilder;
    }

    public List<AbstractProject<?, ?>> getDownstreamProjects(AbstractProject<?, ?> currentProject) {
        return ProjectUtil.getDownstreamProjects(currentProject);
    }

    public boolean hasDownstreamProjects(AbstractProject<?, ?> currentProject) {
        return this.getDownstreamProjects(currentProject).size() > 0;
    }

    public BuildPipelineForm getBuildPipelineForm() {
        if (this.noOfDisplayedBuilds == null) {
            return null;
        }
        int maxNoOfDisplayBuilds = Integer.valueOf(this.noOfDisplayedBuilds);
        if (this.gridBuilder == null) {
            return null;
        }
        ProjectGrid project = this.gridBuilder.build(this);
        if (project.isEmpty()) {
            return null;
        }
        return new BuildPipelineForm(project, Iterables.limit(project.builds(), (int)maxNoOfDisplayBuilds));
    }

    public String getProjectURL(AbstractProject<?, ?> project) throws URISyntaxException {
        return project.getUrl();
    }

    @JavaScriptMethod
    public int triggerManualBuild(Integer upstreamBuildNumber, String triggerProjectName, String upstreamProjectName) {
        return this.buildCard.triggerManualBuild(this.getOwnerItemGroup(), upstreamBuildNumber, triggerProjectName, upstreamProjectName);
    }

    @JavaScriptMethod
    public int rerunBuild(String externalizableId) {
        LOGGER.info("Running build again: " + externalizableId);
        return this.buildCard.rerunBuild(externalizableId);
    }

    public String getBuildViewTitle() {
        return this.buildViewTitle;
    }

    public void setBuildViewTitle(String buildViewTitle) {
        this.buildViewTitle = buildViewTitle;
    }

    public String getCssUrl() {
        return this.cssUrl;
    }

    public void setCssUrl(String cssUrl) {
        this.cssUrl = cssUrl;
    }

    public String getNoOfDisplayedBuilds() {
        return this.noOfDisplayedBuilds;
    }

    public void setNoOfDisplayedBuilds(String noOfDisplayedBuilds) {
        this.noOfDisplayedBuilds = noOfDisplayedBuilds;
    }

    public String getConsoleOutputLinkStyle() {
        return this.consoleOutputLinkStyle;
    }

    public void setConsoleOutputLinkStyle(String consoleOutputLinkStyle) {
        this.consoleOutputLinkStyle = consoleOutputLinkStyle;
    }

    public boolean isNewWindowConsoleOutputLinkStyle() {
        return "New Window".equals(this.consoleOutputLinkStyle);
    }

    public boolean isThisWindowConsoleOutputLinkStyle() {
        return "This Window".equals(this.consoleOutputLinkStyle);
    }

    public boolean isTriggerOnlyLatestJob() {
        return this.triggerOnlyLatestJob;
    }

    public String getTriggerOnlyLatestJob() {
        return Boolean.toString(this.triggerOnlyLatestJob);
    }

    public void setTriggerOnlyLatestJob(boolean triggerOnlyLatestJob) {
        this.triggerOnlyLatestJob = triggerOnlyLatestJob;
    }

    public boolean isAlwaysAllowManualTrigger() {
        return this.alwaysAllowManualTrigger;
    }

    public String getAlwaysAllowManualTrigger() {
        return Boolean.toString(this.alwaysAllowManualTrigger);
    }

    public void setAlwaysAllowManualTrigger(boolean alwaysAllowManualTrigger) {
        this.alwaysAllowManualTrigger = alwaysAllowManualTrigger;
    }

    public int getRefreshFrequency() {
        return this.refreshFrequency;
    }

    public void setRefreshFrequency(int refreshFrequency) {
        this.refreshFrequency = refreshFrequency;
    }

    public int getRefreshFrequencyInMillis() {
        return this.refreshFrequency * 1000;
    }

    public boolean isShowPipelineDefinitionHeader() {
        return this.showPipelineDefinitionHeader;
    }

    public String getShowPipelineDefinitionHeader() {
        return Boolean.toString(this.showPipelineDefinitionHeader);
    }

    public void setShowPipelineDefinitionHeader(boolean showPipelineDefinitionHeader) {
        this.showPipelineDefinitionHeader = showPipelineDefinitionHeader;
    }

    public Collection<TopLevelItem> getItems() {
        ArrayList<TopLevelItem> items = new ArrayList<TopLevelItem>();
        BuildPipelineForm buildPipelineForm = this.getBuildPipelineForm();
        if (buildPipelineForm != null) {
            ProjectGrid grid = buildPipelineForm.getProjectGrid();
            for (int row = 0; row < grid.getRows(); ++row) {
                for (int col = 0; col < grid.getColumns(); ++col) {
                    Item item;
                    ProjectForm form = (ProjectForm)grid.get(row, col);
                    if (form == null || (item = Jenkins.getInstance().getItem(form.getName(), this.getOwnerItemGroup())) == null || !(item instanceof TopLevelItem)) continue;
                    items.add((TopLevelItem)item);
                }
            }
        }
        return items;
    }

    public boolean contains(TopLevelItem item) {
        return this.getItems().contains(item);
    }

    public void onJobRenamed(Item item, String oldName, String newName) {
        LOGGER.fine(String.format("Renaming job: %s -> %s", oldName, newName));
        try {
            if (this.gridBuilder != null) {
                this.gridBuilder.onJobRenamed(this, item, oldName, newName);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to handle onJobRenamed", e);
        }
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return Hudson.getInstance().doCreateItem(req, rsp);
    }

    public boolean hasPermission(Permission p) {
        try {
            return super.hasPermission(p);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Error in hasPermission: ", t);
            return false;
        }
    }

    private boolean isEmpty() {
        if (this.noOfDisplayedBuilds == null || this.gridBuilder == null) {
            return true;
        }
        return this.gridBuilder.build(this).isEmpty();
    }

    private static final class LinkStyle {
        static final String LIGHTBOX = "Lightbox";
        static final String NEW_WINDOW = "New Window";
        static final String THIS_WINDOW = "This Window";

        private LinkStyle() {
        }
    }

    public static interface Function<F, T> {
        public T apply(F var1);
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return Strings.getString("BuildPipelineView.DisplayText");
        }

        public ListBoxModel doFillNoOfDisplayedBuildsItems() {
            ListBoxModel options = new ListBoxModel();
            ArrayList<String> noOfBuilds = new ArrayList<String>();
            noOfBuilds.add("1");
            noOfBuilds.add("2");
            noOfBuilds.add("3");
            noOfBuilds.add("5");
            noOfBuilds.add("10");
            noOfBuilds.add("20");
            noOfBuilds.add("50");
            noOfBuilds.add("100");
            noOfBuilds.add("200");
            noOfBuilds.add("500");
            for (String noOfBuild : noOfBuilds) {
                options.add(noOfBuild);
            }
            return options;
        }

        public List<PipelineHeaderExtensionDescriptor> filter(Function<PipelineHeaderExtensionDescriptor, Boolean> condition) {
            ArrayList<PipelineHeaderExtensionDescriptor> result = new ArrayList<PipelineHeaderExtensionDescriptor>();
            for (PipelineHeaderExtensionDescriptor descriptor : PipelineHeaderExtensionDescriptor.all()) {
                if (!condition.apply(descriptor).booleanValue()) continue;
                result.add(descriptor);
            }
            Collections.sort(result);
            return result;
        }

        public List<PipelineHeaderExtensionDescriptor> getRowHeaderDescriptors() {
            return this.filter(new Function<PipelineHeaderExtensionDescriptor, Boolean>(){

                @Override
                public Boolean apply(PipelineHeaderExtensionDescriptor extension) {
                    return extension.appliesToRows();
                }
            });
        }

        public List<PipelineHeaderExtensionDescriptor> getColumnHeaderDescriptors() {
            return this.filter(new Function<PipelineHeaderExtensionDescriptor, Boolean>(){

                @Override
                public Boolean apply(PipelineHeaderExtensionDescriptor extension) {
                    return extension.appliesToColumns();
                }
            });
        }

        public List<Descriptor<BuildCardExtension>> getBuildCardDescriptors() {
            ArrayList<Descriptor<BuildCardExtension>> result = new ArrayList<Descriptor<BuildCardExtension>>();
            for (BuildCardExtension extension : BuildCardExtension.all()) {
                result.add((Descriptor<BuildCardExtension>)extension.getDescriptor());
            }
            return result;
        }

        public ListBoxModel doFillConsoleOutputLinkStyleItems() {
            ListBoxModel options = new ListBoxModel();
            options.add("Lightbox");
            options.add("New Window");
            options.add("This Window");
            return options;
        }
    }

    @Deprecated
    private static class MyUserIdCause
    extends Cause.UserIdCause {
        private MyUserIdCause() {
        }
    }
}

