/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.aquadockerscannerbuildstep;

import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AquaScannerRegistryLogin {
    private Launcher launcher;
    private TaskListener listener;
    private int retryAttempts;
    private static final Pattern SHARegexp = Pattern.compile("^(?:([^/]+)/)([^@]+)(@sha256:[0-9a-f]+)$");
    private static final Pattern SplitImageNameRegexp = Pattern.compile("^(?:([^/]+)/)?([^:]+)(?::(.*))?$");
    private static final Pattern PortRegexp = Pattern.compile(":\\d+$");

    public AquaScannerRegistryLogin(Launcher launcher, TaskListener listener) {
        this.launcher = launcher;
        this.listener = listener;
    }

    public boolean checkAndPerformRegistryLogin(String containerRuntime, String imageName, String username, Secret password) {
        String runtime = this.resolveContainerRuntime(containerRuntime);
        if (this.imageExists(runtime, imageName)) {
            return true;
        }
        if (!username.isEmpty()) {
            return this.registryLogin(runtime, this.getRegistryName(imageName), username, password, 1);
        }
        return true;
    }

    private boolean registryLogin(String containerRuntime, String registryName, String userName, Secret password, int maxRetries) {
        if (this.retryAttempts > maxRetries) {
            return false;
        }
        Launcher.ProcStarter ps = this.launcher.launch();
        ArgumentListBuilder args = new ArgumentListBuilder();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        args.add(new String[]{containerRuntime, "login", registryName});
        args.add("-u").addMasked(userName);
        args.add("--password-stdin");
        ps.cmds(args).stdin((InputStream)new ByteArrayInputStream((password.getPlainText() + "\n").getBytes(StandardCharsets.UTF_8))).stderr((OutputStream)outputStream).stdout((OutputStream)outputStream);
        try {
            int exitCode = ps.join();
            String result = outputStream.toString(StandardCharsets.UTF_8.name()).trim();
            if (exitCode != 0) {
                this.listener.getLogger().println("Authentication failed: incorrect credentials provided. Please provide valid registry credentials.");
                this.listener.getLogger().println(result);
                return false;
            }
            this.listener.getLogger().println("Authenticated with registry successfully.");
            return true;
        }
        catch (Exception e) {
            this.listener.getLogger().println("Registry login failed: " + e.getMessage());
            ++this.retryAttempts;
            return this.registryLogin(containerRuntime, registryName, userName, password, maxRetries);
        }
    }

    public String getRegistryName(String imageName) {
        String registry = "";
        if (imageName == null || imageName.isEmpty()) {
            return registry;
        }
        Matcher shaMatcher = SHARegexp.matcher(imageName);
        if (shaMatcher.matches() && shaMatcher.groupCount() == 3) {
            registry = shaMatcher.group(1);
        } else {
            Matcher nameMatcher = SplitImageNameRegexp.matcher(imageName);
            if (nameMatcher.matches() && nameMatcher.groupCount() >= 3) {
                registry = nameMatcher.group(1);
            }
        }
        if (!registry.isEmpty() && !PortRegexp.matcher(registry).matches()) {
            try {
                InetAddress.getByName(registry);
            }
            catch (UnknownHostException e) {
                this.listener.getLogger().println("Warning: unable to validate DNS/IP of registry: " + registry);
            }
        }
        return registry;
    }

    private boolean imageExists(String containerRuntime, String imageName) {
        boolean bl;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{containerRuntime, "inspect", "--format={{.RepoTags}}", imageName});
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int exitCode = this.launcher.launch().cmds(args).stdin(null).stderr((OutputStream)outputStream).stdout((OutputStream)outputStream).join();
            bl = exitCode == 0 && !outputStream.toString(StandardCharsets.UTF_8.name()).trim().isEmpty();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.listener.getLogger().println("Error checking image existence: " + e.getMessage());
                return false;
            }
        }
        outputStream.close();
        return bl;
    }

    private String resolveContainerRuntime(String containerRuntime) {
        return "podman".equals(containerRuntime) ? "podman" : "docker";
    }
}

