/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.aquadockerscannerbuildstep;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.aquadockerscannerbuildstep.AquaScannerAction;
import org.jenkinsci.plugins.aquadockerscannerbuildstep.AquaScannerRegistryLogin;
import org.jenkinsci.plugins.aquadockerscannerbuildstep.ScannerExecuter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AquaDockerScannerBuilder
extends Builder
implements SimpleBuildStep {
    public static final int OK_CODE = 0;
    public static final int DISALLOWED_CODE = 4;
    private final String locationType;
    private final String registry;
    private final boolean register;
    private final String localImage;
    private final String hostedImage;
    private final String onDisallowed;
    private final String notCompliesCmd;
    private final boolean hideBase;
    private final boolean showNegligible;
    private final String policies;
    private final String customFlags;
    private String runtimeDirectory;
    @CheckForNull
    private String containerRuntime;
    @CheckForNull
    private String scannerPath;
    @CheckForNull
    private String tarFilePath;
    @CheckForNull
    private String localToken;
    private Secret localTokenSecret;

    @DataBoundConstructor
    public AquaDockerScannerBuilder(String locationType, String registry, boolean register, String localImage, String hostedImage, String onDisallowed, String notCompliesCmd, boolean hideBase, boolean showNegligible, String policies, String localToken, String customFlags, String tarFilePath, String containerRuntime, String scannerPath, String runtimeDirectory) {
        this.locationType = locationType;
        this.registry = registry;
        this.register = register;
        this.localImage = localImage;
        this.hostedImage = hostedImage;
        this.onDisallowed = onDisallowed;
        this.notCompliesCmd = notCompliesCmd;
        this.hideBase = hideBase;
        this.showNegligible = showNegligible;
        this.policies = policies;
        this.localToken = localToken;
        this.customFlags = customFlags;
        this.tarFilePath = tarFilePath;
        this.containerRuntime = containerRuntime;
        this.scannerPath = scannerPath;
        this.localTokenSecret = Secret.fromString((String)localToken);
        this.runtimeDirectory = Util.fixNull((String)runtimeDirectory);
    }

    public String getLocationType() {
        return this.locationType;
    }

    @CheckForNull
    public String getContainerRuntime() {
        return this.containerRuntime;
    }

    @CheckForNull
    public String getScannerPath() {
        return this.scannerPath;
    }

    public String getRegistry() {
        return this.registry;
    }

    public boolean getRegister() {
        return this.register;
    }

    public String getLocalImage() {
        return this.localImage;
    }

    public String getHostedImage() {
        return this.hostedImage;
    }

    public String getOnDisallowed() {
        return this.onDisallowed;
    }

    public String getNotCompliesCmd() {
        return this.notCompliesCmd;
    }

    public String getPolicies() {
        return this.policies;
    }

    @CheckForNull
    public String getLocalToken() {
        return this.localToken;
    }

    public String getCustomFlags() {
        return this.customFlags;
    }

    public boolean getHideBase() {
        return this.hideBase;
    }

    public boolean getShowNegligible() {
        return this.showNegligible;
    }

    public String getRuntimeDirectory() {
        return this.runtimeDirectory;
    }

    @CheckForNull
    public String getTarFilePath() {
        return this.tarFilePath;
    }

    public String isLocationType(String type) {
        if (this.locationType == null) {
            return "local".equals(type) ? "true" : "false";
        }
        return this.locationType.equals(type) ? "true" : "false";
    }

    public String isOnDisallowed(String state) {
        if (this.onDisallowed == null) {
            return "ignore".equals(state) ? "true" : "false";
        }
        return this.onDisallowed.equals(state) ? "true" : "false";
    }

    @DataBoundSetter
    public void setContainerRuntime(@CheckForNull String containerRuntime) {
        this.containerRuntime = (String)Util.fixNull((Object)containerRuntime, (Object)"docker");
    }

    @DataBoundSetter
    public void setScannerPath(@CheckForNull String scannerPath) {
        this.scannerPath = Util.fixNull((String)scannerPath);
    }

    @DataBoundSetter
    public void setTarFilePath(@CheckForNull String tarFilePath) {
        this.tarFilePath = Util.fixNull((String)tarFilePath);
    }

    @DataBoundSetter
    public void setLocalToken(@CheckForNull String localToken) {
        this.localToken = Util.fixNull((String)localToken);
    }

    @DataBoundSetter
    public void setRuntimeDirectory(@CheckForNull String runtimeDirectory) {
        this.runtimeDirectory = Util.fixNull((String)runtimeDirectory);
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException, InterruptedException {
        boolean loginSuccess;
        boolean tokenAuth;
        String aquaScannerImage = this.getDescriptor().getAquaScannerImage();
        String registryUsername = this.getDescriptor().getRegistryUsername();
        Secret registryPassword = this.getDescriptor().getRegistryPassword();
        String apiURL = this.getDescriptor().getApiURL();
        String user = this.getDescriptor().getUser();
        Secret password = this.getDescriptor().getPassword();
        Secret token = this.getDescriptor().getToken();
        String registryAuthType = this.getDescriptor().getRegistryAuthType();
        if ("".equals(user) && Secret.toString((Secret)password).equals("") && Secret.toString((Secret)token).equals("") && Secret.toString((Secret)this.localTokenSecret).equals("")) {
            throw new AbortException("Either Username/Password or Token should be provided in Global Settings, or valid token provided with in Token field in the build configuration");
        }
        int timeout = this.getDescriptor().getTimeout();
        String runOptions = this.getDescriptor().getRunOptions();
        boolean caCertificates = this.getDescriptor().getCaCertificates();
        boolean userAuth = user == null || user.trim().equals("") || password == null || Secret.toString((Secret)password).trim().equals("");
        boolean bl = tokenAuth = token == null || Secret.toString((Secret)token).trim().equals("");
        if (apiURL == null || apiURL.trim().equals("") || userAuth && tokenAuth) {
            throw new AbortException("Missing configuration. Please set the global configuration parameters in The \"Aqua Security\" section under  \"Manage Jenkins/Configure System\", before continuing.\n");
        }
        if (apiURL.indexOf("://") == -1) {
            apiURL = "https://" + apiURL;
        }
        String artifactSuffix = UUID.randomUUID().toString().replaceAll("-", "");
        String artifactName = "scanout-" + artifactSuffix + ".html";
        String displayImageName = "";
        switch (this.locationType) {
            case "hosted": {
                displayImageName = this.hostedImage;
                break;
            }
            case "local": {
                displayImageName = this.localImage;
                break;
            }
            case "dockerarchive": {
                Path path = Paths.get(this.tarFilePath, new String[0]);
                Path fileName = path.getFileName();
                if (fileName == null) {
                    throw new AbortException("can not extract the file name \n");
                }
                displayImageName = fileName.toString().split("\\.")[0];
                break;
            }
            default: {
                displayImageName = "";
            }
        }
        if (registryAuthType != null && registryAuthType.equals("pipelineAuth") && (this.containerRuntime == null || this.containerRuntime.isEmpty() || this.containerRuntime.equals("docker") || this.containerRuntime.equals("podman")) && !(loginSuccess = new AquaScannerRegistryLogin(launcher, listener).checkAndPerformRegistryLogin(this.containerRuntime, aquaScannerImage, registryUsername, registryPassword))) {
            throw new AbortException("Registry login failed.");
        }
        int exitCode = ScannerExecuter.execute(build, workspace, launcher, listener, artifactName, aquaScannerImage, apiURL, user, password, token, timeout, runOptions, this.locationType, this.localImage, this.registry, this.register, this.hostedImage, this.hideBase, this.showNegligible, this.onDisallowed == null || !this.onDisallowed.equals("fail"), this.notCompliesCmd, caCertificates, this.policies, this.localTokenSecret, this.customFlags, this.tarFilePath, this.containerRuntime, this.scannerPath, this.runtimeDirectory);
        build.addAction((Action)new AquaScannerAction(build, artifactSuffix, artifactName, displayImageName));
        this.archiveArtifacts(build, workspace, launcher, listener);
        listener.getLogger().println("exitCode: " + exitCode);
        String failedMessage = "Scanning failed.";
        switch (exitCode) {
            case 0: {
                listener.getLogger().println("Scanning success.");
                break;
            }
            case 4: {
                throw new AbortException(failedMessage);
            }
            default: {
                throw new AbortException(failedMessage);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void archiveArtifacts(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException {
        try {
            ArtifactArchiver artifactArchiver = new ArtifactArchiver("scanout*");
            artifactArchiver.perform(build, workspace, launcher, listener);
        }
        catch (Exception e) {
            throw new InterruptedException("Failed to setup build results due to an unexpected error. Please refer to above logs for more information");
        }
        try {
            ArtifactArchiver styleArtifactArchiver = new ArtifactArchiver("styles.css");
            styleArtifactArchiver.perform(build, workspace, launcher, listener);
        }
        catch (Exception e) {
            throw new InterruptedException("Failed to setup build results due to an unexpected error. Please refer to above logs for more information");
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"aqua"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String aquaScannerImage;
        private Secret registryUsername;
        private Secret registryPassword;
        private String registryAuthType;
        private Secret apiURL;
        private String authval;
        private Secret user;
        private Secret password;
        private Secret token;
        private int timeout;
        private String runOptions;
        private boolean caCertificates;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) throws IOException, ServletException {
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Must be a number");
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Aqua Security";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.aquaScannerImage = formData.getString("aquaScannerImage");
            this.apiURL = Secret.fromString((String)formData.getString("apiURL"));
            JSONObject authForm = formData.getJSONObject("auth");
            JSONObject registryAuthForm = formData.getJSONObject("registryAuth");
            this.authval = authForm.getString("value");
            this.registryAuthType = registryAuthForm.getString("value");
            try {
                if (this.authval.equals("token")) {
                    this.token = Secret.fromString((String)authForm.getString("token"));
                    this.user = Secret.fromString((String)"");
                    this.password = Secret.fromString((String)"");
                } else {
                    this.user = Secret.fromString((String)authForm.getString("user"));
                    this.password = Secret.fromString((String)authForm.getString("password"));
                    this.token = Secret.fromString((String)"");
                }
                if (this.registryAuthType.equals("pipelineAuth")) {
                    this.registryUsername = Secret.fromString((String)registryAuthForm.getString("registryUsername"));
                    this.registryPassword = Secret.fromString((String)registryAuthForm.getString("registryPassword"));
                } else {
                    this.registryUsername = null;
                    this.registryPassword = null;
                }
            }
            catch (JSONException te) {
                throw new Descriptor.FormException("Either Username/PWD or token must be set. Error is " + te.getMessage(), "auth");
            }
            try {
                this.timeout = formData.getInt("timeout");
            }
            catch (JSONException e) {
                throw new Descriptor.FormException("Timeout value must be a number.", "timeout");
            }
            this.runOptions = formData.getString("runOptions");
            this.caCertificates = formData.getBoolean("caCertificates");
            this.save();
            return super.configure(req, formData);
        }

        public String getAquaScannerImage() {
            return this.aquaScannerImage;
        }

        public String getApiURL() {
            return Secret.toString((Secret)this.apiURL);
        }

        public String getRegistryUsername() {
            return Secret.toString((Secret)this.registryUsername);
        }

        public Secret getRegistryPassword() {
            return this.registryPassword;
        }

        public String getRegistryAuthType() {
            return this.registryAuthType;
        }

        public String getAuthVal() {
            return this.authval;
        }

        public String getUser() {
            return Secret.toString((Secret)this.user);
        }

        public Secret getPassword() {
            return this.password;
        }

        public Secret getToken() {
            return this.token;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String getRunOptions() {
            return this.runOptions;
        }

        public String isAuthType(String auth) {
            Logger.getLogger("").log(Level.INFO, "Checking auth type:" + auth);
            Logger.getLogger("").log(Level.INFO, "Saved auth type:" + this.getAuthVal());
            if (this.getAuthVal() == null) {
                return "uname".equals(auth) ? "true" : "false";
            }
            return this.getAuthVal().equals(auth) ? "true" : "false";
        }

        public String isRegistryAuthType(String auth) {
            if (this.getRegistryAuthType() == null) {
                return "manualAuth".equals(auth) ? "true" : "false";
            }
            return this.getRegistryAuthType().equals(auth) ? "true" : "false";
        }

        public boolean getCaCertificates() {
            return this.caCertificates;
        }
    }
}

