/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import com.android.apksig.ApkSigner;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.BuildListenerAdapter;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.androidsigning.Apk;
import org.jenkinsci.plugins.androidsigning.Messages;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SignApksBuilder
extends Builder
implements SimpleBuildStep {
    private static final List<DomainRequirement> NO_REQUIREMENTS = Collections.emptyList();
    private List<Apk> entries = Collections.emptyList();

    @DataBoundConstructor
    public SignApksBuilder(List<Apk> apks) {
        this.entries = apks;
        if (this.entries == null) {
            this.entries = Collections.emptyList();
        }
    }

    private boolean isIntermediateFailure(Run build) {
        Result result = build.getResult();
        return result != null && result.isWorseThan(Result.UNSTABLE);
    }

    public List<Apk> getEntries() {
        return this.entries;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (this.isIntermediateFailure(run)) {
            listener.getLogger().println("[SignApksBuilder] skipping Sign APKs step because a previous step failed");
            return;
        }
        LinkedHashMap<String, String> apksToArchive = new LinkedHashMap<String, String>();
        FilePath zipalign = this.findZipalignPath(workspace, run.getEnvironment(listener), listener.getLogger());
        for (Apk entry : this.entries) {
            Certificate[] certChain;
            PrivateKey key;
            char[] storePassword;
            StringTokenizer rpmGlobTokenizer = new StringTokenizer(entry.getSelection(), ",");
            StandardCertificateCredentials keyStoreCredential = this.getKeystore(entry.getKeyStore(), (Item)run.getParent());
            char[] keyPassword = storePassword = keyStoreCredential.getPassword().getPlainText().toCharArray();
            KeyStore keyStore = keyStoreCredential.getKeyStore();
            try {
                if (entry.getAlias() == null) {
                    // empty if block
                }
                key = (PrivateKey)keyStore.getKey(entry.getAlias(), keyPassword);
                certChain = keyStore.getCertificateChain(entry.getAlias());
            }
            catch (GeneralSecurityException e) {
                PrintWriter details = listener.fatalError("Error reading keystore " + entry.getKeyStore());
                e.printStackTrace(details);
                throw new AbortException("Error reading keystore " + entry.getKeyStore());
            }
            String v1SigName = entry.getAlias();
            if (v1SigName == null) {
                v1SigName = keyStoreCredential.getId();
            }
            while (rpmGlobTokenizer.hasMoreTokens()) {
                String rpmGlob = rpmGlobTokenizer.nextToken();
                Object[] matchedApks = workspace.list(rpmGlob);
                if (ArrayUtils.isEmpty((Object[])matchedApks)) {
                    throw new AbortException("No APKs in workspace matching " + rpmGlob);
                }
                for (Object apkPath : matchedApks) {
                    String unsignedPathName = apkPath.absolutize().getRemote();
                    String alignedPathName = unsignedPathName.replace("unsigned", "unsigned-aligned");
                    String signedPathName = alignedPathName.replace("unsigned-aligned", "signed");
                    ArgumentListBuilder zipalignCommand = new ArgumentListBuilder().add(zipalign.getRemote()).add("-f").add("-p").add("4").add(unsignedPathName).add(alignedPathName);
                    int zipalignResult = new Launcher.ProcStarter(launcher).cmds(zipalignCommand).pwd(workspace).stdout(listener).stderr((OutputStream)listener.getLogger()).join();
                    if (zipalignResult != 0) {
                        listener.fatalError("[SignApksBuilder] zipalign failed: exit code %d", new Object[]{zipalignResult});
                        throw new AbortException(String.format("zipalign failed on APK %s: exit code %d", unsignedPathName, zipalignResult));
                    }
                    FilePath alignedPath = workspace.child(alignedPathName);
                    if (!alignedPath.exists()) {
                        throw new AbortException(String.format("aligned APK does not exist: %s", alignedPathName));
                    }
                    listener.getLogger().printf("[SignApksBuilder] signing APK %s%n", alignedPathName);
                    SignApkCallable signApk = new SignApkCallable(key, certChain, v1SigName, signedPathName, listener);
                    alignedPath.act((FilePath.FileCallable)signApk);
                    listener.getLogger().printf("[SignApksBuilder] signed APK %s%n", signedPathName);
                    if (entry.getArchiveUnsignedApks()) {
                        listener.getLogger().printf("[SignApksBuilder] archiving unsigned APK %s%n", unsignedPathName);
                        apksToArchive.put(unsignedPathName, this.stripWorkspace(workspace, unsignedPathName));
                    }
                    if (!entry.getArchiveSignedApks()) continue;
                    listener.getLogger().printf("[SignApksBuilder] archiving signed APK %s%n", signedPathName);
                    apksToArchive.put(signedPathName, this.stripWorkspace(workspace, signedPathName));
                }
            }
        }
        listener.getLogger().println("[SignApksBuilder] finished signing APKs");
        if (apksToArchive.size() > 0) {
            run.pickArtifactManager().archive(workspace, launcher, BuildListenerAdapter.wrap((TaskListener)listener), apksToArchive);
        }
    }

    private String stripWorkspace(FilePath ws, String path) {
        return path.replace(ws.getRemote(), "");
    }

    private StandardCertificateCredentials getKeystore(String keyStoreName, Item item) {
        List creds = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, NO_REQUIREMENTS);
        return (StandardCertificateCredentials)CredentialsMatchers.firstOrNull((Iterable)creds, (CredentialsMatcher)CredentialsMatchers.withId((String)keyStoreName));
    }

    @Nonnull
    private FilePath findZipalignPath(FilePath workspace, EnvVars env, PrintStream logger) throws AbortException {
        List versionDirs;
        String zipalign = (String)env.get((Object)"ANDROID_ZIPALIGN");
        if (!StringUtils.isEmpty((String)zipalign)) {
            logger.printf("[SignApksBuilder] found zipalign path in env ANDROID_ZIPALIGN=%s%n", zipalign);
            return new FilePath(workspace.getChannel(), zipalign);
        }
        String androidHome = (String)env.get((Object)"ANDROID_HOME");
        if (StringUtils.isEmpty((String)androidHome)) {
            throw new AbortException("failed to find zipalign: no environment variable ANDROID_ZIPALIGN or ANDROID_HOME");
        }
        FilePath buildTools = new FilePath(workspace.getChannel(), androidHome).child("build-tools");
        try {
            versionDirs = buildTools.listDirectories();
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(String.format("failed to find zipalign: error listing build-tools versions in %s: %s", buildTools.getRemote(), e.getLocalizedMessage()));
        }
        if (versionDirs.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools directory in ANDROID_HOME path " + androidHome);
        }
        TreeMap<VersionNumber, FilePath> versions = new TreeMap<VersionNumber, FilePath>();
        for (FilePath versionDir : versionDirs) {
            String versionName = versionDir.getName();
            VersionNumber version = new VersionNumber(versionName);
            versions.put(version, versionDir);
        }
        if (versions.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools versions in ANDROID_HOME path " + buildTools);
        }
        VersionNumber latest = (VersionNumber)versions.lastKey();
        FilePath zipalignPath = (FilePath)versions.get(latest);
        zipalignPath = zipalignPath.child("zipalign");
        try {
            if (!zipalignPath.exists()) {
                throw new AbortException("failed to find zipalign: zipalign does not exist in latest build-tools path " + zipalignPath.getParent().getRemote());
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(String.format("failed to find zipalign: error listing build-tools versions in %s: %s", buildTools.getRemote(), e.getLocalizedMessage()));
        }
        logger.printf("[SignApksBuilder] found zipalign in Android SDK's latest build tools: %s%n", zipalignPath);
        return zipalignPath;
    }

    static class SignApkCallable
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final PrivateKey key;
        private final Certificate[] certChain;
        private final String v1SigName;
        private final String outputApk;
        private final TaskListener listener;

        SignApkCallable(PrivateKey key, Certificate[] certChain, String v1SigName, String outputApk, TaskListener listener) {
            this.key = key;
            this.certChain = certChain;
            this.v1SigName = v1SigName;
            this.outputApk = outputApk;
            this.listener = listener;
        }

        public Void invoke(File inputApkFile, VirtualChannel channel) throws IOException, InterruptedException {
            File outputApkFile = new File(this.outputApk);
            if (outputApkFile.isFile()) {
                this.listener.getLogger().printf("[SignApksBuilder] deleting previous signed APK %s%n", this.outputApk);
                if (!outputApkFile.delete()) {
                    throw new AbortException("failed to delete previous signed APK " + this.outputApk);
                }
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(this.certChain.length);
            for (Certificate cert : this.certChain) {
                certs.add((X509Certificate)cert);
            }
            ApkSigner.SignerConfig signerConfig = new ApkSigner.SignerConfig.Builder(this.v1SigName, this.key, certs).build();
            List<ApkSigner.SignerConfig> signerConfigs = Collections.singletonList(signerConfig);
            ApkSigner.Builder signerBuilder = new ApkSigner.Builder(signerConfigs).setInputApk(inputApkFile).setOutputApk(outputApkFile).setOtherSignersSignaturesPreserved(false).setV1SigningEnabled(true).setV2SigningEnabled(true);
            ApkSigner signer = signerBuilder.build();
            try {
                signer.sign();
            }
            catch (Exception e) {
                PrintWriter details = this.listener.fatalError("[SignApksBuilder] error signing APK %s", new Object[]{inputApkFile.getAbsolutePath()});
                e.printStackTrace(details);
                throw new AbortException("failed to sign APK " + inputApkFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            }
            return null;
        }
    }

    @Extension
    public static final class SignApksDescriptor
    extends BuildStepDescriptor<Builder> {
        public static final String DISPLAY_NAME = Messages.job_displayName();

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public SignApksDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public ListBoxModel doFillKeystoreItems(@AncestorInPath ItemGroup<?> parent) {
            if (parent == null) {
                parent = Jenkins.getInstance();
            }
            ListBoxModel items = new ListBoxModel();
            List keys = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (ItemGroup)parent, (Authentication)ACL.SYSTEM, (List)NO_REQUIREMENTS);
            for (StandardCertificateCredentials key : keys) {
                items.add(key.getDescription(), key.getId());
            }
            return items;
        }

        public FormValidation doCheckAlias(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckSelection(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, InterruptedException {
            FilePath someWorkspace = project.getSomeWorkspace();
            if (someWorkspace != null) {
                String msg = someWorkspace.validateAntFileMask(value, FilePath.VALIDATE_ANT_FILE_MASK_BOUND);
                if (msg != null) {
                    return FormValidation.error((String)msg);
                }
                return FormValidation.ok();
            }
            return FormValidation.warning((String)Messages.noworkspace());
        }
    }
}

