/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.jwtauth.impl;

import hudson.model.AbstractItem;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.User;
import java.security.Key;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.conjur.jenkins.configuration.GlobalConjurConfiguration;
import org.conjur.jenkins.exceptions.JwtException;
import org.conjur.jenkins.jwtauth.impl.JwtRsaDigitalSignatureKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JwtToken {
    private static final Logger LOGGER = Logger.getLogger(JwtToken.class.getName());
    private static final int DEFAULT_NOT_BEFORE_IN_SEC = 30;
    private static final String IDENTITY_FIELD_NAME_PATTERN = "^[a-zA-Z0-9\\-_\\\"]*$";
    private static final DateTimeFormatter ID_FORMAT = DateTimeFormatter.ofPattern("MMddkkmmss").withZone(ZoneId.systemDefault());
    private static final ConcurrentLinkedQueue<JwtRsaDigitalSignatureKey> keysQueue = new ConcurrentLinkedQueue();
    public final JSONObject claim = new JSONObject();

    public String sign() {
        try {
            JsonWebSignature jsonWebSignature = new JsonWebSignature();
            JwtRsaDigitalSignatureKey key = JwtToken.getCurrentSigningKey(this);
            jsonWebSignature.setPayload(this.claim.toString());
            jsonWebSignature.setKey((Key)key.toSigningKey());
            jsonWebSignature.setKeyIdHeaderValue(key.getId());
            jsonWebSignature.setAlgorithmHeaderValue("RS256");
            jsonWebSignature.setHeader("typ", "JWT");
            return jsonWebSignature.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new JwtException("Failed to sign JWT token: " + e.getMessage(), e);
        }
    }

    public static synchronized String getToken(Object context, GlobalConjurConfiguration globalConfig) {
        return JwtToken.getToken("SecretRetrieval", context, globalConfig);
    }

    public static synchronized String getToken(String pluginAction, Object context, GlobalConjurConfiguration globalConfig) {
        JwtToken unsignedToken = JwtToken.getUnsignedToken(pluginAction, context, globalConfig);
        if (unsignedToken != null) {
            return unsignedToken.sign();
        }
        return null;
    }

    public static synchronized JwtToken getUnsignedToken(String pluginAction, Object context, GlobalConjurConfiguration globalConfig) {
        String issuer;
        if (context == null) {
            LOGGER.log(Level.SEVERE, "Cannot get token for null context!");
            return null;
        }
        if (globalConfig == null) {
            LOGGER.log(Level.SEVERE, "Cannot get token because globalConfig is not set");
            return null;
        }
        Authentication authentication = Jenkins.getAuthentication();
        String userId = authentication.getName();
        User user = User.get((String)userId, (boolean)false, Collections.emptyMap());
        String fullName = null;
        if (user != null) {
            fullName = user.getFullName();
        }
        if ((issuer = Jenkins.get().getRootUrl()) != null && issuer.substring(issuer.length() - 1).equals("/")) {
            issuer = issuer.substring(0, issuer.length() - 1);
        }
        LOGGER.log(Level.FINEST, "RootURL => {0}", Jenkins.get().getRootUrl());
        JwtToken jwtToken = new JwtToken();
        jwtToken.claim.put("jti", (Object)UUID.randomUUID().toString().replace("-", ""));
        jwtToken.claim.put("aud", (Object)globalConfig.getJwtAudience());
        jwtToken.claim.put("iss", (Object)issuer);
        jwtToken.claim.put("name", (Object)fullName);
        long currentTime = System.currentTimeMillis() / 1000L;
        jwtToken.claim.put("iat", currentTime);
        jwtToken.claim.put("exp", currentTime + globalConfig.getTokenDurationInSeconds());
        jwtToken.claim.put("nbf", currentTime - 30L);
        ModelObject contextObject = (ModelObject)context;
        if (contextObject instanceof Run) {
            Run run = (Run)contextObject;
            jwtToken.claim.put("jenkins_build_number", run.getNumber());
            contextObject = run.getParent();
        }
        if (contextObject instanceof AbstractItem) {
            ItemGroup parent;
            if (contextObject instanceof Job) {
                Job job = (Job)contextObject;
                jwtToken.claim.put("jenkins_pronoun", (Object)job.getPronoun());
            } else {
                jwtToken.claim.put("jenkins_pronoun", (Object)((AbstractItem)contextObject).getPronoun());
            }
            AbstractItem item = (AbstractItem)contextObject;
            jwtToken.claim.put("jenkins_full_name", (Object)item.getFullName());
            jwtToken.claim.put("jenkins_name", (Object)item.getName());
            jwtToken.claim.put("jenkins_task_noun", (Object)item.getTaskNoun());
            if (item instanceof ItemGroup) {
                ItemGroup itemGroup = (ItemGroup)item;
                jwtToken.claim.put("jenkins_url_child_prefix", (Object)itemGroup.getUrlChildPrefix());
            }
            if (item instanceof Job) {
                Job job = (Job)item;
                jwtToken.claim.put("jenkins_job_buildir", (Object)job.getBuildDir().getAbsolutePath());
            }
            if ((parent = item.getParent()) instanceof AbstractItem) {
                item = (AbstractItem)parent;
                jwtToken.claim.put("jenkins_parent_full_name", (Object)item.getFullName());
                jwtToken.claim.put("jenkins_parent_name", (Object)item.getName());
                jwtToken.claim.put("jenkins_parent_task_noun", (Object)item.getTaskNoun());
                if (item instanceof ItemGroup) {
                    ItemGroup itemGroup = (ItemGroup)item;
                    jwtToken.claim.put("jenkins_parent_url_child_prefix", (Object)itemGroup.getUrlChildPrefix());
                }
                if (item instanceof Job) {
                    Job job = (Job)item;
                    jwtToken.claim.put("jenkins_parent_pronoun", (Object)job.getPronoun());
                }
            }
            boolean isEnabled = globalConfig.getEnableIdentityFormatFieldsFromToken();
            String identityFieldName = "";
            String separator = "";
            if (!isEnabled) {
                LOGGER.log(Level.FINE, "Disable JWT Simplified");
                List<String> identityFields = Arrays.asList(globalConfig.getIdentityFormatFieldsFromToken().split(","));
                String fieldSeparator = globalConfig.getSelectIdentityFieldsSeparator();
                ArrayList<String> identityValues = new ArrayList<String>(identityFields.size());
                for (String identityField : identityFields) {
                    String identityFieldValue = jwtToken.claim.has(identityField) ? jwtToken.claim.getString(identityField) : "";
                    identityValues.add(identityFieldValue);
                    LOGGER.log(Level.FINE, "getUnsignedToken() *** processed identity field:" + identityField + " and value:" + identityFieldValue);
                }
                identityFieldName = JwtToken.processIdentityFieldName(globalConfig.getidentityFieldName());
                LOGGER.log(Level.FINE, "end of processIdentityFieldName()) identityFieldName : " + identityFieldName);
                String identityFieldValue = StringUtils.join(identityValues, (String)fieldSeparator);
                jwtToken.claim.put(identityFieldName, (Object)identityFieldValue);
                jwtToken.claim.put("sub", (Object)identityFieldValue);
            } else {
                LOGGER.log(Level.FINE, "Enable JWT Simplified");
                List<String> identityFields = Arrays.asList(globalConfig.getSelectIdentityFormatToken().split("[-,+,|,:,.]"));
                ArrayList<String> identityValues = new ArrayList<String>(identityFields.size());
                String token = globalConfig.getSelectIdentityFormatToken();
                String parentField = identityFields.get(0);
                if (token.length() > parentField.length() + 1) {
                    separator = token.substring(parentField.length(), parentField.length() + 1);
                } else {
                    identityFields = Collections.singletonList(token);
                }
                for (String identityField : identityFields) {
                    String identityFieldValue = jwtToken.claim.has(identityField) ? jwtToken.claim.getString(identityField) : "";
                    identityValues.add(identityFieldValue);
                    LOGGER.log(Level.FINE, "getUnsignedToken() *** processed identity field:" + identityField + " and value:" + identityFieldValue);
                }
                jwtToken.claim.put("sub", (Object)StringUtils.join(identityValues, (String)separator));
            }
        } else if (contextObject instanceof Hudson) {
            jwtToken.claim.put("jenkins_pronoun", (Object)"Global");
            jwtToken.claim.put("jenkins_task_noun", (Object)"Build");
            jwtToken.claim.put("jenkins_parent_name", (Object)"/");
            jwtToken.claim.put("jenkins_name", (Object)"GlobalCredentials");
            jwtToken.claim.put("jenkins_full_name", (Object)"GlobalCredentials");
            jwtToken.claim.put("jenkins_parent_name", (Object)"/");
            jwtToken.claim.put("sub", (Object)"GlobalCredentials");
        }
        LOGGER.log(Level.FINEST, String.format("Claim : %s", jwtToken.claim.toString()));
        return jwtToken;
    }

    private static String processIdentityFieldName(String inputIdentityFiledName) {
        LOGGER.log(Level.FINE, "Start of processIdentityFieldName())");
        if (inputIdentityFiledName.matches(IDENTITY_FIELD_NAME_PATTERN)) {
            return inputIdentityFiledName;
        }
        return inputIdentityFiledName.replaceAll("[^a-zA-Z0-9\\-_\\\"]", "");
    }

    protected static synchronized JwtRsaDigitalSignatureKey getCurrentSigningKey(JwtToken jwtToken) {
        JwtRsaDigitalSignatureKey result = null;
        long currentTime = System.currentTimeMillis() / 1000L;
        long maxKeyTimeInSec = GlobalConjurConfiguration.get().getKeyLifetimeInMinutes() * 60L;
        Iterator<JwtRsaDigitalSignatureKey> iterator = keysQueue.iterator();
        while (iterator.hasNext()) {
            JwtRsaDigitalSignatureKey key = iterator.next();
            if (key != null) {
                if (currentTime - key.getCreationTime() < maxKeyTimeInSec) {
                    if (key.getCreationTime() + maxKeyTimeInSec <= jwtToken.claim.getLong("exp")) continue;
                    result = key;
                    break;
                }
                LOGGER.log(Level.FINEST, "getCurrentSigningKey() expired key lifetime ");
                result = null;
                iterator.remove();
                continue;
            }
            LOGGER.log(Level.FINEST, "getCurrentSigningKey() Empty key or key without public key ");
            result = null;
            iterator.remove();
        }
        if (result == null) {
            String id = ID_FORMAT.format(Instant.now());
            result = new JwtRsaDigitalSignatureKey(id);
            keysQueue.add(result);
        }
        return result;
    }

    protected static synchronized JSONObject getJwkset() {
        JSONObject jwks = new JSONObject();
        JSONArray keys = new JSONArray();
        long currentTime = System.currentTimeMillis() / 1000L;
        try {
            long maxKeyTimeInSec = GlobalConjurConfiguration.get().getKeyLifetimeInMinutes() * 60L;
            Iterator<JwtRsaDigitalSignatureKey> iterator = keysQueue.iterator();
            while (iterator.hasNext()) {
                JwtRsaDigitalSignatureKey key = iterator.next();
                if (key != null && key.getPublicKey() != null) {
                    if (currentTime - key.getCreationTime() < maxKeyTimeInSec) {
                        JSONObject jwk = new JSONObject();
                        jwk.put("kty", (Object)"RSA");
                        jwk.put("alg", (Object)"RS256");
                        jwk.put("kid", (Object)key.getId());
                        jwk.put("use", (Object)"sig");
                        jwk.put("key_ops", Collections.singleton("verify"));
                        jwk.put("n", (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(key.getPublicKey().getModulus().toByteArray()));
                        jwk.put("e", (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(key.getPublicKey().getPublicExponent().toByteArray()));
                        keys.put((Object)jwk);
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "getJwkset() after expire key lifetime ");
                    iterator.remove();
                    continue;
                }
                LOGGER.log(Level.FINEST, "getJwkset() Empty key or key without public key ");
                iterator.remove();
            }
            jwks.put("keys", (Object)keys);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return jwks;
    }
}

