/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.conjur.jenkins.conjursecrets.ConjurSecretFileCredentials;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurSecretFileCredentialsBinding
extends MultiBinding<ConjurSecretFileCredentials> {
    private String fileVariable;
    private String contentVariable;

    @DataBoundConstructor
    public ConjurSecretFileCredentialsBinding(String credentialsId) {
        super(credentialsId);
    }

    protected Class<ConjurSecretFileCredentials> type() {
        return ConjurSecretFileCredentials.class;
    }

    public String getFileVariable() {
        return this.fileVariable;
    }

    @DataBoundSetter
    public void setFileVariable(String fileVariable) {
        this.fileVariable = fileVariable;
    }

    public String getContentVariable() {
        return this.contentVariable;
    }

    @DataBoundSetter
    public void setContentVariable(String contentVariable) {
        this.contentVariable = contentVariable;
    }

    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        ConjurSecretFileCredentials credentials = (ConjurSecretFileCredentials)this.getCredentials(build);
        credentials.setContext((ModelObject)build);
        FilePath tempFile = workspace.createTextTempFile(this.getCredentialsId(), ".tmp", credentials.getSecret().getPlainText());
        build.addAction((Action)new CleanupAction(tempFile));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(this.fileVariable, tempFile.getRemote());
        env.put(this.contentVariable, tempFile.readToString());
        return new MultiBinding.MultiEnvironment(env);
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.fileVariable, this.contentVariable));
    }

    protected static class CleanupAction
    extends InvisibleAction {
        private final String path;

        CleanupAction(FilePath tempFile) {
            this.path = tempFile.getRemote();
        }

        public String getPath() {
            return this.path;
        }
    }

    @Extension
    public static class CleanupListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> run, TaskListener listener) {
            run.getActions(CleanupAction.class).forEach(cleanupAction -> {
                try {
                    new FilePath(new File(cleanupAction.getPath())).delete();
                }
                catch (Exception e) {
                    listener.error("Can't delete temp file: " + e.getMessage());
                }
            });
        }
    }

    @Symbol(value={"conjurSecretFile"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<ConjurSecretFileCredentials> {
        public String getDisplayName() {
            return "Conjur Secret File Credentials";
        }

        protected Class<ConjurSecretFileCredentials> type() {
            return ConjurSecretFileCredentials.class;
        }

        public boolean requiresWorkspace() {
            return true;
        }
    }
}

