/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.configuration;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.conjur.jenkins.configuration.GlobalConjurConfiguration;
import org.conjur.jenkins.jwtauth.impl.JwtToken;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ConjurConfiguration
extends AbstractDescribableImpl<ConjurConfiguration>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ConjurConfiguration.class.getName());
    private Boolean inheritFromParent = Boolean.TRUE;
    private static final long serialVersionUID = 1L;
    private String applianceURL;
    private String account;
    private String credentialID;
    private String certificateCredentialID;
    private CertificateCredentials certificateCredentials;
    private String ownerFullName;

    public ConjurConfiguration() {
    }

    @DataBoundConstructor
    public ConjurConfiguration(String applianceURL, String account) {
        this.applianceURL = applianceURL.endsWith("/") ? applianceURL.substring(0, applianceURL.length() - 1) : applianceURL;
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }

    public String getApplianceURL() {
        return this.applianceURL;
    }

    public String getCertificateCredentialID() {
        return this.certificateCredentialID;
    }

    public CertificateCredentials getCertificateCredentials() {
        return this.certificateCredentials;
    }

    public String getCredentialID() {
        return this.credentialID;
    }

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    public String getGlobalAuthenticator() {
        return GlobalConjurConfiguration.get().getSelectAuthenticator();
    }

    @DataBoundSetter
    public void setGlobalAuthenticator(String globalAuthenticator) {
    }

    @DataBoundSetter
    public void setAccount(String account) {
        this.account = account;
    }

    @DataBoundSetter
    public void setApplianceURL(String applianceURL) {
        this.applianceURL = applianceURL;
    }

    @DataBoundSetter
    public void setCertificateCredentialID(String certificateCredentialID) {
        this.certificateCredentialID = certificateCredentialID;
        if (certificateCredentialID == null) {
            LOGGER.log(Level.FINEST, "CertificationID is null");
            return;
        }
        this.certificateCredentials = (CertificateCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(CertificateCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)certificateCredentialID));
    }

    @DataBoundSetter
    public void setCertificateCredentials(CertificateCredentials certificateCredentials) {
        this.certificateCredentials = certificateCredentials;
    }

    @DataBoundSetter
    public void setCredentialID(String credentialID) {
        this.credentialID = credentialID;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    private static ListBoxModel fillCredentialIDItemsWithClass(Item item, String credentialsId, Class<? extends StandardCredentials> credentialClass) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return result.includeCurrentValue(credentialsId);
        }
        if (item != null && !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeAs(ACL.SYSTEM, item, credentialClass, URIRequirementBuilder.fromUri((String)credentialsId).build()).includeCurrentValue(credentialsId);
    }

    public Boolean getInheritFromParent() {
        return this.inheritFromParent;
    }

    @DataBoundSetter
    public void setInheritFromParent(Boolean inheritFromParent) {
        if (inheritFromParent == null) {
            this.inheritFromParent = Boolean.TRUE;
        }
        this.inheritFromParent = inheritFromParent;
    }

    public ConjurConfiguration(ConjurConfiguration config) {
        this.credentialID = config.getCredentialID();
        this.account = config.getAccount();
        this.ownerFullName = config.getOwnerFullName();
        this.certificateCredentialID = config.getCertificateCredentialID();
        this.applianceURL = config.getApplianceURL();
    }

    public ConjurConfiguration mergeWithParent(ConjurConfiguration parent) {
        if (parent == null) {
            return this;
        }
        ConjurConfiguration result = new ConjurConfiguration(this);
        if (StringUtils.isBlank((String)result.getAccount())) {
            result.setAccount(parent.getAccount());
        }
        if (StringUtils.isBlank((String)result.getOwnerFullName())) {
            result.setOwnerFullName(parent.getOwnerFullName());
        }
        if (StringUtils.isBlank((String)result.getCertificateCredentialID())) {
            result.setCertificateCredentialID(parent.getCertificateCredentialID());
        }
        if (StringUtils.isBlank((String)result.getCredentialID())) {
            result.setCredentialID(parent.getCredentialID());
        }
        if (result.certificateCredentials == null) {
            result.setCertificateCredentials(parent.getCertificateCredentials());
        }
        if (StringUtils.isBlank((String)result.getApplianceURL())) {
            result.setApplianceURL(parent.getApplianceURL());
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ConjurConfiguration> {
        public ListBoxModel doFillCertificateCredentialIDItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return ConjurConfiguration.fillCredentialIDItemsWithClass(item, credentialsId, StandardCertificateCredentials.class);
        }

        public ListBoxModel doFillCredentialIDItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return ConjurConfiguration.fillCredentialIDItemsWithClass(item, credentialsId, StandardUsernamePasswordCredentials.class);
        }

        public String getDisplayName() {
            return "Conjur Configuration";
        }

        @POST
        public FormValidation doObtainJwtToken(@AncestorInPath Item item) {
            GlobalConjurConfiguration globalConfig = GlobalConjurConfiguration.get();
            JwtToken token = JwtToken.getUnsignedToken("pluginAction", item, globalConfig);
            return FormValidation.ok((String)("JWT Token: \n" + token.claim.toString(4)));
        }
    }
}

