/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.api;

import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import okhttp3.OkHttpClient;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameSSHKeyCredentials;
import org.conjur.jenkins.exceptions.InvalidConjurSecretException;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class ConjurAPIUtils {
    public static final Logger LOGGER = Logger.getLogger(ConjurAPIUtils.class.getName());

    static synchronized CertificateCredentials certificateFromConfiguration(ConjurConfiguration configuration) {
        return configuration.getCertificateCredentials();
    }

    static synchronized OkHttpClient httpClientWithCertificate(CertificateCredentials certificate) {
        OkHttpClient client = null;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(certificate.getKeyStore(), certificate.getPassword().getPlainText().toCharArray());
            KeyManager[] kms = kmf.getKeyManagers();
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, null);
            Enumeration<String> e = certificate.getKeyStore().aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                trustStore.setCertificateEntry(alias, certificate.getKeyStore().getCertificate(alias));
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            sslContext.init(kms, tms, new SecureRandom());
            client = new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tms[0]).build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error configuring server certificates.", e);
        }
        return client;
    }

    public static synchronized OkHttpClient getHttpClient(ConjurConfiguration configuration) {
        CertificateCredentials certificate = ConjurAPIUtils.certificateFromConfiguration(configuration);
        if (certificate != null) {
            return ConjurAPIUtils.httpClientWithCertificate(certificate);
        }
        return new OkHttpClient.Builder().build();
    }

    public static StringBuffer getStringFromException(Exception e) {
        StringBuffer message = new StringBuffer();
        message.append(String.format("%s%s", e.getMessage(), System.lineSeparator()));
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            message.append(String.format("%s%s", stackTraceElement.toString(), System.lineSeparator()));
        }
        return message;
    }

    public static String defaultIfBlank(String value, String defaultValue) {
        if (value != null && value.length() > 0) {
            return value;
        }
        return defaultValue;
    }

    public static FormValidation validateCredential(ItemGroup<Item> context, ConjurSecretCredentials credential) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String secretValue = null;
        try {
            credential.setContext((ModelObject)context);
            if (credential instanceof ConjurSecretUsernameSSHKeyCredentials) {
                secretValue = ((ConjurSecretUsernameSSHKeyCredentials)credential).getPrivateKey();
            } else {
                LOGGER.log(Level.FINEST, String.format("Context set %s", context.getDisplayName()));
                Secret secret = credential.getSecret();
                secretValue = secret != null ? secret.getPlainText() : null;
            }
        }
        catch (InvalidConjurSecretException e) {
            try {
                Secret secret;
                credential.setContext((ModelObject)ConjurAPIUtils.getItemFromReferer());
                secretValue = credential instanceof ConjurSecretUsernameSSHKeyCredentials ? ((ConjurSecretUsernameSSHKeyCredentials)credential).getPrivateKey() : ((secret = credential.getSecret()) != null ? secret.getPlainText() : null);
                return FormValidation.ok((String)"Successfully retrieved secret string");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, String.format("FAILED to retrieve secret! Exception: %s", e));
                return FormValidation.error((String)("FAILED to retrieve secret: \n" + String.valueOf(e) + "\nPlease check Conjur configuration or add credentials from credentials page"));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, String.format("FAILED to retrieve secret! Exception: %s", e));
        }
        if (secretValue == null || secretValue.isEmpty()) {
            return FormValidation.error((String)"FAILED to retrieve secret!");
        }
        return FormValidation.ok((String)"Successfully retrieved secret string");
    }

    public static Item getItemFromReferer() throws URISyntaxException {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest != null) {
            String referer = currentRequest.getReferer();
            String jobPath = ConjurAPIUtils.extractJobPathFromUrl(new URI(referer).getPath());
            return Jenkins.get().getItemByFullName(jobPath);
        }
        return null;
    }

    protected static String extractJobPathFromUrl(String urlPath) {
        if (urlPath.contains("/job/")) {
            return Arrays.stream(urlPath.split("/job/")).filter(segment -> !segment.isEmpty()).map(segment -> segment.replaceAll("/.*", "")).collect(Collectors.joining("/"));
        }
        throw new IllegalArgumentException("Invalid job path: " + urlPath);
    }
}

