/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.api;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractItem;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang.StringUtils;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.api.ConjurAuthnInfo;
import org.conjur.jenkins.authenticator.AbstractAuthenticator;
import org.conjur.jenkins.authenticator.ConjurAPIKeyAuthenticator;
import org.conjur.jenkins.authenticator.ConjurJWTAuthenticator;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.configuration.ConjurJITJobProperty;
import org.conjur.jenkins.configuration.FolderConjurConfiguration;
import org.conjur.jenkins.configuration.GlobalConjurConfiguration;
import org.conjur.jenkins.configuration.TelemetryConfiguration;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentialsImpl;
import org.conjur.jenkins.conjursecrets.ConjurSecretDockerCertCredentialsImpl;
import org.conjur.jenkins.conjursecrets.ConjurSecretFileCredentialsImpl;
import org.conjur.jenkins.conjursecrets.ConjurSecretStringCredentialsImpl;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameCredentialsImpl;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameSSHKeyCredentialsImpl;
import org.conjur.jenkins.exceptions.AuthenticationConjurException;
import org.conjur.jenkins.exceptions.InvalidConjurSecretException;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class ConjurAPI {
    private static final Logger LOGGER = Logger.getLogger(ConjurAPI.class.getName());
    private static AbstractAuthenticator authenticator = null;

    private ConjurAPI() {
    }

    private static void defaultToEnvironment(ConjurAuthnInfo conjurAuthn) {
        Map<String, String> env = System.getenv();
        if (conjurAuthn.getApplianceUrl() == null && env.containsKey("CONJUR_APPLIANCE_URL")) {
            conjurAuthn.setApplianceUrl(env.get("CONJUR_APPLIANCE_URL"));
        }
        if (conjurAuthn.getAccount() == null && env.containsKey("CONJUR_ACCOUNT")) {
            conjurAuthn.setAccount(env.get("CONJUR_ACCOUNT"));
        }
        if (conjurAuthn.getLogin() == null && env.containsKey("CONJUR_AUTHN_LOGIN")) {
            conjurAuthn.setLogin(env.get("CONJUR_AUTHN_LOGIN"));
        }
        if (conjurAuthn.getApiKey() == null && env.containsKey("CONJUR_AUTHN_API_KEY")) {
            conjurAuthn.setApiKey(env.get("CONJUR_AUTHN_API_KEY").getBytes(StandardCharsets.US_ASCII));
        }
    }

    public static AbstractAuthenticator getAuthenticatorByName(String name) {
        AbstractAuthenticator chosenAuthenticator = null;
        if (name != null) {
            if (name.equalsIgnoreCase("JWT")) {
                chosenAuthenticator = new ConjurJWTAuthenticator();
            } else if (name.equalsIgnoreCase("APIKey")) {
                chosenAuthenticator = new ConjurAPIKeyAuthenticator();
            }
        }
        return chosenAuthenticator;
    }

    private static void setAuthenticator() {
        GlobalConjurConfiguration globalConfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
        if (globalConfig != null) {
            if (authenticator == null) {
                authenticator = ConjurAPI.getAuthenticatorByName(globalConfig.getSelectAuthenticator());
            } else if (!authenticator.getName().equalsIgnoreCase(globalConfig.getSelectAuthenticator())) {
                authenticator = ConjurAPI.getAuthenticatorByName(globalConfig.getSelectAuthenticator());
            }
        }
        if (authenticator == null) {
            authenticator = new ConjurAPIKeyAuthenticator();
        }
        LOGGER.log(Level.FINEST, String.format("Authenticator set to: %s", authenticator.getName()));
    }

    @SuppressFBWarnings
    public static byte[] getAuthorizationToken(ConjurAuthnInfo conjurAuthn, ModelObject context) throws IOException {
        ConjurAPI.setAuthenticator();
        return authenticator.getAuthorizationToken(conjurAuthn, context);
    }

    public static ConjurAuthnInfo getConjurAuthnInfo(ConjurConfiguration configuration, ModelObject context) {
        if (authenticator == null) {
            ConjurAPI.setAuthenticator();
        }
        ConjurAuthnInfo conjurAuthn = new ConjurAuthnInfo();
        conjurAuthn.setConjurConfiguration(configuration);
        ConjurAPI.defaultToEnvironment(conjurAuthn);
        if (configuration != null) {
            String account;
            String applianceUrl = configuration.getApplianceURL();
            if (applianceUrl != null && !applianceUrl.isEmpty()) {
                conjurAuthn.setApplianceUrl(applianceUrl);
            }
            if ((account = configuration.getAccount()) != null && !account.isEmpty()) {
                conjurAuthn.setAccount(account);
            }
            conjurAuthn.setAuthnPath("authn");
        }
        authenticator.fillAuthnInfo(conjurAuthn, context);
        return conjurAuthn;
    }

    @SuppressFBWarnings
    public static byte[] getConjurSecret(OkHttpClient client, ConjurConfiguration configuration, byte[] authToken, String variableId) throws IOException {
        LOGGER.log(Level.FINEST, String.format("getConjurSecret: variable name %s", variableId));
        String formattedUrl = String.format("%s/secrets/%s/variable/%s", configuration.getApplianceURL(), configuration.getAccount(), variableId);
        Request request = new Request.Builder().url(formattedUrl).get().addHeader("x-cybr-telemetry", TelemetryConfiguration.getTelemetryHeader()).addHeader("Authorization", "Token token=\"" + new String(authToken, StandardCharsets.US_ASCII) + "\"").build();
        Response response = client.newCall(request).execute();
        byte[] result = new byte[]{};
        ResponseBody body = response.body();
        if (body != null) {
            result = body.bytes();
        }
        LOGGER.log(Level.FINEST, () -> "getConjurSecret: Fetch secret from Conjur response code " + response.code() + " - " + response.message());
        if (response.code() != 200) {
            if (response.code() == 404) {
                throw new AuthenticationConjurException("No access");
            }
            throw new IOException(String.format("Error fetching secret from Conjur [%d - %s] %s", response.code(), response.message(), new String(result)));
        }
        return result;
    }

    public static ConjurConfiguration logConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        if (conjurConfiguration != null) {
            LOGGER.log(Level.FINEST, "Conjur configuration provided");
            LOGGER.log(Level.FINEST, "Conjur Configuration Appliance Url:{0} ", conjurConfiguration.getApplianceURL());
            LOGGER.log(Level.FINEST, "Conjur Configuration Account: {0}", conjurConfiguration.getAccount());
            LOGGER.log(Level.FINEST, "Conjur Configuration credential ID:{0} ", conjurConfiguration.getCredentialID());
        }
        return conjurConfiguration;
    }

    public static ConjurConfiguration getConjurConfig(@NonNull ItemGroup<?> itemGroup) {
        ConjurConfiguration resultingConfig = null;
        ItemGroup g = itemGroup;
        while (g instanceof AbstractFolder) {
            FolderConjurConfiguration folderProperty = (FolderConjurConfiguration)((AbstractFolder)g).getProperties().get(FolderConjurConfiguration.class);
            if (folderProperty != null) {
                if (folderProperty.getConjurConfiguration() != null && !folderProperty.getInheritFromParent().booleanValue()) {
                    return resultingConfig;
                }
                resultingConfig = resultingConfig != null ? resultingConfig.mergeWithParent(folderProperty.getConjurConfiguration()) : folderProperty.getConjurConfiguration();
            }
            g = ((AbstractFolder)g).getParent();
        }
        GlobalConjurConfiguration globalConfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
        if (globalConfig != null) {
            resultingConfig = resultingConfig == null ? globalConfig.getConjurConfiguration() : resultingConfig.mergeWithParent(globalConfig.getConjurConfiguration());
        }
        if (resultingConfig == null) {
            LOGGER.log(Level.SEVERE, "Missing configuration for Conjur Plugin");
        } else if (StringUtils.isEmpty((String)resultingConfig.getAccount())) {
            LOGGER.log(Level.SEVERE, "Conjur Plugin missing Account field to be configured");
        } else if (StringUtils.isEmpty((String)resultingConfig.getApplianceURL())) {
            LOGGER.log(Level.SEVERE, "Conjur Plugin require ConjurURL field to be configured");
        } else if (globalConfig != null && globalConfig.getSelectAuthenticator().equals("APIKey") && StringUtils.isEmpty((String)resultingConfig.getCredentialID())) {
            LOGGER.log(Level.SEVERE, "Credentials not set for APIKey authenticator");
        }
        return resultingConfig;
    }

    public static ConjurConfiguration getConfigurationFromContext(ModelObject context) {
        ConjurConfiguration returnConfig = null;
        ConjurConfiguration conjurJobConfig = null;
        LOGGER.log(Level.FINEST, String.format("getConfigurationFromContext for context: %s", context));
        if (context != null) {
            GlobalConjurConfiguration globalConfig;
            if (context instanceof Hudson && (globalConfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class)) != null && globalConfig.getConjurConfiguration() != null) {
                return globalConfig.getConjurConfiguration();
            }
            if (context instanceof Run) {
                Run run = (Run)context;
                Job job = run.getParent();
                ConjurJITJobProperty conjurJITConfig = (ConjurJITJobProperty)run.getParent().getProperty(ConjurJITJobProperty.class);
                if (conjurJITConfig != null) {
                    conjurJobConfig = conjurJITConfig.getConjurConfiguration();
                }
                returnConfig = conjurJobConfig != null ? (conjurJobConfig.getInheritFromParent().booleanValue() ? conjurJobConfig.mergeWithParent(ConjurAPI.getConjurConfig(job.getParent())) : conjurJobConfig) : ConjurAPI.getConjurConfig(job.getParent());
            } else if (context instanceof WorkflowJob) {
                WorkflowJob cont = (WorkflowJob)context;
                ConjurJITJobProperty cjitjobprop = (ConjurJITJobProperty)cont.getProperty(ConjurJITJobProperty.class);
                returnConfig = cjitjobprop != null && cjitjobprop.getConjurConfiguration() != null ? cjitjobprop.getConjurConfiguration() : new ConjurConfiguration();
                ConjurConfiguration foldconf = ConjurAPI.getConjurConfig(((WorkflowJob)context).getParent());
                returnConfig = returnConfig.mergeWithParent(foldconf);
            } else if (context instanceof AbstractFolder) {
                returnConfig = ConjurAPI.getConjurConfig((ItemGroup)context);
            } else if (context instanceof AbstractItem) {
                AbstractItem abstractItem = (AbstractItem)context;
                returnConfig = ConjurAPI.getConjurConfig(abstractItem.getParent());
            }
        }
        LOGGER.log(Level.FINEST, String.format("getConfigurationFromContext for context END: returnConfig %s", returnConfig));
        return returnConfig;
    }

    public static Collection<StandardCredentials> getCredentialsForContext(@NonNull Class<?> type, ModelObject context) throws Exception {
        ConjurAuthnInfo conjurAuthn;
        LOGGER.log(Level.FINEST, String.format("getCredentialsForContext: %s", context.getDisplayName()));
        ArrayList<StandardCredentials> allCredentials = new ArrayList<StandardCredentials>();
        if (authenticator == null) {
            ConjurAPI.setAuthenticator();
        }
        ConjurConfiguration conjurConfiguration = ConjurAPI.getConfigurationFromContext(context);
        byte[] authToken = null;
        try {
            conjurAuthn = ConjurAPI.getConjurAuthnInfo(conjurConfiguration, context);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Cannot generate AuthnInfo. Exception: %s", e));
            return null;
        }
        try {
            authToken = ConjurAPI.getAuthorizationToken(conjurAuthn, context);
        }
        catch (AuthenticationConjurException exc) {
            LOGGER.log(Level.SEVERE, String.format("Authentication failed. Cannot get token from Conjur for context: %s", context.getDisplayName()));
            return null;
        }
        catch (SSLPeerUnverifiedException pve) {
            LOGGER.log(Level.SEVERE, String.format("Cannot get authentication token from Conjur. SSL Peer Unverified url: %s", conjurAuthn.getApplianceUrl()));
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Cannot get authentication token from Conjur. Exception: %s", e));
            return null;
        }
        String requestUrl = String.format("%s/resources/%s?kind=variable", conjurAuthn.getApplianceUrl(), conjurAuthn.getAccount());
        Request request = new Request.Builder().url(requestUrl).get().addHeader("x-cybr-telemetry", TelemetryConfiguration.getTelemetryHeader()).addHeader("Authorization", "Token token=\"" + new String(authToken, StandardCharsets.US_ASCII) + "\"").build();
        OkHttpClient client = ConjurAPIUtils.getHttpClient(conjurConfiguration);
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            String respBodyString = responseBody.string();
            LOGGER.log(Level.FINEST, String.format("ConjurAPI RESULT => %s request %s", respBodyString, requestUrl));
            if (response.code() != 200) {
                LOGGER.log(Level.FINEST, String.format("Error fetching variables from Conjur [%d - %s] : %s", response.code(), response.message(), respBodyString));
                throw new IOException(String.format("Error fetching variables from Conjur [%d - %s] : %s", response.code(), response.message(), respBodyString));
            }
            JSONArray resultResources = new JSONArray(respBodyString);
            for (int i = 0; i < resultResources.length(); ++i) {
                JSONObject resource = resultResources.getJSONObject(i);
                String variableId = resource.getString("id").split(":")[2];
                JSONArray annotations = resource.getJSONArray("annotations");
                String userName = null;
                String credentialType = null;
                block29: for (int j = 0; j < annotations.length(); ++j) {
                    JSONObject annotation = annotations.getJSONObject(j);
                    switch (annotation.getString("name").toLowerCase()) {
                        case "jenkins_credential_username": {
                            userName = annotation.getString("value");
                            continue block29;
                        }
                        case "jenkins_credential_type": {
                            credentialType = annotation.getString("value").toLowerCase();
                            continue block29;
                        }
                    }
                }
                if (credentialType == null) {
                    credentialType = userName == null ? "credential" : "usernamecredential";
                }
                ConjurSecretCredentialsImpl credential = new ConjurSecretCredentialsImpl(CredentialsScope.GLOBAL, variableId, variableId, "CyberArk Conjur Provided");
                credential.setContext(context);
                credential.setInheritedContext(context);
                allCredentials.add(credential);
                switch (credentialType) {
                    case "usernamecredential": {
                        ConjurSecretUsernameCredentialsImpl usernameCredential = new ConjurSecretUsernameCredentialsImpl(CredentialsScope.GLOBAL, "username-" + variableId, userName, variableId, "CyberArk Conjur Provided");
                        usernameCredential.setContext(context);
                        usernameCredential.setInheritedContext(context);
                        if (!type.isInstance(usernameCredential)) break;
                        allCredentials.add(usernameCredential);
                        break;
                    }
                    case "stringcredential": {
                        ConjurSecretStringCredentialsImpl stringCredential = new ConjurSecretStringCredentialsImpl(CredentialsScope.GLOBAL, "string-" + variableId, variableId, "CyberArk Conjur Provided");
                        stringCredential.setContext(context);
                        stringCredential.setInheritedContext(context);
                        if (!type.isInstance(stringCredential)) break;
                        allCredentials.add(stringCredential);
                        break;
                    }
                    case "usernamesshkeycredential": {
                        ConjurSecretUsernameSSHKeyCredentialsImpl usernameSSHKeyCredential = new ConjurSecretUsernameSSHKeyCredentialsImpl(CredentialsScope.GLOBAL, "usernamesshkey-" + variableId, userName, variableId, null, "CyberArk Conjur Provided");
                        usernameSSHKeyCredential.setContext(context);
                        usernameSSHKeyCredential.setInheritedContext(context);
                        if (!type.isInstance(usernameSSHKeyCredential)) break;
                        allCredentials.add(usernameSSHKeyCredential);
                        break;
                    }
                    case "filecredential": {
                        ConjurSecretFileCredentialsImpl fileCredential = new ConjurSecretFileCredentialsImpl(CredentialsScope.GLOBAL, "file-" + variableId, "CyberArk Conjur Provided", variableId);
                        fileCredential.setContext(context);
                        fileCredential.setInheritedContext(context);
                        if (!type.isInstance(fileCredential)) break;
                        allCredentials.add(fileCredential);
                        break;
                    }
                    case "dockercertcredential": {
                        ConjurSecretDockerCertCredentialsImpl dockerCertCredential = new ConjurSecretDockerCertCredentialsImpl(CredentialsScope.GLOBAL, "docker-cert-" + variableId, variableId, variableId + "/key", variableId + "/cert", variableId + "/ca");
                        dockerCertCredential.setContext(context);
                        dockerCertCredential.setInheritedContext(context);
                        if (!type.isInstance(dockerCertCredential)) break;
                        allCredentials.add(dockerCertCredential);
                        break;
                    }
                }
                LOGGER.log(Level.FINEST, String.format("[getCredentialsForContext] Path: %s  userName:[%s]  credentialType:[%s]", variableId, userName, credentialType));
            }
        } else {
            throw new IOException("Error fetching variables from Conjur");
        }
        LOGGER.log(Level.FINEST, String.format("%d credentials returned", allCredentials.size()));
        return allCredentials;
    }

    public static Secret getSecretFromConjur(ModelObject context, ModelObject inheritedObjectContext, String variableId) {
        Secret retSecret = null;
        try {
            ConjurConfiguration conjurConfiguration = ConjurAPI.getConfigurationFromContext(context);
            if (context != null) {
                ConjurAuthnInfo conjurAuthn = inheritedObjectContext == null ? ConjurAPI.getConjurAuthnInfo(conjurConfiguration, context) : ConjurAPI.getConjurAuthnInfo(conjurConfiguration, inheritedObjectContext);
                byte[] authToken = ConjurAPI.getAuthorizationToken(conjurAuthn, context);
                OkHttpClient client = ConjurAPIUtils.getHttpClient(conjurConfiguration);
                byte[] result = ConjurAPI.getConjurSecret(client, conjurConfiguration, authToken, variableId);
                retSecret = Secret.fromString((String)new String(result, StandardCharsets.UTF_8));
                Arrays.fill(authToken, (byte)0);
                Arrays.fill(result, (byte)0);
            }
        }
        catch (IOException ie) {
            throw new InvalidConjurSecretException(ie.getMessage(), ie);
        }
        catch (Exception e) {
            throw new InvalidConjurSecretException(e.getMessage(), e);
        }
        return retSecret;
    }

    public static boolean isInheritanceOn(ModelObject context) {
        boolean inheritanceOn = true;
        if (context instanceof Job) {
            try {
                Job run = (Job)context;
                ConjurJITJobProperty conjurJITConfig = (ConjurJITJobProperty)run.getProperty(ConjurJITJobProperty.class);
                if (conjurJITConfig != null && conjurJITConfig.getConjurConfiguration() != null && !conjurJITConfig.getConjurConfiguration().getInheritFromParent().booleanValue()) {
                    LOGGER.log(Level.FINEST, "There is no config assigned to Job/Item. Inheritance is off.");
                    inheritanceOn = false;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Cannot get properties for Job/Item");
            }
        } else if (context instanceof AbstractFolder) {
            try {
                FolderConjurConfiguration fc = (FolderConjurConfiguration)((AbstractFolder)context).getProperties().get(FolderConjurConfiguration.class);
                if (fc != null && !fc.getInheritFromParent().booleanValue()) {
                    inheritanceOn = false;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Cannot get properties for AbstractFolder");
            }
        }
        return inheritanceOn;
    }

    public static Secret getSecretFromConjurWithInheritance(ModelObject context, ConjurSecretCredentials credentials, String variableId) {
        Secret retSecret = null;
        String contextName = "null";
        if (context == null) {
            LOGGER.log(Level.FINEST, "No context set for function getSecretWithInheritance");
            StaplerRequest currentRequest = Stapler.getCurrentRequest();
            if (currentRequest != null) {
                context = (ModelObject)currentRequest.findAncestorObject(ModelObject.class);
                if (context == null) {
                    LOGGER.log(Level.FINEST, "No context available for current request");
                    context = Jenkins.get();
                }
                if (context != null) {
                    contextName = context.getDisplayName();
                }
            }
        }
        LOGGER.log(Level.FINEST, String.format("Get Secret with inheritance for context: %s", contextName));
        try {
            while (true) {
                try {
                    LOGGER.log(Level.FINEST, String.format("Get config context %s", contextName));
                    ConjurConfiguration conjurConfiguration = ConjurAPI.getConfigurationFromContext(context);
                    ConjurAuthnInfo conjurAuthn = ConjurAPI.getConjurAuthnInfo(conjurConfiguration, context);
                    byte[] authToken = ConjurAPI.getAuthorizationToken(conjurAuthn, context);
                    OkHttpClient client = ConjurAPIUtils.getHttpClient(conjurConfiguration);
                    byte[] result = ConjurAPI.getConjurSecret(client, conjurConfiguration, authToken, variableId);
                    retSecret = Secret.fromString((String)new String(result, StandardCharsets.UTF_8));
                    credentials.setContext(context);
                    Arrays.fill(authToken, (byte)0);
                    Arrays.fill(result, (byte)0);
                }
                catch (AuthenticationConjurException e) {
                    if (ConjurAPI.isInheritanceOn(context)) {
                        LOGGER.log(Level.FINEST, "Get config context exception: " + context.getDisplayName() + " " + String.valueOf(context));
                        if (context instanceof Run) {
                            Run run = (Run)context;
                            Job job = run.getParent();
                            context = job.getParent();
                            continue;
                        }
                        if (context instanceof Job) {
                            context = ((Job)context).getParent();
                            continue;
                        }
                        if (context instanceof AbstractFolder) {
                            context = ((AbstractFolder)context).getParent();
                            continue;
                        }
                        if (!(context instanceof Hudson)) continue;
                        LOGGER.log(Level.FINEST, "Get config context Invalid when inheritance is on!");
                        throw new InvalidConjurSecretException(e.getMessage(), e);
                    }
                    if (context instanceof Hudson) {
                        LOGGER.log(Level.FINEST, "Get config context Invalid!");
                        throw new InvalidConjurSecretException(e.getMessage(), e);
                    }
                    context = Jenkins.get();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new InvalidConjurSecretException(e.getMessage(), e);
        }
        return retSecret;
    }
}

