/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.conjur.jenkins.credentials.ConjurCredentialProvider;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.ExportedBean;

public class ConjurCredentialStore
extends CredentialsStore {
    private static final Logger LOGGER = Logger.getLogger(ConjurCredentialStore.class.getName());
    private static ConcurrentHashMap<String, ConjurCredentialStore> allStores = new ConcurrentHashMap();
    private final ConjurCredentialProvider provider;
    private final ModelObject context;
    private final ConjurCredentialStoreAction action;

    public ConjurCredentialStore(ConjurCredentialProvider provider, ModelObject context) {
        super(ConjurCredentialProvider.class);
        this.provider = provider;
        this.context = context;
        this.action = new ConjurCredentialStoreAction(this, context);
    }

    public static ConcurrentMap<String, ConjurCredentialStore> getAllStores() {
        return allStores;
    }

    @Nonnull
    public ModelObject getContext() {
        return this.context;
    }

    public boolean hasPermission(@Nonnull Authentication authentication, @Nonnull Permission permission) {
        LOGGER.log(Level.FINE, "***** Conjur CredentialStore hasPermission() ");
        boolean isAdmin = Jenkins.get().getACL().hasPermission2(authentication.toSpring(), Jenkins.ADMINISTER);
        boolean hasCredentialsView = Jenkins.get().getACL().hasPermission2(authentication.toSpring(), CredentialsProvider.VIEW);
        LOGGER.log(Level.FINE, "Checking permissions for the user: " + authentication.getName());
        LOGGER.log(Level.FINE, "Admin permission: " + isAdmin);
        LOGGER.log(Level.FINE, "Credentials view permission: " + hasCredentialsView);
        if (!CredentialsProvider.VIEW.equals((Object)permission)) {
            return false;
        }
        if (!hasCredentialsView && !isAdmin) {
            Item currentItem = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            if (currentItem == null) {
                LOGGER.log(Level.WARNING, "Unable to determine the current item for permission check ");
                return false;
            }
            LOGGER.log(Level.FINE, "Current item: " + currentItem.getFullName());
            boolean hasItemViewPermission = currentItem.getACL().hasPermission2(authentication.toSpring(), CredentialsProvider.VIEW);
            LOGGER.log(Level.FINE, "Non-admin user for the current Jenkins item: " + currentItem.getFullName() + " - " + hasItemViewPermission);
            return hasItemViewPermission;
        }
        return isAdmin || hasCredentialsView;
    }

    @Nonnull
    public List<Credentials> getCredentials(@Nonnull Domain domain) {
        LOGGER.log(Level.FINE, "***** Conjur CredentialStore getCredentials() ");
        Authentication authentication = Jenkins.getAuthentication();
        if (!this.hasPermission(authentication, CredentialsProvider.VIEW)) {
            LOGGER.log(Level.FINE, "User: " + authentication.getName() + " does not have permission to view credentials.");
            return Collections.emptyList();
        }
        if (Domain.global().equals((Object)domain)) {
            return this.provider.getCredentials(Credentials.class, (ItemGroup)Jenkins.get(), ACL.SYSTEM);
        }
        return Collections.emptyList();
    }

    public boolean addCredentials(@Nonnull Domain domain, @Nonnull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not add credentials to Conjur");
    }

    public boolean removeCredentials(@Nonnull Domain domain, @Nonnull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not remove credentials from Conjur");
    }

    public boolean updateCredentials(@Nonnull Domain domain, @Nonnull Credentials current, @Nonnull Credentials replacement) {
        throw new UnsupportedOperationException("Jenkins may not update credentials in Conjur");
    }

    @Nullable
    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    @ExportedBean
    public static class ConjurCredentialStoreAction
    extends CredentialsStoreAction {
        private static final String ICON_CLASS = "icon-conjur-credentials-store";
        private final ConjurCredentialStore store;

        private ConjurCredentialStoreAction(ConjurCredentialStore store, ModelObject context) {
            this.store = store;
            this.addIcons();
        }

        private void addIcons() {
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-sm", "conjur-credentials/images/conjur-credential-store-sm.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-md", "conjur-credentials/images/conjur-credential-store-md.png", "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-lg", "conjur-credentials/images/conjur-credential-store-lg.png", "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-xlg", "conjur-credentials/images/conjur-credential-store-xlg.png", "width: 48px; height: 48px;", IconType.PLUGIN));
        }

        @Nonnull
        public ConjurCredentialStore getStore() {
            return this.store;
        }

        public String getIconFileName() {
            return this.isVisible() ? "/plugin/conjur-credentials/images/conjur-credential-store-lg.png" : null;
        }

        public String getIconClassName() {
            return this.isVisible() ? ICON_CLASS : null;
        }

        public String getDisplayName() {
            return "Conjur Credential Store";
        }
    }
}

